/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.Stack;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.util.Token;

public final class JsonW3Converter
extends JsonConverter {
    private final Stack<Value> stack = new Stack();
    private final Stack<ArrayBuilder> arrays = new Stack();
    private final Stack<MapBuilder> maps = new Stack();

    JsonW3Converter(JsonParserOptions opts) throws QueryException {
        super(opts);
        JsonParserOptions.JsonDuplicates dupl = this.jopts.get(JsonParserOptions.DUPLICATES);
        if (dupl == JsonParserOptions.JsonDuplicates.RETAIN) {
            throw QueryError.OPTION_JSON_X.get(null, new Object[]{JsonParserOptions.DUPLICATES.name(), dupl});
        }
    }

    @Override
    protected void init(String uri) {
    }

    @Override
    public Item finish() {
        Value value = this.stack.pop();
        return value.isEmpty() ? Empty.VALUE : (Item)value;
    }

    @Override
    protected void openObject() {
        this.maps.push(new MapBuilder());
    }

    @Override
    protected void openPair(byte[] key, boolean add) {
        this.stack.push(Str.get(this.shared.token(key)));
    }

    @Override
    protected void closePair(boolean add) throws QueryException {
        Value value = this.stack.pop();
        Item key = (Item)this.stack.pop();
        if (add) {
            this.maps.peek().put(key, value);
        }
    }

    @Override
    protected void closeObject() {
        this.stack.push(this.maps.pop().map());
    }

    @Override
    protected void openArray() {
        this.arrays.push(new ArrayBuilder(this.job));
    }

    @Override
    protected void openItem() {
    }

    @Override
    protected void closeItem() {
        this.arrays.peek().add(this.stack.pop());
    }

    @Override
    protected void closeArray() {
        this.stack.push(this.arrays.pop().array());
    }

    @Override
    public void numberLit(byte[] value) throws QueryException {
        this.stack.push(this.numberParser != null ? (Value)this.numberParser.apply(value) : Dbl.get(Dbl.parse(value, null)));
    }

    @Override
    public void stringLit(byte[] value) {
        this.stack.push(Str.get(this.shared.token(value)));
    }

    @Override
    public void nullLit() {
        this.stack.push(this.nullValue);
    }

    @Override
    public void booleanLit(byte[] value) {
        this.stack.push(Bln.get(Token.eq(value, Token.TRUE)));
    }
}

