/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.item;

import java.util.BitSet;

public class TokenSet {
    private BitSet set;

    public TokenSet() {
        this.set = new BitSet();
    }

    public TokenSet(int token) {
        this();
        this.set.set(token + 1);
    }

    public TokenSet(TokenSet other) {
        this.set = (BitSet)other.set.clone();
    }

    public boolean contains(int token) {
        return this.set.get(token + 1);
    }

    public boolean containsAll(TokenSet other) {
        BitSet intersection = (BitSet)this.set.clone();
        intersection.and(other.set);
        return intersection.equals(other.set);
    }

    public void add(int token) {
        this.set.set(token + 1);
    }

    public void addAll(TokenSet other) {
        this.set.or(other.set);
    }

    public void remove(int token) {
        this.set.clear(token + 1);
    }

    public int nextToken(int token) {
        return this.set.nextSetBit(token + 1) - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        String delimiter = "";
        int token = this.set.nextSetBit(0);
        while (token >= 0) {
            sb.append(delimiter).append(token == 0 ? "\u03b5" : Integer.valueOf(token));
            delimiter = ", ";
            token = this.set.nextSetBit(token + 1);
        }
        return sb.append("}").toString();
    }
}

