/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;
import org.w3c.dom.Attr;

public final class FAttr
extends FNode {
    private final QNm name;
    private final byte[] value;

    public FAttr(QNm name, byte[] value) {
        super(NodeType.ATTRIBUTE);
        this.name = name;
        this.value = value;
    }

    public FAttr(Attr attr) {
        this(new QNm(attr.getName()), Token.token(attr.getValue()));
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public byte[] string() {
        return this.value;
    }

    @Override
    public FAttr materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) {
        return this.materialized(test, ii) ? this : new FAttr(this.name, this.value);
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.name.uri()).add(0).finish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FAttr)) return false;
        FAttr f = (FAttr)obj;
        if (!this.name.eq(f.name)) return false;
        if (!Token.eq(this.value, f.value)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string(), "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.concat(this.name.string(), "=", QueryString.toQuoted(this.value));
    }
}

