/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.io.IOException;
import java.util.HashMap;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.basex.core.Stores;
import org.basex.data.Data;
import org.basex.io.out.DataOutput;
import org.basex.query.CompileContext;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryBiPredicate;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.XQStruct;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQSingletonMap;
import org.basex.query.value.map.XQTrieMap;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;

public abstract class XQMap
extends XQStruct {
    XQMap(Type type) {
        super(type);
    }

    public static XQMap empty() {
        return XQTrieMap.EMPTY;
    }

    public static XQMap get(Item key, Value value) {
        return new XQSingletonMap(key, value);
    }

    @Override
    public final void write(DataOutput out) throws IOException, QueryException {
        out.writeNum((int)this.structSize());
        for (Item key : this.keys()) {
            Stores.write(out, key);
            Stores.write(out, this.get(key));
        }
    }

    @Override
    public final void refineType(Expr expr) {
        if (this != XQMap.empty()) {
            super.refineType(expr);
        }
    }

    @Override
    public final void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.forEach((Item key, Value value) -> {
            key.cache(lazy, ii);
            value.cache(lazy, ii);
        });
    }

    @Override
    public final Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        return this.get(XQMap.key(args[0], qc, ii));
    }

    public final Value get(Item key) throws QueryException {
        Value value = this.getOrNull(key);
        return value != null ? value : Empty.VALUE;
    }

    public abstract Value getOrNull(Item var1) throws QueryException;

    public abstract Item keyAt(int var1);

    public abstract Value valueAt(int var1);

    public abstract XQMap put(Item var1, Value var2) throws QueryException;

    public abstract XQMap putAt(int var1, Value var2) throws QueryException;

    public abstract XQMap remove(Item var1) throws QueryException;

    public abstract void forEach(QueryBiConsumer<Item, Value> var1) throws QueryException;

    public abstract boolean test(QueryBiPredicate<Item, Value> var1) throws QueryException;

    public final boolean contains(Item key) throws QueryException {
        return this.getOrNull(key) != null;
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(ii, this);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOMIZE_X.get(ii, this);
    }

    @Override
    public final XQMap materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        MapBuilder mb = new MapBuilder(this.structSize());
        this.forEach((Item key, Value value) -> {
            qc.checkStop();
            mb.put((Item)key, value.materialize(test, ii, qc));
        });
        return mb.map();
    }

    @Override
    public final boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return this.funcType().declType.type.instanceOf(AtomType.ANY_ATOMIC_TYPE) || this.test((key, value) -> value.materialized(test, ii));
    }

    @Override
    public final boolean instanceOf(Type tp, boolean coerce) {
        if (this.type == tp) {
            return true;
        }
        if (coerce && tp instanceof FuncType) {
            return false;
        }
        try {
            SeqType vt;
            Type kt;
            if (tp instanceof RecordType) {
                RecordType rt = (RecordType)tp;
                TokenObjectMap<RecordField> fields = rt.fields();
                int fs = fields.size();
                if (coerce) {
                    BasicIter<Item> keys = this.keys().iter();
                    for (int f = 1; f <= fs; ++f) {
                        RecordField rf = fields.value(f);
                        Item key2 = keys.next();
                        SeqType st = rf.seqType();
                        if (!rf.isOptional() && key2 != null && key2.type == AtomType.STRING && Token.eq(fields.key(f), key2.string(null)) && (st == Types.ITEM_ZM || st.instance(this.getOrNull(key2)))) continue;
                        return false;
                    }
                    return keys.next() == null || rt.isExtensible();
                }
                for (int f = 1; f <= fs; ++f) {
                    RecordField rf = fields.value(f);
                    Value value2 = this.getOrNull(Str.get(fields.key(f)));
                    if (!(value2 != null ? !rf.seqType().instance(value2) : !rf.isOptional())) continue;
                    return false;
                }
                if (!rt.isExtensible()) {
                    for (Item key3 : this.keys()) {
                        if (key3.type.instanceOf(AtomType.STRING) && fields.contains(key3.string(null))) continue;
                        return false;
                    }
                }
                return true;
            }
            if (this.type.instanceOf(tp)) {
                return true;
            }
            if (tp instanceof MapType) {
                MapType mt = (MapType)tp;
                kt = mt.keyType() == AtomType.ANY_ATOMIC_TYPE ? null : mt.keyType();
                vt = mt.valueType().eq(Types.ITEM_ZM) ? null : mt.valueType();
            } else if (tp instanceof FuncType) {
                FuncType ft = (FuncType)tp;
                if (ft.declType.occ.min != 0L || ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(Types.ANY_ATOMIC_TYPE_O)) {
                    return false;
                }
                kt = null;
                vt = ft.declType.eq(Types.ITEM_ZM) ? null : ft.declType;
            } else {
                return false;
            }
            return kt == null && vt == null || this.test((key, value) -> !(kt != null && !key.type.instanceOf(kt) || vt != null && !vt.instance((Value)value)));
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    public abstract Value keys();

    @Override
    public final Iter itemsIter() {
        long size = this.structSize();
        if (size == 0L) {
            return Empty.ITER;
        }
        if (size == 1L) {
            return this.valueAt(0).iter();
        }
        if (((MapType)this.type).valueType().one()) {
            return new BasicIter<Item>(size){

                @Override
                public Item get(long i) {
                    return (Item)XQMap.this.valueAt((int)i);
                }
            };
        }
        final BasicIter<Item> keys = this.keys().iter();
        return new Iter(){
            Iter iter = Empty.ITER;

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = this.iter.next()) == null) {
                    Object key = keys.next();
                    if (key == null) {
                        return null;
                    }
                    this.iter = XQMap.this.get((Item)key).iter();
                }
                return item;
            }
        };
    }

    public final XQMap coerceTo(MapType mt, QueryContext qc, CompileContext cc, InputInfo ii) throws QueryException {
        SeqType kt = mt.keyType().seqType();
        SeqType vt = mt.valueType();
        MapBuilder mb = new MapBuilder(this.structSize());
        this.forEach((Item key, Value value) -> {
            qc.checkStop();
            Item k = (Item)kt.coerce((Value)key, null, qc, cc, ii);
            if (mb.contains(k)) {
                throw QueryError.typeError(this, mt, ii);
            }
            mb.put(k, vt.coerce((Value)value, null, qc, cc, ii));
        });
        return mb.map();
    }

    public final XQMap coerceTo(RecordType rt, QueryContext qc, CompileContext cc, InputInfo ii) throws QueryException {
        XQMap map;
        long ms = this.structSize();
        MapBuilder mb = new MapBuilder(ms);
        TokenObjectMap<RecordField> fields = rt.fields();
        int fs = fields.size();
        for (int f = 1; f <= fs; ++f) {
            byte[] key2 = fields.key(f);
            RecordField rf = fields.value(f);
            Value value2 = this.getOrNull(Str.get(key2));
            if (value2 != null) {
                mb.put(key2, rf.seqType().coerce(value2, null, qc, cc, ii));
                continue;
            }
            if (rf.isOptional()) continue;
            throw QueryError.typeError(this, rt, ii);
        }
        if (mb.size() < ms) {
            if (!rt.isExtensible()) {
                throw QueryError.typeError(this, rt, ii);
            }
            this.forEach((Item key, Value value) -> {
                if (!mb.contains((Item)key)) {
                    qc.checkStop();
                    mb.put((Item)key, (Value)value);
                }
            });
        }
        if ((map = mb.map()) != XQMap.empty()) {
            map.type = rt;
        }
        return map;
    }

    @Override
    public boolean refineType() throws QueryException {
        MapType refined = null;
        for (Item key : this.keys()) {
            Value value = this.get(key);
            MapType mt = MapType.get(key.type, value.seqType());
            if (!(refined = refined == null ? mt : refined.union(mt)).eq(this.type)) continue;
            return true;
        }
        this.type = refined;
        return true;
    }

    @Override
    protected final XQMap rebuild(QueryContext qc) throws QueryException {
        MapBuilder mb = new MapBuilder(this.structSize());
        this.forEach((Item key, Value value) -> mb.put((Item)key, value.shrink(qc)));
        return mb.map(this);
    }

    @Override
    public final HashMap<Object, Object> toJava() throws QueryException {
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)this.structSize());
        this.forEach((Item key, Value value) -> map.put(key.toJava(), value.toJava()));
        return map;
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        if (this == item) {
            return true;
        }
        if (!(item instanceof XQMap)) {
            return false;
        }
        XQMap map = (XQMap)item;
        if (this.structSize() != map.structSize()) {
            return false;
        }
        if (deep == null) {
            return this.deepEqualOrdered(map);
        }
        return this.deepEqualOrdered(map, deep) || deep.options.get(DeepEqualOptions.MAP_ORDER) == false && this.deepEqualUnordered(map, deep);
    }

    private boolean deepEqualOrdered(XQMap map) throws QueryException {
        BasicIter<Item> keys2 = map.keys().iter();
        for (Item key : this.keys()) {
            Item k;
            if (key.equals(k = keys2.next()) && this.getOrNull(key).equals(map.getOrNull(k))) continue;
            return false;
        }
        return true;
    }

    private boolean deepEqualOrdered(XQMap map, DeepEqual deep) throws QueryException {
        BasicIter<Item> keys2 = map.keys().iter();
        for (Item key : this.keys()) {
            Item k;
            if (key.atomicEqual(k = keys2.next()) && deep.equal(this.getOrNull(key), map.getOrNull(k))) continue;
            return false;
        }
        return true;
    }

    private boolean deepEqualUnordered(XQMap map, DeepEqual deep) throws QueryException {
        for (Item key : this.keys()) {
            Value v = map.getOrNull(key);
            if (v != null && deep.equal(this.getOrNull(key), v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add("{");
        int c = 0;
        IntConsumer addWS = lvl -> {
            for (int l = 0; l < lvl; ++l) {
                tb.add("  ");
            }
        };
        for (Item key : this.keys()) {
            Value value;
            boolean par;
            if (c++ > 0) {
                tb.add(44);
            }
            if (indent) {
                tb.add(10);
                addWS.accept(level + 1);
            }
            tb.add(key).add(58);
            if (indent) {
                tb.add(32);
            }
            boolean bl = par = (value = this.get(key)).size() != 1L;
            if (par) {
                tb.add(40);
            }
            int cc = 0;
            for (Item item : value) {
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if (item instanceof XQMap) {
                    XQMap map = (XQMap)item;
                    map.string(indent, tb, level + 1, ii);
                    continue;
                }
                if (item instanceof XQArray) {
                    XQArray array = (XQArray)item;
                    array.string(indent, tb, level, ii);
                    continue;
                }
                tb.add(item);
            }
            if (!par) continue;
            tb.add(41);
        }
        if (indent) {
            tb.add(10);
            addWS.accept(level);
        }
        tb.add(125);
    }

    @Override
    public final String description() {
        return "map";
    }

    @Override
    public final void toXml(QueryPlan plan) {
        try {
            long size = this.structSize();
            Value keys = this.keys();
            ExprList list = new ExprList();
            long max = Math.min(size, 5L);
            for (long i = 0L; i < max; ++i) {
                Item key = keys.itemAt(i);
                ((ExprList)((Object)list.add(key))).add(this.get(key));
            }
            plan.add(plan.create(this, "entries", size), new ExprInfo[0]);
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    @Override
    public final void toString(QueryString qs) {
        if (this.structSize() == 0L) {
            qs.token("{}");
        } else {
            TokenBuilder tb = new TokenBuilder();
            try {
                this.forEach((Item key, Value value) -> {
                    if (tb.moreInfo()) {
                        tb.add(key).add(": ").add(value).add(", ");
                    }
                });
            }
            catch (QueryException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
            qs.braced("{ ", tb.toString().replaceAll(", $", ""), " }");
        }
    }
}

