/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class Bin
extends Item {
    byte[] data;

    Bin(byte[] data, Type type) {
        super(type);
        this.data = data;
    }

    public byte[] binary(InputInfo info) throws QueryException {
        return this.data;
    }

    @Override
    public final boolean comparable(Item item) {
        return item instanceof Bin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean atomicEqual(Item item) throws QueryException {
        if (this == item) return true;
        if (!(item instanceof Bin)) return false;
        Bin bin = (Bin)item;
        if (!Token.eq(this.binary(null), bin.binary(null))) return false;
        return true;
    }

    @Override
    public final int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        byte[] byArray;
        if (item instanceof Bin) {
            Bin bin = (Bin)item;
            byArray = bin.binary(ii);
        } else {
            byArray = this.parse(item, ii);
        }
        byte[] binary = byArray;
        return Token.compare(this.binary(ii), binary);
    }

    public abstract byte[] parse(Item var1, InputInfo var2) throws QueryException;

    @Override
    public BufferInput input(InputInfo ii) throws QueryException {
        return new ArrayInput(this.data);
    }

    public final byte[] toJava() throws QueryException {
        return this.binary(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Bin)) return false;
        Bin bin = (Bin)obj;
        if (this.type != bin.type) return false;
        if (!Token.eq(this.data, bin.data)) return false;
        return true;
    }
}

