# [devil.android.device_utils](https://github.com/catapult-project/catapult/blob/master/devil/devil/android/device_utils.py)

*This page was autogenerated. Run `devil/bin/generate_md_docs` to update*

## DeviceUtils

### DeviceUtils.BroadcastIntent

Send a broadcast intent.
```
    Args:
      intent: An Intent to broadcast.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ChangeOwner

Changes file system ownership for permissions.
```
    Args:
      owner_group: New owner and group to assign. Note that this should be a
        string in the form user[.group] where the group is option.
      paths: Paths to change ownership of.

      Note that the -R recursive option is not supported by all Android
      versions.
```


### DeviceUtils.ChangeSecurityContext

Changes the SELinux security context for files.
```
    Args:
      security_context: The new security context as a string
      paths: Paths to change the security context of.

      Note that the -R recursive option is not supported by all Android
      versions.
```


### DeviceUtils.ClearApplicationState

Clear all state for the given package.
```
    Args:
      package: A string containing the name of the package to stop.
      permissions: List of permissions to set after clearing data.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ClearCache

Clears all caches.
### DeviceUtils.DismissCrashDialogIfNeeded

Dismiss the error/ANR dialog if present.
```
    Returns: Name of the crashed package if a dialog is focused,
             None otherwise.
```


### DeviceUtils.DumpCacheData

Dumps the current cache state to a string.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A serialized cache as a string.
```


### DeviceUtils.EnableRoot

Restarts adbd with root privileges.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if root could not be enabled.
      CommandTimeoutError on timeout.
```


### DeviceUtils.FileExists

Checks whether the given file exists on the device.
```
    Arguments are the same as PathExists.
```


### DeviceUtils.FileSize

Get the size of a file on the device.
```
    Note: This is implemented by parsing the output of the 'ls' command on
    the device. On some Android versions, when passing a directory or special
    file, the size is *not* reported and this function will throw an exception.

    Args:
      device_path: A string containing the path of a file on the device.
      as_root: A boolean indicating whether the to use root privileges to
               access the file information.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The size of the file in bytes.

    Raises:
      CommandFailedError if device_path cannot be found on the device, or
        its size cannot be determited for some reason.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ForceStop

Close the application.
```
    Args:
      package: A string containing the name of the package to stop.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetABI

Gets the device main ABI.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's main ABI name. For supported ABIs, the return value will be
      one of the values defined in devil.android.ndk.abis.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetAppWritablePath

Get a path that on the device's SD card that apps can write.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A app-writeable path on the device's SD card.

    Raises:
      CommandFailedError if the external storage path could not be determined.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetApplicationDataDirectory

Get the data directory on the device for the given package.
```
    Args:
      package: Name of the package.

    Returns:
      The package's data directory.
    Raises:
      CommandFailedError if the package's data directory can't be found,
        whether because it's not installed or otherwise.
```


### DeviceUtils.GetApplicationPaths

Get the paths of the installed apks on the device for the given package.
```
    Args:
      package: Name of the package.

    Returns:
      List of paths to the apks on the device for the given package.
```


### DeviceUtils.GetApplicationPids

Returns the PID or PIDs of a given process name.
```
    Note that the |process_name|, often the package name, must match exactly.

    Args:
      process_name: A string containing the process name to get the PIDs for.
      at_most_one: A boolean indicating that at most one PID is expected to
                   be found.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of the PIDs for the named process. If at_most_one=True returns
      the single PID found or None otherwise.

    Raises:
      CommandFailedError if at_most_one=True and more than one PID is found
          for the named process.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetApplicationTargetSdk

Get the targetSdkVersion of a package installed on the device.
```
    Args:
      package: Name of the package.

    Returns:
      A string with the targetSdkVersion or None if the package is not found on
      the device. Note: this cannot always be cast to an integer. If this
      application targets a pre-release SDK, this returns the version codename
      instead (ex. "R").
```


### DeviceUtils.GetApplicationVersion

Get the version name of a package installed on the device.
```
    Args:
      package: Name of the package.

    Returns:
      A string with the version name or None if the package is not found
      on the device.
```


### DeviceUtils.GetClientCache

Returns client cache.
### DeviceUtils.GetCountry

Returns the country setting on the device.
```
    DEPRECATED: Prefer GetLocale() instead.

    Args:
      cache: Whether to use cached properties when available.
```


### DeviceUtils.GetEnforce

Get the current mode of SELinux.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True (enforcing), False (permissive), or None (disabled).

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetExternalStoragePath

Get the device's path to its SD card.
```
    Note: this path is read-only by apps in R+. Use GetAppWritablePath() to
    obtain a path writable by apps.

    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's path to its SD card.

    Raises:
      CommandFailedError if the external storage path could not be determined.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetFeatures

Returns the features supported on the device.
### DeviceUtils.GetIMEI

Get the device's IMEI.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The device's IMEI.

    Raises:
      AdbCommandFailedError on error
```


### DeviceUtils.GetLanguage

Returns the language setting on the device.
```
    DEPRECATED: Prefer GetLocale() instead.

    Args:
      cache: Whether to use cached properties when available.
```


### DeviceUtils.GetLocale

Returns the locale setting on the device.
```
    Args:
      cache: Whether to use cached properties when available.
    Returns:
      A pair (language, country).
```


### DeviceUtils.GetLogcatMonitor

Returns a new LogcatMonitor associated with this device.
```
    Parameters passed to this function are passed directly to
    |logcat_monitor.LogcatMonitor| and are documented there.
```


### DeviceUtils.GetPackageArchitecture

Get the architecture of a package installed on the device.
```
    Args:
      package: Name of the package.

    Returns:
      A string with the architecture, or None if the package is missing.
```


### DeviceUtils.GetPids

Returns the PIDs of processes containing the given name as substring.
```
    DEPRECATED

    Note that the |process_name| is often the package name.

    Args:
      process_name: A string containing the process name to get the PIDs for.
                    If missing returns PIDs for all processes.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A dict mapping process name to a list of PIDs for each process that
      contained the provided |process_name|.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GetProp

Gets a property from the device.
```
    Args:
      property_name: A string containing the name of the property to get from
                     the device.
      cache: Whether to use cached properties when available.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The value of the device's |property_name| property.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetSecurityContextForPackage

Gets the SELinux security context for the given package.
```
    Args:
      package: Name of the package.
      encrypted: Whether to check in the encrypted data directory
          (/data/user_de/0/) or the unencrypted data directory (/data/data/).

    Returns:
      The package's security context as a string, or None if not found.
```


### DeviceUtils.GetTracingPath

Gets tracing path from the device.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      /sys/kernel/debug/tracing for device with debugfs mount support;
      /sys/kernel/tracing for device with tracefs support;
      /sys/kernel/debug/tracing if support can't be determined.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.GetWebViewUpdateServiceDump

Get the WebView update command sysdump on the device.
```
    Returns:
      A dictionary with these possible entries:
        FallbackLogicEnabled: True|False
        CurrentWebViewPackage: "package name" or None
        MinimumWebViewVersionCode: int
        WebViewPackages: Dict of installed WebView providers, mapping "package
            name" to "reason it's valid/invalid."

    It may return an empty dictionary if device does not
    support the "dumpsys webviewupdate" command.

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GoHome

Return to the home screen and obtain launcher focus.
```
    This command launches the home screen and attempts to obtain
    launcher focus until the timeout is reached.

    Args:
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.GrantPermissions

### DeviceUtils.HasRoot

Checks whether or not adbd has root privileges.
```
    A device is considered to have root if all commands are implicitly run
    with elevated privileges, i.e. without having to use "su" to run them.

    Note that some devices do not allow this implicit privilige elevation,
    but _can_ run commands as root just fine when done explicitly with "su".
    To check if your device can run commands with elevated privileges at all
    use:

      device.HasRoot() or device.NeedsSU()

    Luckily, for the most part you don't need to worry about this and using
    RunShellCommand(cmd, as_root=True) will figure out for you the right
    command incantation to run with elevated privileges.

    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if adbd has root privileges, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.Install

Install an APK or app bundle.
```
    Noop if an identical APK is already installed. If installing a bundle, the
    bundletools helper script (bin/*_bundle) should be used rather than the .aab
    file.

    Args:
      apk: An ApkHelper instance or string containing the path to the APK or
        bundle.
      allow_downgrade: A boolean indicating if we should allow downgrades.
      reinstall: A boolean indicating if we should keep any existing app data.
        Ignored if |apk| is a bundle.
      permissions: Set of permissions to set. If not set, finds permissions with
          apk helper. To set no permissions, pass [].
      timeout: timeout in seconds
      retries: number of retries
      modules: An iterable containing specific bundle modules to install.
          Error if set and |apk| points to an APK instead of a bundle.
      fake_modules: An iterable containing specific bundle modules that should
          have their apks copied to |MODULES_SRC_DIRECTORY_PATH| subdirectory
          rather than installed. Thus the app can emulate SplitCompat while
          running. This should not have any overlap with |modules|.
      additional_locales: An iterable with additional locales to install for a
        bundle.

    Raises:
      CommandFailedError if the installation fails.
      CommandTimeoutError if the installation times out.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.InstallSplitApk

Install a split APK.
```
    Noop if all of the APK splits are already installed.

    Args:
      base_apk: An ApkHelper instance or string containing the path to the base
          APK.
      split_apks: A list of strings of paths of all of the APK splits.
      allow_downgrade: A boolean indicating if we should allow downgrades.
      reinstall: A boolean indicating if we should keep any existing app data.
      allow_cached_props: Whether to use cached values for device properties.
      permissions: Set of permissions to set. If not set, finds permissions with
          apk helper. To set no permissions, pass [].
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the installation fails.
      CommandTimeoutError if the installation times out.
      DeviceUnreachableError on missing device.
      DeviceVersionError if device SDK is less than Android L.
```


### DeviceUtils.IsApplicationInstalled

Determines whether a particular package is installed on the device.
```
    Args:
      package: Name of the package.

    Returns:
      True if the application is installed, False otherwise.
```


### DeviceUtils.IsOnline

Checks whether the device is online.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device is online, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.IsScreenOn

Determines if screen is on.
```
    Dumpsys input_method exposes screen on/off state. Below is an explination of
    the states.

    Pre-L:
      On: mScreenOn=true
      Off: mScreenOn=false
    L+:
      On: mInteractive=true
      Off: mInteractive=false

    Returns:
      True if screen is on, false if it is off.

    Raises:
      device_errors.CommandFailedError: If screen state cannot be found.
```


### DeviceUtils.IsUserBuild

Checks whether or not the device is running a user build.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device is running a user build, False otherwise (i.e. if
        it's running a userdebug build).

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.KillAll

Kill all processes with the given name on the device.
```
    Args:
      process_name: A string containing the name of the process to kill.
      exact: A boolean indicating whether to kill all processes matching
             the string |process_name| exactly, or all of those which contain
             |process_name| as a substring. Defaults to False.
      signum: An integer containing the signal number to send to kill. Defaults
              to SIGKILL (9).
      as_root: A boolean indicating whether the kill should be executed with
               root privileges.
      blocking: A boolean indicating whether we should wait until all processes
                with the given |process_name| are dead.
      quiet: A boolean indicating whether to ignore the fact that no processes
             to kill were found.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The number of processes attempted to kill.

    Raises:
      CommandFailedError if no process was killed and |quiet| is False.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ListDirectory

List all files on a device directory.
```
    Mirroring os.listdir (and most client expectations) the resulting list
    does not include the special entries '.' and '..' even if they are present
    in the directory.

    Args:
      device_path: A string containing the path of the directory on the device
                   to list.
      as_root: A boolean indicating whether the to use root privileges to list
               the directory contents.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of filenames for all entries contained in the directory.

    Raises:
      AdbCommandFailedError if |device_path| does not specify a valid and
          accessible directory in the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ListProcesses

Returns a list of tuples with info about processes on the device.
```
    This essentially parses the output of the |ps| command into convenient
    ProcessInfo tuples.

    Args:
      process_name: A string used to filter the returned processes. If given,
                    only processes whose name have this value as a substring
                    will be returned.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of ProcessInfo tuples with |name|, |pid|, and |ppid| fields.
```


### DeviceUtils.LoadCacheData

Initializes the cache from data created using DumpCacheData.
```
    The cache is used only if its token matches the one found on the device.
    This prevents a stale cache from being used (which can happen when sharing
    devices).

    Args:
      data: A previously serialized cache (string).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      Whether the cache was loaded.
```


### DeviceUtils.NeedsSU

Checks whether 'su' is needed to access protected resources.
```
    Args:
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if 'su' is available on the device and is needed to to access
        protected resources; False otherwise if either 'su' is not available
        (e.g. because the device has a user build), or not needed (because adbd
        already has root privileges).

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.PathExists

Checks whether the given path(s) exists on the device.
```
    Args:
      device_path: A string containing the absolute path to the file on the
                   device, or an iterable of paths to check.
      as_root: Whether root permissions should be use to check for the existence
               of the given path(s).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the all given paths exist on the device, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.PullFile

Pull a file from the device.
```
    Args:
      device_path: A string containing the absolute path of the file to pull
                   from the device.
      host_path: A string containing the absolute path of the destination on
                 the host.
      as_root: Whether root permissions should be used to pull the file.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
```


### DeviceUtils.PushChangedFiles

Push files to the device, skipping files that don't need updating.
```
    When a directory is pushed, it is traversed recursively on the host and
    all files in it are pushed to the device as needed.
    Additionally, if delete_device_stale option is True,
    files that exist on the device but don't exist on the host are deleted.

    Args:
      host_device_tuples: A list of (host_path, device_path) tuples, where
        |host_path| is an absolute path of a file or directory on the host
        that should be minimially pushed to the device, and |device_path| is
        an absolute path of the destination on the device.
      delete_device_stale: option to delete stale files on device
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.ReadFile

Reads the contents of a file from the device.
```
    Args:
      device_path: A string containing the absolute path of the file to read
                   from the device.
      as_root: A boolean indicating whether the read should be executed with
               root privileges.
      force_pull: A boolean indicating whether to force the operation to be
          performed by pulling a file from the device. The default is, when the
          contents are short, to retrieve the contents using cat instead.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The contents of |device_path| as a string. Contents are intepreted using
      universal newlines, so the caller will see them encoded as '
'. Also,
      all lines will be terminated.

    Raises:
      AdbCommandFailedError if the file can't be read.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.Reboot

Reboot the device.
```
    Args:
      block: A boolean indicating if we should wait for the reboot to complete.
      wifi: A boolean indicating if we should wait for wifi to be enabled after
        the reboot.
        The option has no effect unless |block| is also True.
      decrypt: A boolean indicating if we should wait for full-disk decryption
        to complete after the reboot.
        The option has no effect unless |block| is also True.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.RemovePath

Removes the given path(s) from the device.
```
    Args:
      device_path: A string containing the absolute path to the file on the
                   device, or an iterable of paths to check.
      force: Whether to remove the path(s) with force (-f).
      recursive: Whether to remove any directories in the path(s) recursively.
      as_root: Whether root permissions should be use to remove the given
               path(s).
      rename: Whether to rename the path(s) before removing to help avoid
            filesystem errors. See https://stackoverflow.com/questions/11539657
      timeout: timeout in seconds
      retries: number of retries
```


### DeviceUtils.RestartAdbd

### DeviceUtils.RunShellCommand

Run an ADB shell command.
```
    The command to run |cmd| should be a sequence of program arguments
    (preferred) or a single string with a shell script to run.

    When |cmd| is a sequence, it is assumed to contain the name of the command
    to run followed by its arguments. In this case, arguments are passed to the
    command exactly as given, preventing any further processing by the shell.
    This allows callers to easily pass arguments with spaces or special
    characters without having to worry about quoting rules. Whenever possible,
    it is recomended to pass |cmd| as a sequence.

    When |cmd| is passed as a single string, |shell| should be set to True.
    The command will be interpreted and run by the shell on the device,
    allowing the use of shell features such as pipes, wildcards, or variables.
    Failing to set shell=True will issue a warning, but this will be changed
    to a hard failure in the future (see: catapult:#3242).

    This behaviour is consistent with that of command runners in cmd_helper as
    well as Python's own subprocess.Popen.

    TODO(crbug.com/1029769) Change the default of |check_return| to True when
    callers have switched to the new behaviour.

    Args:
      cmd: A sequence containing the command to run and its arguments, or a
        string with a shell script to run (should also set shell=True).
      shell: A boolean indicating whether shell features may be used in |cmd|.
      check_return: A boolean indicating whether or not the return code should
        be checked.
      cwd: The device directory in which the command should be run.
      env: The environment variables with which the command should be run.
      run_as: A string containing the package as which the command should be
        run.
      as_root: A boolean indicating whether the shell command should be run
        with root privileges.
      single_line: A boolean indicating if only a single line of output is
        expected.
      large_output: Uses a work-around for large shell command output. Without
        this large output will be truncated.
      raw_output: Whether to only return the raw output
          (no splitting into lines).
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      If single_line is False, the output of the command as a list of lines,
      otherwise, a string with the unique line of output emmited by the command
      (with the optional newline at the end stripped).

    Raises:
      AdbCommandFailedError if check_return is True and the exit code of
        the command run on the device is non-zero.
      CommandFailedError if single_line is True but the output contains two or
        more lines.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SendKeyEvent

Sends a keycode to the device.
```
    See the devil.android.sdk.keyevent module for suitable keycode values.

    Args:
      keycode: A integer keycode to send to the device.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SetEnforce

Modify the mode SELinux is running in.
```
    Args:
      enabled: a boolean indicating whether to put SELinux in encorcing mode
               (if True), or permissive mode (otherwise).
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SetJavaAsserts

Enables or disables Java asserts.
```
    Args:
      enabled: A boolean indicating whether Java asserts should be enabled
               or disabled.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      True if the device-side property changed and a restart is required as a
      result, False otherwise.

    Raises:
      CommandTimeoutError on timeout.
```


### DeviceUtils.SetProp

Sets a property on the device.
```
    Args:
      property_name: A string containing the name of the property to set on
                     the device.
      value: A string containing the value to set to the property on the
             device.
      check: A boolean indicating whether to check that the property was
             successfully set on the device.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if check is true and the property was not correctly
        set on the device (e.g. because it is not rooted).
      CommandTimeoutError on timeout.
```


### DeviceUtils.SetScreen

Turns screen on and off.
```
    Args:
      on: bool to decide state to switch to. True = on False = off.
```


### DeviceUtils.SetWebViewFallbackLogic

Set whether WebViewUpdateService's "fallback logic" should be enabled.
```
    WebViewUpdateService has nonintuitive "fallback logic" for devices where
    Monochrome (Chrome Stable) is preinstalled as the WebView provider, with a
    "stub" (little-to-no code) implementation of standalone WebView.

    "Fallback logic" (enabled by default) is designed, in the case where the
    user has disabled Chrome, to fall back to the stub standalone WebView by
    enabling the package. The implementation plumbs through the Chrome APK until
    Play Store installs an update with the full implementation.

    A surprising side-effect of "fallback logic" is that, immediately after
    sideloading WebView, WebViewUpdateService re-disables the package and
    uninstalls the update. This can prevent successfully using standalone
    WebView for development, although "fallback logic" can be disabled on
    userdebug/eng devices.

    Because this is only relevant for devices with the standalone WebView stub,
    this command is only relevant on N-P (inclusive).

    You can determine if "fallback logic" is currently enabled by checking
    FallbackLogicEnabled in the dictionary returned by
    GetWebViewUpdateServiceDump.

    Args:
      enabled: bool - True for enabled, False for disabled
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.SetWebViewImplementation

Select the WebView implementation to the specified package.
```
    Args:
      package_name: The package name of a WebView implementation. The package
        must be already installed on the device.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StartActivity

Start package's activity on the device.
```
    Args:
      intent_obj: An Intent object to send.
      blocking: A boolean indicating whether we should wait for the activity to
                finish launching.
      trace_file_name: If present, a string that both indicates that we want to
                       profile the activity and contains the path to which the
                       trace should be saved.
      force_stop: A boolean indicating whether we should stop the activity
                  before starting it.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the activity could not be started.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StartInstrumentation

### DeviceUtils.StartService

Start a service on the device.
```
    Args:
      intent_obj: An Intent object to send describing the service to start.
      user_id: A specific user to start the service as, defaults to current.
      timeout: Timeout in seconds.
      retries: Number of retries

    Raises:
      CommandFailedError if the service could not be started.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StatDirectory

List file and stat info for all entries on a device directory.
```
    Implementation notes: this is currently implemented by parsing the output
    of 'ls -a -l' on the device. Whether possible and convenient, we attempt to
    make parsing strict and return values mirroring those of the standard |os|
    and |stat| Python modules.

    Mirroring os.listdir (and most client expectations) the resulting list
    does not include the special entries '.' and '..' even if they are present
    in the directory.

    Args:
      device_path: A string containing the path of the directory on the device
                   to list.
      as_root: A boolean indicating whether the to use root privileges to list
               the directory contents.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A list of dictionaries, each containing the following keys:
        filename: A string with the file name.
        st_mode: File permissions, use the stat module to interpret these.
        st_nlink: Number of hard links (may be missing).
        st_owner: A string with the user name of the owner.
        st_group: A string with the group name of the owner.
        st_rdev_pair: Device type as (major, minior) (only if inode device).
        st_size: Size of file, in bytes (may be missing for non-regular files).
        st_mtime: Time of most recent modification, in seconds since epoch
          (although resolution is in minutes).
        symbolic_link_to: If entry is a symbolic link, path where it points to;
          missing otherwise.

    Raises:
      AdbCommandFailedError if |device_path| does not specify a valid and
          accessible directory in the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.StatPath

Get the stat attributes of a file or directory on the device.
```
    Args:
      device_path: A string containing the path of a file or directory from
                   which to get attributes.
      as_root: A boolean indicating whether the to use root privileges to
               access the file information.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      A dictionary with the stat info collected; see StatDirectory for details.

    Raises:
      CommandFailedError if device_path cannot be found on the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.TakeBugReport

Takes a bug report and dumps it to the specified path.
```
    This doesn't use adb's bugreport option since its behavior is dependent on
    both adb version and device OS version. To make it simpler, this directly
    runs the bugreport command on the device itself and dumps the stdout to a
    file.

    Args:
      path: Path on the host to drop the bug report.
      timeout: (optional) Timeout per try in seconds.
      retries: (optional) Number of retries to attempt.
```


### DeviceUtils.TakeScreenshot

Takes a screenshot of the device.
```
    Args:
      host_path: A string containing the path on the host to save the
                 screenshot to. If None, a file name in the current
                 directory will be generated.
      timeout: timeout in seconds
      retries: number of retries

    Returns:
      The name of the file on the host to which the screenshot was saved.

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.Uninstall

Remove the app |package\_name| from the device.
```
    This is a no-op if the app is not already installed.

    Args:
      package_name: The package to uninstall.
      keep_data: (optional) Whether to keep the data and cache directories.
      timeout: Timeout in seconds.
      retries: Number of retries.

    Raises:
      CommandFailedError if the uninstallation fails.
      CommandTimeoutError if the uninstallation times out.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.WaitUntilFullyBooted

Wait for the device to fully boot.
```
    This means waiting for the device to boot, the package manager to be
    available, and the SD card to be ready.
    It can optionally wait the following:
     - Wait for wifi to come up.
     - Wait for full-disk decryption to complete.

    Args:
      wifi: A boolean indicating if we should wait for wifi to come up or not.
      decrypt: A boolean indicating if we should wait for full-disk decryption
        to complete.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError on failure.
      CommandTimeoutError if one of the component waits times out.
      DeviceUnreachableError if the device becomes unresponsive.
```


### DeviceUtils.WriteFile

Writes |contents| to a file on the device.
```
    Args:
      device_path: A string containing the absolute path to the file to write
          on the device.
      contents: A string containing the data to write to the device.
      as_root: A boolean indicating whether the write should be executed with
          root privileges (if available).
      force_push: A boolean indicating whether to force the operation to be
          performed by pushing a file to the device. The default is, when the
          contents are short, to pass the contents using a shell script instead.
      timeout: timeout in seconds
      retries: number of retries

    Raises:
      CommandFailedError if the file could not be written on the device.
      CommandTimeoutError on timeout.
      DeviceUnreachableError on missing device.
```


### DeviceUtils.\_\_eq\_\_

Checks whether |other| refers to the same device as |self|.
```
    Args:
      other: The object to compare to. This can be a basestring, an instance
        of adb_wrapper.AdbWrapper, or an instance of DeviceUtils.
    Returns:
      Whether |other| refers to the same device as |self|.
```


### DeviceUtils.\_\_init\_\_

DeviceUtils constructor.
```
    Args:
      device: Either a device serial, an existing AdbWrapper instance, or an
        an existing AndroidCommands instance.
      enable_device_files_cache: For PushChangedFiles(), cache checksums of
        pushed files rather than recomputing them on a subsequent call.
      default_timeout: An integer containing the default number of seconds to
        wait for an operation to complete if no explicit value is provided.
      default_retries: An integer containing the default number or times an
        operation should be retried on failure if no explicit value is provided.
```


### DeviceUtils.\_\_lt\_\_

Compares two instances of DeviceUtils.
```
    This merely compares their serial numbers.

    Args:
      other: The instance of DeviceUtils to compare to.
    Returns:
      Whether |self| is less than |other|.
```


### DeviceUtils.\_\_str\_\_

Returns the device serial.
## ProcessInfo

ProcessInfo(name, pid, ppid)
### ProcessInfo.\_\_getnewargs\_\_

Return self as a plain tuple.  Used by copy and pickle.
### ProcessInfo.\_\_getstate\_\_

Exclude the OrderedDict from pickling
### ProcessInfo.\_\_repr\_\_

Return a nicely formatted representation string
### GetAVDs

Returns a list of Android Virtual Devices.
```
  Returns:
    A list containing the configured AVDs.
```


### RestartServer

Restarts the adb server.
```
  Raises:
    CommandFailedError if we fail to kill or restart the server.
```


