/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

public final class TextUtil {
    private TextUtil() {
    }

    public static String showTextTable(String[] columnHeaders, String[][] table, boolean[] alignRight) {
        int c;
        int r;
        int c2;
        StringBuilder out = new StringBuilder();
        int[] maxColSize = new int[columnHeaders.length];
        for (c2 = 0; c2 < columnHeaders.length; ++c2) {
            maxColSize[c2] = columnHeaders[c2].length();
        }
        for (r = 0; r < table.length; ++r) {
            for (c = 0; c < table[r].length; ++c) {
                maxColSize[c] = Math.max(maxColSize[c], table[r][c].length());
            }
        }
        for (c2 = 0; c2 < columnHeaders.length; ++c2) {
            TextUtil.appendField(out, columnHeaders[c2], maxColSize[c2], alignRight[c2]);
        }
        out.append('\n');
        for (r = 0; r < table.length; ++r) {
            for (c = 0; c < table[r].length; ++c) {
                TextUtil.appendField(out, table[r][c], maxColSize[c], alignRight[c]);
            }
            out.append('\n');
        }
        return out.toString();
    }

    public static void appendField(StringBuilder out, String data, int colSize, boolean alignRight) {
        if (!alignRight) {
            out.append(data);
        }
        for (int i = data.length(); i < colSize; ++i) {
            out.append(' ');
        }
        if (alignRight) {
            out.append(data);
        }
        out.append("\t");
    }
}

