/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.machinetranslators.MachineTranslators;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.MachineTranslationPreferencesPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.TableColumnSizer;

public class MachineTranslationPreferencesController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private final Map<String, Boolean> providerStatus = new HashMap<String, Boolean>();
    private MachineTranslationPreferencesPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_MACHINE_TRANSLATION");
    }

    private void initGui() {
        this.panel = new MachineTranslationPreferencesPanel();
        this.panel.autoFetchCheckBox.addActionListener(e -> this.panel.untranslatedOnlyCheckBox.setEnabled(this.panel.autoFetchCheckBox.isSelected()));
        Dimension tableSize = this.panel.mtProviderTable.getPreferredSize();
        this.panel.mtProviderTable.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.panel.mtProviderTable.getRowHeight() * 10));
        TableColumnSizer.autoSize(this.panel.mtProviderTable, ProviderColumn.NAME.index, true);
        this.panel.mtProviderTable.getSelectionModel().addListSelectionListener(e -> this.updateEnabledness());
        this.panel.mtProviderTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    int row = MachineTranslationPreferencesController.this.panel.mtProviderTable.rowAtPoint(e.getPoint());
                    MachineTranslationPreferencesController.this.getProviderAtRow(row).ifPresent(provider -> {
                        if (provider.isConfigurable()) {
                            MachineTranslationPreferencesController.this.showProviderConfigUI((IMachineTranslation)provider);
                        }
                    });
                }
            }
        });
        this.panel.configureButton.addActionListener(e -> this.getSelectedProvider().ifPresent(this::showProviderConfigUI));
        this.panel.autoFetchCheckBox.addActionListener(e -> this.panel.untranslatedOnlyCheckBox.setSelected(this.panel.autoFetchCheckBox.isSelected()));
    }

    void updateEnabledness() {
        boolean enabled = this.getSelectedProvider().map(IMachineTranslation::isConfigurable).orElse(false);
        this.panel.configureButton.setEnabled(enabled);
    }

    Optional<IMachineTranslation> getSelectedProvider() {
        int row = this.panel.mtProviderTable.getSelectedRow();
        return this.getProviderAtRow(row);
    }

    Optional<IMachineTranslation> getProviderAtRow(int row) {
        try {
            ProvidersTableModel model = (ProvidersTableModel)this.panel.mtProviderTable.getModel();
            return Optional.of(model.getProviderAt(row));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    void showProviderConfigUI(IMachineTranslation provider) {
        provider.showConfigurationUI(SwingUtilities.windowForComponent(this.panel));
    }

    @Override
    protected void initFromPrefs() {
        boolean mtAutoFetch = Preferences.isPreference("mt_auto_fetch");
        this.panel.autoFetchCheckBox.setSelected(mtAutoFetch);
        this.panel.untranslatedOnlyCheckBox.setSelected(Preferences.isPreference("mt_only_untranslated"));
        this.panel.untranslatedOnlyCheckBox.setEnabled(mtAutoFetch);
        List<IMachineTranslation> mtProviders = MachineTranslators.getMachineTranslators();
        mtProviders.stream().forEach(p -> this.providerStatus.put(p.getName(), p.isEnabled()));
        this.panel.mtProviderTable.setModel(new ProvidersTableModel(mtProviders));
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.autoFetchCheckBox.setSelected(false);
        this.panel.untranslatedOnlyCheckBox.setSelected(false);
        this.panel.untranslatedOnlyCheckBox.setEnabled(false);
        List<IMachineTranslation> mtProviders = MachineTranslators.getMachineTranslators();
        mtProviders.stream().forEach(p -> this.providerStatus.put(p.getName(), false));
        this.panel.mtProviderTable.setModel(new ProvidersTableModel(mtProviders));
        this.updateEnabledness();
    }

    @Override
    public void persist() {
        Preferences.setPreference("mt_auto_fetch", this.panel.autoFetchCheckBox.isSelected());
        Preferences.setPreference("mt_only_untranslated", this.panel.untranslatedOnlyCheckBox.isSelected());
        MachineTranslators.getMachineTranslators().stream().forEach(p -> {
            Boolean status = this.providerStatus.get(p.getName());
            if (status != null) {
                p.setEnabled(status);
            }
        });
    }

    class ProvidersTableModel
    extends AbstractTableModel {
        private final List<IMachineTranslation> mtProviders;

        ProvidersTableModel(List<IMachineTranslation> mtProviders) {
            this.mtProviders = mtProviders;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return ProviderColumn.get(column) == ProviderColumn.CHECKBOX;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (ProviderColumn.get(column) == ProviderColumn.CHECKBOX) {
                MachineTranslationPreferencesController.this.providerStatus.put(this.mtProviders.get(row).getName(), (Boolean)aValue);
            }
        }

        @Override
        public int getColumnCount() {
            return ProviderColumn.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return ProviderColumn.get((int)column).label;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (ProviderColumn.get(column)) {
                case CHECKBOX: {
                    return MachineTranslationPreferencesController.this.providerStatus.get(this.mtProviders.get(row).getName());
                }
                case NAME: {
                    return this.mtProviders.get(row).getName();
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int getRowCount() {
            return this.mtProviders.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ProviderColumn.get((int)columnIndex).clazz;
        }

        public IMachineTranslation getProviderAt(int row) {
            return this.mtProviders.get(row);
        }
    }

    static enum ProviderColumn {
        NAME(0, OStrings.getString("PREFS_MT_HEADER_PROVIDER"), String.class),
        CHECKBOX(1, OStrings.getString("PREFS_MT_HEADER_ENABLED"), Boolean.class);

        private final int index;
        private final String label;
        private final Class<?> clazz;

        private ProviderColumn(int i, String label, Class<?> clazz) {
            this.index = i;
            this.label = label;
            this.clazz = clazz;
        }

        static ProviderColumn get(int i) {
            return ProviderColumn.values()[i];
        }
    }
}

