/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import javax.swing.JComponent;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.GlossaryAutoCompleterOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.StaticUIUtils;

public class GlossaryAutoCompleterOptionsController
extends BasePreferencesController {
    private GlossaryAutoCompleterOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_AUTOCOMPLETER_GLOSSARY");
    }

    private void initGui() {
        this.panel = new GlossaryAutoCompleterOptionsPanel();
        this.panel.displaySourceCheckBox.addActionListener(e -> this.activateSourceItems(this.panel.displaySourceCheckBox.isSelected()));
        this.panel.enabledCheckBox.addActionListener(e -> this.updateEnabledness());
    }

    private void activateSourceItems(boolean activate) {
        this.panel.sortBySourceCheckBox.setEnabled(activate);
        this.panel.sourceFirstRadioButton.setEnabled(activate);
        this.panel.targetFirstRadioButton.setEnabled(activate);
    }

    @Override
    protected void initFromPrefs() {
        this.panel.displaySourceCheckBox.setSelected(Preferences.isPreference("ac_glossary_show_source"));
        this.panel.sourceFirstRadioButton.setSelected(!Preferences.isPreference("ac_glossary_show_target_before_source"));
        this.panel.targetFirstRadioButton.setSelected(Preferences.isPreference("ac_glossary_show_target_before_source"));
        this.panel.sortBySourceCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_by_source"));
        this.panel.longerFirstCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_by_length"));
        this.panel.sortEntriesCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_alphabetically"));
        this.panel.enabledCheckBox.setSelected(Preferences.isPreferenceDefault("ac_glossary_enabled", true));
        this.updateEnabledness();
    }

    @Override
    public void restoreDefaults() {
        this.panel.displaySourceCheckBox.setSelected(false);
        this.panel.sourceFirstRadioButton.setSelected(true);
        this.panel.targetFirstRadioButton.setSelected(false);
        this.panel.sortBySourceCheckBox.setSelected(false);
        this.panel.longerFirstCheckBox.setSelected(false);
        this.panel.sortEntriesCheckBox.setSelected(false);
        this.panel.enabledCheckBox.setSelected(true);
        this.updateEnabledness();
    }

    private void updateEnabledness() {
        this.activateSourceItems(this.panel.displaySourceCheckBox.isSelected());
        StaticUIUtils.setHierarchyEnabled(this.panel.optionsPanel, this.panel.enabledCheckBox.isSelected());
    }

    @Override
    public void persist() {
        Preferences.setPreference("ac_glossary_show_source", this.panel.displaySourceCheckBox.isSelected());
        if (this.panel.displaySourceCheckBox.isSelected()) {
            Preferences.setPreference("ac_glossary_show_target_before_source", this.panel.targetFirstRadioButton.isSelected());
            Preferences.setPreference("ac_glossary_sort_by_source", this.panel.sortBySourceCheckBox.isSelected());
        }
        Preferences.setPreference("ac_glossary_sort_by_length", this.panel.longerFirstCheckBox.isSelected());
        Preferences.setPreference("ac_glossary_sort_alphabetically", this.panel.sortEntriesCheckBox.isSelected());
        Preferences.setPreference("ac_glossary_enabled", this.panel.enabledCheckBox.isSelected());
    }
}

