/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.trie4j.AbstractTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.tail.TailCharIterator;
import org.trie4j.tail.TailUtil;
import org.trie4j.tail.builder.SuffixTrieTailBuilder;
import org.trie4j.tail.builder.TailBuilder;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;
import org.trie4j.util.Range;

public class InlinedTailLOUDSTrie
extends AbstractTrie
implements Externalizable,
TermIdTrie {
    private BytesSuccinctBitVector bv;
    private int size;
    private char[] labels;
    private int[] tail;
    private CharSequence tails;
    private SuccinctBitVector term;
    private int nodeSize;

    public InlinedTailLOUDSTrie() {
        this.bv = new BytesSuccinctBitVector(0);
    }

    public InlinedTailLOUDSTrie(Trie orig) {
        this(orig, new SuffixTrieTailBuilder());
    }

    public InlinedTailLOUDSTrie(Trie orig, TailBuilder tb) {
        this(orig, tb, new BytesSuccinctBitVector(orig.size() * 2));
    }

    public InlinedTailLOUDSTrie(Trie orig, TailBuilder tb, BytesSuccinctBitVector bv) {
        this.bv = bv;
        this.size = orig.size();
        this.labels = new char[this.size];
        this.tail = new int[this.size];
        FastBitSet termBs = new FastBitSet(this.size);
        LinkedList<Node> queue = new LinkedList<Node>();
        int count = 0;
        if (orig.getRoot() != null) {
            queue.add(orig.getRoot());
        }
        while (!queue.isEmpty()) {
            int index;
            Node node = (Node)queue.pollFirst();
            if ((index = count++) >= this.labels.length) {
                this.extend();
            }
            if (node.isTerminate()) {
                termBs.set(index);
            } else if (termBs.size() <= index) {
                termBs.ensureCapacity(index);
            }
            for (Node c : node.getChildren()) {
                bv.append1();
                queue.offerLast(c);
            }
            bv.append0();
            char[] letters = node.getLetters();
            if (letters.length == 0) {
                this.labels[index] = 65535;
                this.tail[index] = -1;
                continue;
            }
            this.labels[index] = letters[0];
            if (letters.length >= 2) {
                this.tail[index] = tb.insert(letters, 1, letters.length - 1);
                continue;
            }
            this.tail[index] = -1;
        }
        this.nodeSize = count;
        this.tails = tb.getTails();
        this.term = new BytesRank1OnlySuccinctBitVector(termBs.getBytes(), termBs.size());
    }

    public BytesSuccinctBitVector getBv() {
        return this.bv;
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public TermIdNode getRoot() {
        return new LOUDSNode(0);
    }

    @Override
    public void dump(Writer writer) throws IOException {
        super.dump(writer);
        String bvs = this.bv.toString();
        writer.write("bitvec: " + (bvs.length() > 100 ? bvs.substring(0, 100) : bvs));
        writer.write("\nlabels: ");
        int count = 0;
        for (char c : this.labels) {
            writer.write(c);
            if (count++ == 99) break;
        }
        writer.write("\n");
    }

    @Override
    public boolean contains(String text) {
        int nodeId = 0;
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i))) == -1) {
                return false;
            }
            it.setIndex(this.tail[nodeId]);
            while (it.hasNext()) {
                if (++i == n) {
                    return false;
                }
                if (text.charAt(i) == it.next()) continue;
                return false;
            }
        }
        return this.term.get(nodeId);
    }

    public int getNodeId(String text) {
        int nodeId = 0;
        Range r = new Range();
        TailCharIterator it = new TailCharIterator(this.tails, -1);
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            if ((nodeId = this.getChildNode(nodeId, text.charAt(i), r)) == -1) {
                return -1;
            }
            it.setOffset(this.tail[nodeId]);
            while (it.hasNext()) {
                if (++i == n) {
                    return -1;
                }
                if (text.charAt(i) == it.next()) continue;
                return -1;
            }
        }
        return nodeId;
    }

    @Override
    public int getTermId(String text) {
        int nodeId = this.getNodeId(text);
        if (nodeId == -1) {
            return -1;
        }
        return this.term.get(nodeId) ? this.term.rank1(nodeId) - 1 : -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int findShortestWord(CharSequence chars, int start, int end, StringBuilder word) {
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        block0: for (int i = start; i < end; ++i) {
            int child;
            int nodeId = 0;
            for (int j = i; j < end && (child = this.getChildNode(nodeId, chars.charAt(j))) != -1; ++j) {
                tci.setIndex(this.tail[child]);
                boolean found = true;
                while (tci.hasNext()) {
                    found = false;
                    if (++j >= end || chars.charAt(j) != tci.next()) break;
                    found = true;
                }
                if (!found) continue block0;
                if (this.term.get(child)) {
                    word.append(chars, i, j + 1);
                    return i;
                }
                nodeId = child;
            }
        }
        return -1;
    }

    @Override
    public int findLongestWord(CharSequence chars, int start, int end, StringBuilder word) {
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        for (int i = start; i < end; ++i) {
            int child;
            int nodeId = 0;
            int lastJ = -1;
            for (int j = i; j < end && (child = this.getChildNode(nodeId, chars.charAt(j))) != -1; ++j) {
                tci.setIndex(this.tail[child]);
                boolean found = true;
                while (tci.hasNext()) {
                    found = false;
                    if (++j >= end || chars.charAt(j) != tci.next()) break;
                    found = true;
                }
                if (!found) break;
                if (this.term.get(child)) {
                    lastJ = j;
                }
                nodeId = child;
            }
            if (lastJ == -1) continue;
            word.append(chars, i, lastJ + 1);
            return i;
        }
        return -1;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setIndex(this.tail[child]);
            while (tci.hasNext()) {
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            if (this.term.get(child)) {
                ret.add(new String(chars, 0, charsIndex + 1));
            }
            nodeId = child;
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tail[child]);
            while (tci.hasNext()) {
                if (charsLen <= ++charsIndex) {
                    return ret;
                }
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            if (this.term.get(child)) {
                ret.add(Pair.create(new String(chars, 0, charsIndex + 1), this.term.rank1(child) - 1));
            }
            nodeId = child;
        }
        return ret;
    }

    @Override
    public Iterable<String> predictiveSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        String pfx = null;
        int charsIndexBack = 0;
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex]);
            if (child == -1) {
                return ret;
            }
            tci.setIndex(this.tail[child]);
            while (tci.hasNext() && ++charsIndex < charsLen) {
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            nodeId = child;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            b.append(this.labels[nid]);
            tci.setIndex(this.tail[nid]);
            while (tci.hasNext()) {
                b.append(tci.next());
            }
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(letter);
            }
            int s = this.bv.select0(nid) + 1;
            int e = this.bv.next0(s);
            int lastNodeId = this.bv.rank1(s) + e - s - 1;
            for (int i = e - 1; i >= s; --i) {
                queue.offerFirst(Pair.create(lastNodeId--, letter));
            }
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int nodeId = 0;
        Range r = new Range();
        TailCharIterator tci = new TailCharIterator(this.tails, -1);
        String pfx = null;
        int charsIndexBack = 0;
        for (int charsIndex = 0; charsIndex < charsLen; ++charsIndex) {
            charsIndexBack = charsIndex;
            int child = this.getChildNode(nodeId, chars[charsIndex], r);
            if (child == -1) {
                return ret;
            }
            tci.setOffset(this.tail[child]);
            while (tci.hasNext() && ++charsIndex < charsLen) {
                if (chars[charsIndex] == tci.next()) continue;
                return ret;
            }
            nodeId = child;
        }
        pfx = new String(chars, 0, charsIndexBack);
        LinkedList<Pair<Integer, String>> queue = new LinkedList<Pair<Integer, String>>();
        queue.offerLast(Pair.create(nodeId, pfx));
        while (queue.size() > 0) {
            int i;
            Pair element = (Pair)queue.pollFirst();
            int nid = (Integer)element.getFirst();
            StringBuilder b = new StringBuilder((String)element.getSecond());
            if (nid > 0) {
                b.append(this.labels[nid]);
            }
            tci.setIndex(this.tail[nid]);
            while (tci.hasNext()) {
                b.append(tci.next());
            }
            String letter = b.toString();
            if (this.term.get(nid)) {
                ret.add(Pair.create(letter, this.term.rank1(nid) - 1));
            }
            int s = this.bv.select0(nid) + 1;
            int e = this.bv.next0(s);
            int lastNodeId = this.bv.rank1(s) + e - s - 1;
            for (i = e - 1; i >= s; --i) {
                queue.offerFirst(Pair.create(lastNodeId--, letter));
            }
            for (i = e - 1; i >= s; --i) {
                queue.offerFirst(Pair.create(i, letter));
            }
        }
        return ret;
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trimToSize() {
        if (this.labels.length > this.nodeSize) {
            this.labels = Arrays.copyOf(this.labels, this.nodeSize);
            this.tail = Arrays.copyOf(this.tail, this.nodeSize);
        }
        this.bv.trimToSize();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        this.labels = new char[this.nodeSize];
        for (i = 0; i < this.nodeSize; ++i) {
            this.labels[i] = in.readChar();
        }
        this.tail = new int[this.nodeSize];
        for (i = 0; i < this.nodeSize; ++i) {
            this.tail[i] = in.readInt();
        }
        int ts = in.readInt();
        StringBuilder b = new StringBuilder(ts);
        for (int i2 = 0; i2 < ts; ++i2) {
            b.append(in.readChar());
        }
        this.tails = b;
        this.term = (BytesRank1OnlySuccinctBitVector)in.readObject();
        this.bv.readExternal(in);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        void var2_5;
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        this.trimToSize();
        for (char c : this.labels) {
            out.writeChar(c);
        }
        for (int i : this.tail) {
            out.writeInt(i);
        }
        out.writeInt(this.tails.length());
        boolean bl = false;
        while (var2_5 < this.tails.length()) {
            out.writeChar(this.tails.charAt((int)var2_5));
            ++var2_5;
        }
        out.writeObject(this.term);
        this.bv.writeExternal(out);
    }

    private int getChildNode(int nodeId, char c) {
        int start = this.bv.select0(nodeId) + 1;
        int end = this.bv.next0(start);
        if (end == -1) {
            return -1;
        }
        int pos2Id = this.bv.rank1(start) - start;
        if (end - start <= 16) {
            for (int i = start; i < end; ++i) {
                int index = i + pos2Id;
                int d = c - this.labels[index];
                if (d != 0) continue;
                return index;
            }
            return -1;
        }
        do {
            int i;
            int index;
            int d;
            if ((d = c - this.labels[index = (i = (start + end) / 2) + pos2Id]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return index;
        } while (start != end);
        return -1;
    }

    private int getChildNode(int nodeId, char c, Range r) {
        int start = this.bv.select0(nodeId) + 1;
        int end = this.bv.next0(start);
        if (end == -1) {
            return -1;
        }
        if (end - start <= 16) {
            for (int i = start; i < end; ++i) {
                if (c != this.labels[i]) continue;
                return i;
            }
            return -1;
        }
        do {
            int i;
            int d;
            if ((d = c - this.labels[i = (start + end) / 2]) < 0) {
                end = i;
                continue;
            }
            if (d > 0) {
                if (start == i) {
                    return -1;
                }
                start = i;
                continue;
            }
            return i;
        } while (start != end);
        return -1;
    }

    private void extend() {
        int nsz = (int)((double)this.labels.length * 1.2);
        if (nsz <= this.labels.length) {
            nsz = this.labels.length * 2 + 1;
        }
        this.labels = Arrays.copyOf(this.labels, nsz);
        this.tail = Arrays.copyOf(this.tail, nsz);
    }

    public class LOUDSNode
    implements TermIdNode {
        private int nodeId;

        public LOUDSNode(int nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public int getTermId() {
            return this.nodeId;
        }

        @Override
        public char[] getLetters() {
            int ti;
            StringBuilder b = new StringBuilder();
            char h = InlinedTailLOUDSTrie.this.labels[this.nodeId];
            if (h != '\uffff') {
                b.append(h);
            }
            if ((ti = InlinedTailLOUDSTrie.this.tail[this.nodeId]) != -1) {
                TailUtil.appendChars(InlinedTailLOUDSTrie.this.tails, ti, b);
            }
            return b.toString().toCharArray();
        }

        @Override
        public boolean isTerminate() {
            return InlinedTailLOUDSTrie.this.term.get(this.nodeId);
        }

        @Override
        public TermIdNode getChild(char c) {
            int nid = InlinedTailLOUDSTrie.this.getChildNode(this.nodeId, c);
            if (nid == -1) {
                return null;
            }
            return new LOUDSNode(nid);
        }

        @Override
        public TermIdNode[] getChildren() {
            int start = 0;
            if (this.nodeId > 0) {
                start = InlinedTailLOUDSTrie.this.bv.select0(this.nodeId) + 1;
            }
            int end = InlinedTailLOUDSTrie.this.bv.next0(start);
            int ci = InlinedTailLOUDSTrie.this.bv.rank1(start);
            int n = end - start;
            TermIdNode[] children = new TermIdNode[n];
            for (int i = 0; i < n; ++i) {
                children[i] = new LOUDSNode(ci + i);
            }
            return children;
        }
    }
}

