/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.source;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceFS;
import org.openide.filesystems.FileObject;

final class SourceFilesCache {
    private static final Map<JPDADebugger, SourceFilesCache> MAP = new WeakHashMap<JPDADebugger, SourceFilesCache>();
    private final SourceFS fs = new SourceFS();

    private SourceFilesCache() {
    }

    public static synchronized SourceFilesCache get(JPDADebugger jpda) {
        SourceFilesCache sfc = MAP.get(jpda);
        if (sfc == null) {
            sfc = new SourceFilesCache();
            MAP.put(jpda, sfc);
        }
        return sfc;
    }

    public URL getSourceFile(String name, long hash, URI uri, String content) throws IOException {
        String path;
        FileObject fo;
        String justName = name;
        int i = justName.lastIndexOf(File.separatorChar);
        if (i >= 0 && (justName = justName.substring(i + 1)).isEmpty()) {
            justName = name.replace(File.separatorChar, '_');
        }
        if ((fo = this.fs.findResource(path = Long.toHexString(hash) + "/" + justName)) == null) {
            fo = this.fs.createFile(path, content);
            if (fo == null) {
                throw new IllegalArgumentException("Not able to create file with name '" + justName + "'. Path = " + path);
            }
            fo.setAttribute("com.oracle.truffle InternalURI", (Object)uri);
        }
        return fo.toURL();
    }
}

