/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.hudson.php.util.FileUtils;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.openide.filesystems.FileObject;

public final class PhpUnitUtils {
    static final Charset XML_CHARSET = StandardCharsets.UTF_8;
    private static final String BOOTSTRAP_LINE = "bootstrap=\"tests/bootstrap.php\"";
    private static final String PROJECT_NAME_LINE = "<testsuite name=\"%s\">";
    private static final String SRC_DIR_LINE = "<directory suffix=\".php\">%s</directory>";
    private static final String TESTS_DIR_LINE = "<directory suffix=\"Test.php\">%s</directory>";
    private static final String TITLE_LINE = "title=\"%s\"";

    private PhpUnitUtils() {
    }

    public static void processPhpUnitConfig(PhpModule phpModule, Path projectPhpUnitConfig) throws IOException {
        List<String> newLines = PhpUnitUtils.processPhpUnitConfigLines(phpModule.getDisplayName(), phpModule.getProjectDirectory(), phpModule.getSourceDirectory(), phpModule.getTestDirectories(), Files.readAllLines(projectPhpUnitConfig, XML_CHARSET));
        Files.write(projectPhpUnitConfig, newLines, XML_CHARSET, new OpenOption[0]);
    }

    static List<String> processPhpUnitConfigLines(String projectName, FileObject projectDir, FileObject srcDir, List<FileObject> testDirs, List<String> currentLines) {
        ArrayList<String> newLines = new ArrayList<String>(currentLines.size() * 2);
        String projectNameLine = String.format(PROJECT_NAME_LINE, "ProjectName");
        String unitTestsLine = String.format(TESTS_DIR_LINE, "tests/unit/");
        String integrationTestsLine = String.format(TESTS_DIR_LINE, "tests/integration/");
        String titleLine = String.format(TITLE_LINE, "BankAccount");
        String srcLine = String.format(SRC_DIR_LINE, "src");
        for (String line : currentLines) {
            if (line.contains(BOOTSTRAP_LINE)) {
                newLines.add(line.replace(BOOTSTRAP_LINE, ""));
                continue;
            }
            if (line.contains(projectNameLine)) {
                newLines.add(line.replace(projectNameLine, String.format(PROJECT_NAME_LINE, projectName)));
                continue;
            }
            if (line.contains(unitTestsLine)) {
                for (FileObject testDir : testDirs) {
                    newLines.add(line.replace(unitTestsLine, String.format(TESTS_DIR_LINE, FileUtils.relativizePath(projectDir, testDir))));
                }
                continue;
            }
            if (line.contains(integrationTestsLine)) continue;
            if (line.contains(titleLine)) {
                newLines.add(line.replace(titleLine, String.format(TITLE_LINE, projectName)));
                continue;
            }
            if (line.contains(srcLine)) {
                newLines.add(line.replace(srcLine, String.format(SRC_DIR_LINE, FileUtils.relativizePath(projectDir, srcDir))));
                continue;
            }
            newLines.add(line);
        }
        return newLines;
    }
}

