/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.extexecution.base;

import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.extexecution.base.ProcessParametersAccessor;

public final class ProcessParameters {
    private final String executable;
    private final String workingDirectory;
    private final List<String> arguments;
    private final boolean redirectErrorStream;
    private final Map<String, String> environmentVariables;

    private ProcessParameters(String executable, String workingDirectory, List<String> arguments, boolean redirectErrorStream, Map<String, String> environmentVariables) {
        this.executable = executable;
        this.workingDirectory = workingDirectory;
        this.arguments = arguments;
        this.redirectErrorStream = redirectErrorStream;
        this.environmentVariables = environmentVariables;
    }

    @NonNull
    public String getExecutable() {
        return this.executable;
    }

    @CheckForNull
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NonNull
    public List<String> getArguments() {
        return this.arguments;
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    @NonNull
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    static {
        ProcessParametersAccessor.setDefault(new ProcessParametersAccessor(){

            @Override
            public ProcessParameters createProcessParameters(String executable, String workingDirectory, List<String> arguments, boolean redirectErrorStream, Map<String, String> environmentVariables) {
                return new ProcessParameters(executable, workingDirectory, arguments, redirectErrorStream, environmentVariables);
            }
        });
    }
}

