/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SampledCPUSnapshot;
import org.netbeans.modules.profiler.snaptracer.logs.LogReader;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public final class IdeSnapshot {
    private final SampledCPUSnapshot cpuSnapshot;
    private LogReader xmlLogs;
    private LogRecord lastRecord;
    private Map<Integer, LogRecord> recordsMap;
    private Map<Integer, LogRecordInfo> infosMap;
    private final FileObject npssFileObject;

    public IdeSnapshot(FileObject npssFO, FileObject uigestureFO) throws IOException {
        this.cpuSnapshot = new SampledCPUSnapshot(npssFO);
        this.npssFileObject = npssFO;
        if (uigestureFO != null) {
            this.xmlLogs = new LogReader(uigestureFO);
            this.xmlLogs.load();
            this.recordsMap = new HashMap<Integer, LogRecord>();
            this.infosMap = new HashMap<Integer, LogRecordInfo>();
        }
    }

    int getSamplesCount() {
        return this.cpuSnapshot.getSamplesCount();
    }

    long getTimestamp(int sampleIndex) throws IOException {
        return this.cpuSnapshot.getTimestamp(sampleIndex);
    }

    FileObject getNpssFileObject() {
        return this.npssFileObject;
    }

    public boolean hasUiGestures() {
        return this.xmlLogs != null;
    }

    LoadedSnapshot getCPUSnapshot(int startIndex, int endIndex) throws IOException {
        return this.cpuSnapshot.getCPUSnapshot(startIndex, endIndex);
    }

    public long getValue(int sampleIndex, int valIndex) throws IOException {
        Integer val;
        if (valIndex == 0) {
            return this.cpuSnapshot.getValue(sampleIndex, valIndex);
        }
        if (this.xmlLogs != null && (val = this.getLogRecordValue(sampleIndex)) != null) {
            return val.intValue();
        }
        return 0L;
    }

    public LogRecordInfo getLogInfoForValue(long loggerValue) {
        if (this.xmlLogs == null || loggerValue == 0L) {
            return null;
        }
        Integer index = new Integer((int)loggerValue);
        LogRecordInfo info = this.infosMap.get(index);
        if (info == null) {
            LogRecord rec = this.recordsMap.get(index);
            assert (rec != null) : "Null record for value " + index;
            info = new LogRecordInfo(rec);
            LogRecordDecorator.decorate(info);
            this.infosMap.put(index, info);
        }
        return info;
    }

    private Integer getLogRecordValue(int sampleIndex) throws IOException {
        long timestamp = this.getTimestamp(sampleIndex);
        LogRecord rec = this.xmlLogs.getRecordFor(timestamp / 1000000L);
        if (rec != null) {
            long startTime = this.cpuSnapshot.getStartTime();
            long endTime = this.getTimestamp(this.getSamplesCount() - 1);
            long recTime = rec.getMillis() * 1000000L;
            if (recTime > startTime && recTime < endTime && rec != this.lastRecord) {
                Integer index = new Integer(sampleIndex + 1);
                this.lastRecord = rec;
                this.recordsMap.put(index, rec);
                return index;
            }
        }
        return null;
    }

    String getThreadDump(int sampleIndex) throws IOException {
        return this.cpuSnapshot.getThreadDump(sampleIndex);
    }

    List<Integer> getIntervals(int start, int end, PrestimeCPUCCTNode node) throws IOException {
        return this.cpuSnapshot.getIntervals(start, end, node);
    }

    public static final class LogRecordInfo {
        private static final int MAX_DISPLAY_NAME = 40;
        private String name;
        private String displayName;
        private String toolTip;
        private Icon icon;
        private LogRecord record;

        LogRecordInfo(LogRecord rec) {
            this.record = rec;
        }

        void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            String message;
            if (this.displayName == null && (message = this.record.getMessage()) != null && message.length() > 0) {
                StringBuilder sb = new StringBuilder(message);
                Object[] arr = this.record.getParameters();
                if (arr != null && arr.length > 0) {
                    String sep = " (";
                    for (Object par : arr) {
                        sb.append(sep);
                        sb.append(par);
                        sep = ", ";
                        if (sb.length() <= 40) continue;
                        return sb.substring(0, 40).concat(" ...");
                    }
                    sb.append(")");
                }
                return sb.toString();
            }
            return this.displayName;
        }

        void setToolTip(String toolTip) {
            this.toolTip = toolTip;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    private static final class LogRecordDecorator
    implements InvocationHandler {
        private static final String DECORATIONS_CLASS = "org.netbeans.lib.uihandler.Decorations";
        private static final String DECORABLE_CLASS = "org.netbeans.lib.uihandler.Decorable";
        private static final String DECORATE_METHOD = "decorate";
        private static final String DECORABLE_SETNAME_METHOD = "setName";
        private static final String DECORABLE_SETDISPLAYNAME_METHOD = "setDisplayName";
        private static final String DECORABLE_SETICONBASE_METHOD = "setIconBaseWithExtension";
        private static final String DECORABLE_SETSHORTDESCRIPTOR_METHOD = "setShortDescription";
        private LogRecordInfo recInfo;
        private LogRecord rec;

        LogRecordDecorator(LogRecordInfo info) {
            this.recInfo = info;
            this.rec = info.record;
        }

        private void decorateRecord() {
            try {
                ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> decorationClass = Class.forName(DECORATIONS_CLASS, true, c);
                Class<?> decorableClass = Class.forName(DECORABLE_CLASS, true, c);
                Object decorable = Proxy.newProxyInstance(c, new Class[]{decorableClass}, (InvocationHandler)this);
                Method decorate = decorationClass.getDeclaredMethod(DECORATE_METHOD, LogRecord.class, decorableClass);
                decorate.setAccessible(true);
                decorate.invoke(null, this.rec, decorable);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (DECORABLE_SETNAME_METHOD.equals(methodName)) {
                this.recInfo.setName((String)args[0]);
            }
            if (DECORABLE_SETDISPLAYNAME_METHOD.equals(methodName)) {
                this.recInfo.setDisplayName((String)args[0]);
            }
            if (DECORABLE_SETSHORTDESCRIPTOR_METHOD.equals(methodName)) {
                this.recInfo.setToolTip((String)args[0]);
            }
            if (DECORABLE_SETICONBASE_METHOD.equals(methodName)) {
                String iconBase = (String)args[0];
                this.recInfo.setIcon(ImageUtilities.loadImageIcon((String)iconBase, (boolean)true));
            }
            return null;
        }

        static void decorate(LogRecordInfo info) {
            new LogRecordDecorator(info).decorateRecord();
        }
    }
}

