/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.server.ClassLoaderManager;
import org.netbeans.lib.profiler.server.ProfilerInterface;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjAlloc;
import org.netbeans.lib.profiler.server.ProfilerRuntimeObjLiveness;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.Stacks;

public class ProfilerRuntimeMemory
extends ProfilerRuntime {
    protected static final int MAX_STACK_FRAMES = 100;
    protected static final int NO_OF_PROFILER_FRAMES = 3;
    protected static int[] allocatedInstancesCount;
    protected static int allocatedInstArrayLength;
    protected static short[] allocatedInstThreshold;
    protected static char[] objectSize;
    protected static short samplingInterval;
    protected static int stackSamplingDepth;
    static final Object classIdMapLock;
    private static int currentStackDepth;
    private static int[] stackFrameIds;
    private static Map classIdMap;
    private static volatile boolean resultsAvailable;
    private static final boolean DEBUG = false;
    private static long randSeed;
    private static int bits;
    private static short samplingIntervalBase;

    public static void setAllocatedInstancesCountArray(int[] aic) {
        allocatedInstancesCount = aic;
        if (aic == null) {
            allocatedInstThreshold = null;
            objectSize = null;
            stackFrameIds = null;
            Stacks.clearNativeStackFrameBuffer();
            return;
        }
        if (allocatedInstArrayLength < aic.length) {
            short[] oldThresh = (short[])(allocatedInstThreshold != null ? allocatedInstThreshold : null);
            allocatedInstThreshold = new short[aic.length];
            if (oldThresh != null) {
                System.arraycopy(oldThresh, 0, allocatedInstThreshold, 0, allocatedInstArrayLength);
            }
            char[] oldObjectSize = (char[])(objectSize != null ? objectSize : null);
            objectSize = new char[aic.length];
            if (oldObjectSize != null) {
                System.arraycopy(oldObjectSize, 0, objectSize, 0, allocatedInstArrayLength);
            }
            allocatedInstArrayLength = aic.length;
        }
    }

    public static void setStackSamplingDepth(int val) {
        if (val < 0) {
            val = 100;
        } else if (val > 0) {
            if ((val += 3) > 100) {
                val = 100;
            }
        } else {
            currentStackDepth = 0;
        }
        stackSamplingDepth = val;
    }

    public static void setSamplingInterval(short val) {
        samplingInterval = val;
        ProfilerRuntimeMemory.initRandomGenerator();
    }

    public static void resetProfilerCollectors(int instrType) {
        if (allocatedInstancesCount != null) {
            for (int i = 0; i < allocatedInstancesCount.length; ++i) {
                ProfilerRuntimeMemory.allocatedInstancesCount[i] = 0;
                ProfilerRuntimeMemory.allocatedInstThreshold[i] = 0;
            }
        }
        if (instrType == 6) {
            ProfilerRuntimeObjLiveness.resetProfilerCollectors();
        }
        classIdMap = new HashMap();
        resultsAvailable = false;
    }

    public static void traceVMObjectAlloc(Object instance, Class clazz) {
        if (classIdMap == null || ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(Thread.currentThread())) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            ti.initialize();
            if (lockContentionMonitoringEnabled) {
                ProfilerRuntimeMemory.writeThreadCreationEvent(ti);
            }
        }
        ++ti.inProfilingRuntimeMethod;
        int classId = ProfilerRuntimeMemory.getClassId(clazz);
        if (classId == -1) {
            --ti.inProfilingRuntimeMethod;
            return;
        }
        boolean isObjectLiveness = ProfilerInterface.getCurrentInstrType() == 6;
        --ti.inProfilingRuntimeMethod;
        if (isObjectLiveness) {
            ProfilerRuntimeObjLiveness.traceObjAlloc(instance, (char)classId);
        } else {
            ProfilerRuntimeObjAlloc.traceObjAlloc(instance, (char)classId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getClassId(Class clazz) {
        Integer classIdInt;
        String className = clazz.getName();
        int definingClassLoaderId = ClassLoaderManager.registerLoader(clazz);
        String classNameId = new StringBuffer(className).append('#').append(definingClassLoaderId).toString();
        Object object = classIdMapLock;
        synchronized (object) {
            classIdInt = (Integer)classIdMap.get(classNameId);
        }
        if (classIdInt == null) {
            int newClassId = externalActionsHandler.handleFirstTimeVMObjectAlloc(className, definingClassLoaderId);
            classIdInt = newClassId;
            Object object2 = classIdMapLock;
            synchronized (object2) {
                classIdMap.put(classNameId, classIdInt);
            }
            if (newClassId == -1) {
                // empty if block
            }
        }
        return classIdInt;
    }

    static boolean isInternalClass(Class clazz) {
        return clazz == ThreadInfo.class || clazz == ThreadInfo[].class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(int classId, long objSize) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (stackSamplingDepth != 0) {
                currentStackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), stackSamplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjAllocStackTraceEvent(classId, objSize);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void getAndSendCurrentStackTrace(int classId, char epoch, int objCount, long objSize) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (stackSamplingDepth != 0) {
                currentStackDepth = Stacks.getCurrentStackFrameIds(Thread.currentThread(), stackSamplingDepth, stackFrameIds);
            }
            ProfilerRuntimeMemory.writeObjLivenessStackTraceEvent(classId, epoch, objCount, objSize);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    protected static long getCachedObjectSize(int classInt, Object object) {
        long objSize = objectSize[classInt];
        if (objSize <= 1L) {
            if (object == null) {
                System.err.println("*** JFluid critical error: received null object for classId = " + classInt + " in getCachedObjectSize");
                Thread.dumpStack();
                System.err.println("*** End JFluid critical error message ---------------------------");
            }
            if (objSize == 0L) {
                objSize = Classes.getObjectSize((Object)object);
                ProfilerRuntimeMemory.objectSize[classInt] = object.getClass().isArray() || objSize > 65535L ? (char)'\u0001' : (char)objSize;
            } else {
                objSize = Classes.getObjectSize((Object)object);
            }
        }
        return objSize;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        allocatedInstancesCount = null;
        stackFrameIds = null;
        Stacks.clearNativeStackFrameBuffer();
    }

    protected static void createNewDataStructures() {
        ProfilerRuntime.createNewDataStructures();
        stackFrameIds = new int[100];
        Stacks.createNativeStackFrameBuffer(100);
        classIdMap = new HashMap();
        resultsAvailable = false;
    }

    protected static void enableProfiling(boolean v) {
    }

    protected static void initRandomGenerator() {
        short newVal;
        randSeed = System.currentTimeMillis();
        if (samplingInterval == 1) {
            return;
        }
        if (samplingInterval == 2 || samplingInterval == 3) {
            bits = 1;
            samplingIntervalBase = (short)(samplingInterval - 1);
            return;
        }
        bits = 1;
        short val = 1;
        while ((newVal = val << 1) < samplingInterval) {
            ++bits;
            val = newVal;
        }
        samplingIntervalBase = (short)(samplingInterval - (val >> 1));
        --bits;
    }

    protected static short nextRandomizedInterval() {
        if (samplingInterval == 1) {
            return 1;
        }
        randSeed = randSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (short)(samplingIntervalBase + (int)(randSeed >>> 48 - bits));
    }

    protected static void writeObjAllocStackTraceEvent(int classId, long objSize) {
        int curPos;
        if (eventBuffer == null) {
            return;
        }
        if (currentStackDepth != 0) {
            currentStackDepth -= 3;
        }
        if (!resultsAvailable) {
            resultsAvailable = true;
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((curPos = globalEvBufPos) + 16 + currentStackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, curPos);
            curPos = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[curPos++] = 12;
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(classId >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(classId & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize & 0xFFL);
        globalEvBufPos = curPos = ProfilerRuntimeMemory.writeStack(curPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeObjGCEvent(long objectId) {
        if (eventBuffer == null) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            int curPos = globalEvBufPos;
            if (curPos > globalEvBufPosThreshold) {
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, curPos);
                curPos = 0;
            }
            ProfilerRuntimeMemory.eventBuffer[curPos++] = 15;
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 56 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 48 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 40 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 32 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 24 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 16 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId >> 8 & 0xFFL);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objectId & 0xFFL);
            globalEvBufPos = curPos;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    protected static void writeObjLivenessStackTraceEvent(int classId, char epoch, int objCount, long objSize) {
        int curPos;
        if (eventBuffer == null) {
            return;
        }
        if (currentStackDepth != 0) {
            currentStackDepth -= 3;
        }
        if (!resultsAvailable) {
            resultsAvailable = true;
            ProfilerServer.notifyClientOnResultsAvailability();
        }
        if ((curPos = globalEvBufPos) + 24 + currentStackDepth * 4 > globalEvBufPosThreshold) {
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, curPos);
            curPos = 0;
        }
        ProfilerRuntimeMemory.eventBuffer[curPos++] = 14;
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(classId >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(classId & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(epoch >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(epoch & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objCount >> 24 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objCount >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objCount >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objCount & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 32 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 24 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 16 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize >> 8 & 0xFFL);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(objSize & 0xFFL);
        globalEvBufPos = curPos = ProfilerRuntimeMemory.writeStack(curPos);
    }

    private static int writeStack(int curPos) {
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(currentStackDepth >> 16 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(currentStackDepth >> 8 & 0xFF);
        ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(currentStackDepth & 0xFF);
        int frameIdx = 3;
        for (int i = 0; i < currentStackDepth; ++i) {
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(stackFrameIds[frameIdx] >> 24 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(stackFrameIds[frameIdx] >> 16 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(stackFrameIds[frameIdx] >> 8 & 0xFF);
            ProfilerRuntimeMemory.eventBuffer[curPos++] = (byte)(stackFrameIds[frameIdx] & 0xFF);
            ++frameIdx;
        }
        return curPos;
    }

    static {
        classIdMapLock = new Object();
    }
}

