/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.EntryHandle;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;

public class CssRefactoring {
    private CssRefactoring() {
    }

    public static Collection<Entry> getAllSelectors(FileObject file, RefactoringElementType type) {
        try {
            return CssFileModel.create(Source.create((FileObject)file)).get(type);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static Collection<FileObject> findAllStyleSheets(FileObject baseFile) {
        CssProjectSupport sup = CssProjectSupport.findFor(baseFile);
        if (sup != null) {
            CssIndex index = sup.getIndex();
            return index.getAllIndexedFiles();
        }
        return Collections.emptyList();
    }

    public static Map<FileObject, Collection<EntryHandle>> findAllOccurances(String elementName, RefactoringElementType type, FileObject baseFile, boolean nonVirtualOnly) {
        CssProjectSupport sup = CssProjectSupport.findFor(baseFile);
        if (sup == null) {
            return null;
        }
        CssIndex index = sup.getIndex();
        DependenciesGraph deps = index.getDependencies(baseFile);
        Collection relatedFiles = deps.getAllReferedFiles();
        Collection<FileObject> queryResult = index.find(type, elementName);
        HashMap<FileObject, Collection<EntryHandle>> result = new HashMap<FileObject, Collection<EntryHandle>>();
        for (FileObject file : queryResult) {
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                CssFileModel model = CssFileModel.create(source);
                Collection<Entry> modelEntries = model.get(type);
                ArrayList<EntryHandle> entries = (ArrayList<EntryHandle>)result.get(file);
                if (entries == null) {
                    entries = new ArrayList<EntryHandle>();
                    result.put(file, entries);
                }
                for (Entry entry : modelEntries) {
                    if (!elementName.equals(entry.getName()) || !entry.isValidInSourceDocument() || !nonVirtualOnly || entry.isVirtual()) continue;
                    entries.add(EntryHandle.createEntryHandle(entry, relatedFiles.contains(file)));
                }
            }
            catch (ParseException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return result;
    }
}

