/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.ui.MoveMembersPanel;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersDescription;
import org.netbeans.modules.refactoring.java.ui.elements.FiltersManager;
import org.netbeans.modules.refactoring.java.ui.elements.JCheckBoxIcon;
import org.netbeans.modules.refactoring.java.ui.elements.TapPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExtractSuperclassPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_Selected", "LBL_ExtractSC_Member", "LBL_ExtractSC_MakeAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, MemberInfo.class, Boolean.class};
    private final ExtractSuperclassRefactoring refactoring;
    private final TableModel tableModel;
    private Object[][] members = new Object[0][0];
    private TapPanel filtersPanel;
    private FiltersManager filtersManager;
    private final TreePathHandle[] selected;
    private JPanel membersListPanel;
    private JTable membersTable;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameText;
    private JScrollPane scrollPane;

    public ExtractSuperclassPanel(ExtractSuperclassRefactoring refactoring, TreePathHandle[] selected, final ChangeListener parent) {
        this.refactoring = refactoring;
        this.selected = selected;
        this.tableModel = new TableModel();
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        String defaultName = "NewClass";
        this.nameText.setText(defaultName);
        this.nameText.setSelectionStart(0);
        this.nameText.setSelectionEnd(defaultName.length());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                parent.stateChanged(null);
            }
        });
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        AbstractButton[] res = new AbstractButton[2];
        res[0] = new JButton(null, new JCheckBoxIcon(true, new Dimension(16, 16)));
        res[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractSuperclassPanel.this.selectAll(true);
            }
        });
        res[0].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_SelectAll"));
        res[1] = new JButton(null, new JCheckBoxIcon(false, new Dimension(16, 16)));
        res[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractSuperclassPanel.this.selectAll(false);
            }
        });
        res[1].setToolTipText(NbBundle.getMessage(MoveMembersPanel.class, (String)"TIP_DeselectAll"));
        FiltersDescription desc = new FiltersDescription();
        this.filtersManager = FiltersDescription.createManager(desc);
        JComponent buttons = this.filtersManager.getComponent(res);
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.membersListPanel.add((Component)this.filtersPanel, "South");
    }

    @Override
    public boolean requestFocusInWindow() {
        this.nameText.requestFocusInWindow();
        return true;
    }

    public void initialize() {
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, this.extractText(value), isSelected, hasFocus, row, column);
                if (value instanceof MemberInfo) {
                    this.setIcon(((MemberInfo)value).getIcon());
                }
                return this;
            }

            protected String extractText(Object value) {
                String displayValue = value instanceof MemberInfo ? ((MemberInfo)value).getHtmlText() : String.valueOf(value);
                return displayValue;
            }
        });
        this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(this.membersTable));
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
        UIUtilities.initColumnWidth(this.membersTable, 2, Boolean.TRUE, 4);
    }

    private void selectAll(boolean select) {
        for (Object[] row : this.members) {
            row[0] = select ? Boolean.TRUE : Boolean.FALSE;
        }
        this.tableModel.fireTableDataChanged();
    }

    public String getSuperClassName() {
        return this.nameText.getText();
    }

    public MemberInfo[] getMembers() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            MemberInfo member = (MemberInfo)this.members[i][1];
            member.setMakeAbstract(this.members[i][2] != null && (Boolean)this.members[i][2] != false);
            list.add(member);
        }
        return list.toArray(new MemberInfo[0]);
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.membersListPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout(0, 10));
        this.namePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"LBL_ExtractSC_Name"));
        this.namePanel.add((Component)this.nameLabel, "West");
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ExtractSuperclassPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.namePanel.add((Component)this.nameText, "Center");
        this.nameText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ACSD_SupeclassName"));
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ACSD_SuperclassNameDescription"));
        this.add((Component)this.namePanel, "North");
        this.membersListPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"LBL_ExtractSCLabel")));
        this.membersListPanel.setLayout(new BorderLayout());
        this.scrollPane.setBorder(null);
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ACSD_MembersToExtract"));
        this.membersTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)"ACSD_MembersToExtractDescription"));
        this.membersListPanel.add((Component)this.scrollPane, "Center");
        this.add((Component)this.membersListPanel, "Center");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$302(ExtractSuperclassPanel x0, Object[][] x1) {
        x0.members = x1;
        return x1;
    }

    private class TableModel
    extends AbstractTableModel {
        TableModel() {
            this.initialize();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return UIUtilities.getColumnName(NbBundle.getMessage(ExtractSuperclassPanel.class, (String)COLUMN_NAMES[column]));
        }

        public Class getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return ExtractSuperclassPanel.this.members.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ExtractSuperclassPanel.this.members[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[rowIndex][columnIndex] = value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                if (ExtractSuperclassPanel.this.members[rowIndex][2] == null) {
                    return false;
                }
                MemberInfo element = (MemberInfo)ExtractSuperclassPanel.this.members[rowIndex][1];
                return !element.getModifiers().contains((Object)Modifier.STATIC) && !element.getModifiers().contains((Object)Modifier.ABSTRACT);
            }
            return columnIndex == 0;
        }

        private void initialize() {
            final TreePathHandle sourceType = ExtractSuperclassPanel.this.refactoring.getSourceType();
            if (sourceType == null) {
                return;
            }
            FileObject fo = sourceType.getFileObject();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController javac) throws Exception {
                        javac.toPhase(JavaSource.Phase.RESOLVED);
                        TableModel.this.initializeInTransaction(javac, sourceType);
                    }
                }, true);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void initializeInTransaction(CompilationController javac, TreePathHandle sourceType) {
            TreePath sourceTreePath = sourceType.resolve((CompilationInfo)javac);
            ClassTree sourceTree = (ClassTree)sourceTreePath.getLeaf();
            ArrayList<MemberInfo<Object>> result = new ArrayList<MemberInfo<Object>>();
            for (Tree tree : sourceTree.getImplementsClause()) {
                TreePath implPath = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror implMirror = javac.getTrees().getTypeMirror(implPath);
                result.add(MemberInfo.create(implMirror, tree, (CompilationInfo)javac));
            }
            for (Tree tree : sourceTree.getMembers()) {
                Element memberElm;
                TreePath memberTreePath = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                if (javac.getTreeUtilities().isSynthetic(memberTreePath) || (memberElm = javac.getTrees().getElement(memberTreePath)) == null) continue;
                if (memberElm.getKind() == ElementKind.FIELD) {
                    result.add(MemberInfo.create(memberElm, (CompilationInfo)javac));
                    continue;
                }
                if (memberElm.getKind() != ElementKind.METHOD) continue;
                result.add(MemberInfo.create(memberElm, (CompilationInfo)javac));
            }
            result.sort(new Comparator<MemberInfo<?>>(){

                @Override
                public int compare(MemberInfo<?> mi1, MemberInfo<?> mi2) {
                    int result = mi1.getGroup().compareTo(mi2.getGroup());
                    if (result == 0) {
                        result = mi1.getName().compareTo(mi2.getName());
                    }
                    return result;
                }
            });
            ExtractSuperclassPanel.access$302(ExtractSuperclassPanel.this, new Object[result.size()][3]);
            for (int i = 0; i < ExtractSuperclassPanel.this.members.length; ++i) {
                MemberInfo memberInfo = (MemberInfo)result.get(i);
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][0] = Boolean.FALSE;
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][1] = memberInfo;
                for (TreePathHandle treePathHandle : ExtractSuperclassPanel.this.selected) {
                    ElementHandle selectedElement = treePathHandle.getElementHandle();
                    if (selectedElement == null || !(memberInfo.getElementHandle() instanceof ElementHandle) || !selectedElement.signatureEquals((ElementHandle)memberInfo.getElementHandle())) continue;
                    ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][0] = Boolean.TRUE;
                }
                ((ExtractSuperclassPanel)ExtractSuperclassPanel.this).members[i][2] = memberInfo.getGroup() == MemberInfo.Group.METHOD ? Boolean.valueOf(memberInfo.isMakeAbstract()) : null;
            }
            this.fireTableDataChanged();
        }
    }
}

