/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.Parameters;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean hasText(String input) {
        return input != null && !input.trim().isEmpty();
    }

    public static boolean isEmpty(String input) {
        return input == null || input.isEmpty();
    }

    public static String implode(Collection<String> items, String delimiter) {
        Parameters.notNull((CharSequence)"items", items);
        Parameters.notNull((CharSequence)"delimiter", (Object)delimiter);
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(200);
        boolean first = true;
        for (String s : items) {
            if (!first) {
                buffer.append(delimiter);
            }
            buffer.append(s);
            first = false;
        }
        return buffer.toString();
    }

    public static List<String> explode(@NullAllowed String string, String delimiter) {
        Parameters.notEmpty((CharSequence)"delimiter", (CharSequence)delimiter);
        if (!StringUtils.hasText(string)) {
            return Collections.emptyList();
        }
        assert (string != null);
        return Arrays.asList(string.split(Pattern.quote(delimiter)));
    }
}

