/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.layout.Layout;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.renderkit.CoreRenderer;

public class LayoutUnitRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LayoutUnit unit = (LayoutUnit)component;
        boolean nesting = unit.isNesting();
        String defaultStyleClass = "ui-layout-unit ui-widget ui-widget-content ui-corner-all ui-layout-" + unit.getPosition();
        String styleClass = unit.getStyleClass();
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (unit.getStyle() != null) {
            writer.writeAttribute("style", (Object)unit.getStyle(), "style");
        }
        this.encodeHeader(context, unit);
        if (!nesting) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-layout-unit-content ui-widget-content", null);
        }
        this.renderChildren(context, (UIComponent)unit);
        if (!nesting) {
            writer.endElement("div");
        }
        this.encodeFooter(context, unit);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeHeader(FacesContext context, LayoutUnit unit) throws IOException {
        String headerText = unit.getHeader();
        UIComponent headerFacet = unit.getFacet("header");
        if (headerText == null && headerFacet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Layout layout = (Layout)unit.getParent();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-layout-unit-header ui-widget-header ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-layout-unit-header-title", null);
        if (headerFacet != null) {
            headerFacet.encodeAll(context);
        } else if (headerText != null) {
            writer.writeText((Object)headerText, null);
        }
        writer.endElement("span");
        if (unit.isClosable()) {
            this.encodeIcon(context, "ui-icon-close", layout.getCloseTitle());
        }
        if (unit.isCollapsible()) {
            this.encodeIcon(context, unit.getCollapseIcon(), layout.getCollapseTitle());
        }
        writer.endElement("div");
    }

    public void encodeFooter(FacesContext context, LayoutUnit unit) throws IOException {
        String footerText = unit.getFooter();
        UIComponent footerFacet = unit.getFacet("footer");
        if (footerText == null && footerFacet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-layout-unit-footer ui-widget-header ui-corner-all", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-layout-unit-footer-title", null);
        if (footerFacet != null) {
            footerFacet.encodeAll(context);
        } else if (footerText != null) {
            writer.writeText((Object)footerText, null);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, String iconClass, String title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-layout-unit-header-icon ui-state-default ui-corner-all", null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }
}

