/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ImageSourceDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ImageSourceViaObjectStorageUriDetails
extends ImageSourceDetails {
    @JsonProperty(value="sourceUri")
    private final String sourceUri;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImageSourceViaObjectStorageUriDetails(String operatingSystem, String operatingSystemVersion, ImageSourceDetails.SourceImageType sourceImageType, String sourceUri) {
        super(operatingSystem, operatingSystemVersion, sourceImageType);
        this.sourceUri = sourceUri;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageSourceViaObjectStorageUriDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sourceUri=").append(String.valueOf(this.sourceUri));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageSourceViaObjectStorageUriDetails)) {
            return false;
        }
        ImageSourceViaObjectStorageUriDetails other = (ImageSourceViaObjectStorageUriDetails)((Object)o);
        return Objects.equals(this.sourceUri, other.sourceUri) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sourceUri == null ? 43 : this.sourceUri.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="operatingSystemVersion")
        private String operatingSystemVersion;
        @JsonProperty(value="sourceImageType")
        private ImageSourceDetails.SourceImageType sourceImageType;
        @JsonProperty(value="sourceUri")
        private String sourceUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.__explicitlySet__.add("operatingSystemVersion");
            return this;
        }

        public Builder sourceImageType(ImageSourceDetails.SourceImageType sourceImageType) {
            this.sourceImageType = sourceImageType;
            this.__explicitlySet__.add("sourceImageType");
            return this;
        }

        public Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            this.__explicitlySet__.add("sourceUri");
            return this;
        }

        public ImageSourceViaObjectStorageUriDetails build() {
            ImageSourceViaObjectStorageUriDetails model = new ImageSourceViaObjectStorageUriDetails(this.operatingSystem, this.operatingSystemVersion, this.sourceImageType, this.sourceUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageSourceViaObjectStorageUriDetails model) {
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("operatingSystemVersion")) {
                this.operatingSystemVersion(model.getOperatingSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("sourceImageType")) {
                this.sourceImageType(model.getSourceImageType());
            }
            if (model.wasPropertyExplicitlySet("sourceUri")) {
                this.sourceUri(model.getSourceUri());
            }
            return this;
        }
    }
}

