/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.CopyFiles;
import org.netbeans.util.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class AutoUpgrade {
    private static final Logger LOGGER = Logger.getLogger(AutoUpgrade.class.getName());
    static final Comparator<String> APACHE_VERSION_COMPARATOR = (v1, v2) -> new SpecificationVersion(v1).compareTo(new SpecificationVersion(v2));
    static final List<String> APACHE_VERSION_TO_CHECK = Stream.of(NbBundle.getMessage(AutoUpgrade.class, (String)"apachenetbeanspreviousversion").split(",")).sorted(APACHE_VERSION_COMPARATOR.reversed()).collect(Collectors.toList());

    public static void main(String[] args) throws Exception {
        File sourceFolder = AutoUpgrade.findPreviousUserDir(APACHE_VERSION_TO_CHECK);
        if (sourceFolder != null && !AutoUpgrade.showUpgradeDialog(sourceFolder)) {
            throw new UserCancelException();
        }
    }

    private static File findPreviousUserDir(List<String> versionsToCheck) {
        String defaultUserdirRoot = System.getProperty("netbeans.default_userdir_root");
        if (defaultUserdirRoot != null) {
            File userHomeFile = new File(defaultUserdirRoot);
            for (String ver : versionsToCheck) {
                File sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
                return sourceFolder;
            }
        }
        return null;
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new AutoUpgradePanel(source.getAbsolutePath()), "Center");
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setIndeterminate(true);
        panel.add((Component)progressBar, "South");
        progressBar.setVisible(false);
        JButton bYES = new JButton("Yes");
        bYES.setMnemonic(89);
        JButton bNO = new JButton("No");
        bNO.setMnemonic(78);
        Object[] options = new JButton[]{bYES, bNO};
        JOptionPane p = new JOptionPane(panel, 3, 0, null, options, bYES);
        JDialog d = Util.createJOptionProgressDialog(p, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"), source, progressBar);
        d.setVisible(true);
        return Integer.valueOf(0).equals(p.getValue());
    }

    private static void copyToUserdir(File source) throws IOException, PropertyVetoException {
        File userdir = new File(System.getProperty("netbeans.user", ""));
        File netBeansDir = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File importFile = new File(netBeansDir, "etc/netbeans.import");
        LOGGER.fine("Import file: " + importFile);
        LOGGER.info("Importing from " + source + " to " + userdir);
        CopyFiles.copyDeep(source, userdir, importFile);
    }

    public static void doCopyToUserDir(File source) throws IOException, PropertyVetoException {
        AutoUpgrade.copyToUserdir(source);
    }
}

