/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api;

public final class Location {
    private final long pc;
    private final int line;
    private final int column;

    private Location(long pc, int line, int column) {
        this.pc = pc;
        this.line = line;
        this.column = column;
    }

    public long getPC() {
        return this.pc;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "Location{pc=" + this.pc + ", line=" + this.line + ", column=" + this.column + '}';
    }

    public static final class Builder {
        private long pc;
        private int line;
        private int column;

        Builder() {
        }

        public void pc(long pc) {
            this.pc = pc;
        }

        public void line(int line) {
            if (line < 0) {
                throw new IllegalArgumentException("Line must not be negative");
            }
            this.line = line;
        }

        public void column(int column) {
            if (column < 0) {
                throw new IllegalArgumentException("Column must not be negative");
            }
            this.column = column;
        }

        public Location build() {
            if (this.column > 0 && this.line == 0) {
                throw new IllegalStateException("Column can not be defined without a line.");
            }
            if (this.line == 0 && this.pc == 0L) {
                throw new IllegalStateException("No location information is defined.");
            }
            return new Location(this.pc, this.line, this.column);
        }
    }
}

