/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.PositionConverter;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.NoJavacHelper;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.ClasspathInfoTask;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.JavacParserFactory;
import org.netbeans.modules.java.source.parsing.MimeTask;
import org.netbeans.modules.java.source.parsing.NewComilerTask;
import org.netbeans.modules.java.source.parsing.ParameterNameProviderImpl;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class JavaSource {
    private final Collection<Source> sources;
    private final Collection<FileObject> files;
    private final ClasspathInfo classpathInfo;
    private ClasspathInfo cachedCpInfo;
    private static final Logger LOGGER;
    private static Map<FileObject, Reference<JavaSource>> file2JavaSource;
    private static final String[] supportedMIMETypes;

    @NullUnknown
    public static JavaSource create(@NonNull ClasspathInfo cpInfo, FileObject ... files) throws IllegalArgumentException {
        if (files == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        return JavaSource._create(cpInfo, Arrays.asList(files));
    }

    @NullUnknown
    public static JavaSource create(@NonNull ClasspathInfo cpInfo, @NonNull Collection<? extends FileObject> files) throws IllegalArgumentException {
        return JavaSource._create(cpInfo, files);
    }

    @NullUnknown
    private static JavaSource _create(ClasspathInfo cpInfo, @NonNull Collection<? extends FileObject> files) throws IllegalArgumentException {
        if (files == null) {
            throw new IllegalArgumentException();
        }
        if (!NoJavacHelper.hasWorkingJavac()) {
            return null;
        }
        try {
            return new JavaSource(cpInfo, files);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @CheckForNull
    public static JavaSource forFileObject(@NonNull FileObject fileObject) throws IllegalArgumentException {
        JavaSource js;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid()) {
            LOGGER.log(Level.FINE, "FileObject ({0}) passed to JavaSource.forFileObject is invalid", fileObject.toURI().toString());
            return null;
        }
        String mimeType = null;
        try {
            if (fileObject.getFileSystem().isDefault() && fileObject.getAttribute("javax.script.ScriptEngine") != null && fileObject.getAttribute("template") == Boolean.TRUE) {
                LOGGER.log(Level.FINE, "FileObject ({0}) passed to JavaSource.forFileObject is a template", fileObject.toURI().toString());
                return null;
            }
        }
        catch (FileStateInvalidException ex) {
            LOGGER.log(Level.FINE, null, ex);
            return null;
        }
        Reference<JavaSource> ref = file2JavaSource.get(fileObject);
        JavaSource javaSource = js = ref != null ? ref.get() : null;
        if (js == null) {
            String string = mimeType = mimeType == null ? FileUtil.getMIMEType((FileObject)fileObject, (String[])supportedMIMETypes) : mimeType;
            if ("application/x-class-file".equals(mimeType) || "class".equals(fileObject.getExt())) {
                ClassPath execPath;
                ClassPath moduleSrcPath;
                ClassPath srcPath;
                ClassPath moduleClassPath;
                ClassPath moduleCompilePath;
                ClassPath compilePath;
                ClassPath bootPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
                if (bootPath == null) {
                    bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
                }
                boolean hasModulePath = true;
                ClassPath moduleBootPath = ClassPath.getClassPath((FileObject)fileObject, (String)"modules/boot");
                if (moduleBootPath == null) {
                    moduleBootPath = bootPath;
                    hasModulePath = false;
                }
                if ((compilePath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")) == null) {
                    compilePath = ClassPath.EMPTY;
                }
                if ((moduleCompilePath = ClassPath.getClassPath((FileObject)fileObject, (String)"modules/compile")) == null) {
                    moduleCompilePath = ClassPath.EMPTY;
                }
                if ((moduleClassPath = ClassPath.getClassPath((FileObject)fileObject, (String)"modules/classpath")) == null) {
                    moduleClassPath = ClassPath.EMPTY;
                }
                if ((srcPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
                    srcPath = ClassPath.EMPTY;
                }
                if ((moduleSrcPath = ClassPath.getClassPath((FileObject)fileObject, (String)"modules/source")) == null) {
                    moduleSrcPath = ClassPath.EMPTY;
                }
                if ((execPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute")) != null) {
                    if (hasModulePath) {
                        moduleClassPath = moduleClassPath == ClassPath.EMPTY ? execPath : ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{moduleClassPath, execPath});
                        compilePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{compilePath, execPath});
                    } else {
                        bootPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{execPath, bootPath});
                    }
                }
                ClasspathInfo info = ClasspathInfoAccessor.getINSTANCE().create(bootPath, moduleBootPath, compilePath, moduleCompilePath, moduleClassPath, srcPath, moduleSrcPath, null, false, false, false, true, false, null);
                FileObject root = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createClassPath((URL[])CachingArchiveProvider.getDefault().ctSymRootsFor(bootPath)), bootPath, compilePath, srcPath}).findOwnerRoot(fileObject);
                if (root == null) {
                    LOGGER.log(Level.FINE, "FileObject ({0}) passed to JavaSource.forFileObject of mimeType classfile does not have a corresponding root", fileObject.toURI().toString());
                    return null;
                }
                try {
                    Source classSource = Source.create((FileObject)fileObject);
                    if (classSource != null) {
                        js = new JavaSource(info, fileObject, classSource, root);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            } else {
                if (!"text/x-java".equals(mimeType) && !"java".equals(fileObject.getExt())) {
                    LOGGER.log(Level.FINE, "FileObject ({0}) passed to JavaSource.forFileObject is not a Java source file (mimetype: {1})", new Object[]{fileObject.toURI().toString(), mimeType});
                    return null;
                }
                js = JavaSource._create(null, Collections.singletonList(fileObject));
            }
            file2JavaSource.put(fileObject, new WeakReference<JavaSource>(js));
        }
        return js;
    }

    @CheckForNull
    public static JavaSource forDocument(@NonNull Document doc) throws IllegalArgumentException {
        FileObject fo;
        JavaSource js;
        if (doc == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference ref = (Reference)doc.getProperty(JavaSource.class);
        JavaSource javaSource = js = ref != null ? (JavaSource)ref.get() : null;
        if (js == null && (fo = Utilities.getFileObject((Document)doc)) != null) {
            js = JavaSource.forFileObject(fo);
        }
        return js;
    }

    private JavaSource(ClasspathInfo cpInfo, @NonNull Collection<? extends FileObject> files) throws IOException {
        ArrayList<Source> sources = new ArrayList<Source>(files.size());
        ArrayList<FileObject> fl = new ArrayList<FileObject>(files.size());
        for (FileObject fileObject : files) {
            Logger.getLogger("TIMER").log(Level.FINE, "JavaSource", new Object[]{fileObject, this});
            if (!fileObject.isValid()) {
                LOGGER.warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                continue;
            }
            fl.add(fileObject);
            sources.add(Source.create((FileObject)fileObject));
        }
        this.files = Collections.unmodifiableList(fl);
        this.sources = Collections.unmodifiableList(sources);
        this.classpathInfo = cpInfo;
    }

    private JavaSource(@NonNull ClasspathInfo info, @NonNull FileObject classFileObject, @NonNull Source classSource, @NonNull FileObject root) throws IOException {
        assert (info != null);
        assert (classFileObject != null);
        assert (classSource != null);
        assert (root != null);
        this.files = Collections.singletonList(classFileObject);
        this.sources = Collections.singletonList(classSource);
        this.classpathInfo = info;
    }

    public void runUserActionTask(@NonNull Task<CompilationController> task, boolean shared) throws IOException {
        this.runUserActionTaskImpl(task, shared);
    }

    private long runUserActionTaskImpl(Task<CompilationController> task, boolean shared) throws IOException {
        Parameters.notNull((CharSequence)"task", task);
        long currentId = -1L;
        if (this.sources.isEmpty()) {
            try {
                ParserManager.parse((String)"text/x-java", (UserTask)new MimeTask(this, task, this.classpathInfo));
            }
            catch (ParseException pe) {
                Throwable rootCase = pe.getCause();
                if (rootCase instanceof Symbol.CompletionFailure) {
                    IOException ioe = new IOException();
                    ioe.initCause(rootCase);
                    throw ioe;
                }
                if (rootCase instanceof RuntimeException) {
                    throw (RuntimeException)rootCase;
                }
                IOException ioe = new IOException();
                ioe.initCause(rootCase);
                throw ioe;
            }
        }
        try {
            MultiTask _task = new MultiTask(this, task, this.classpathInfo);
            ParserManager.parse(this.sources, (UserTask)_task);
        }
        catch (ParseException pe) {
            Throwable rootCase = pe.getCause();
            if (rootCase instanceof Symbol.CompletionFailure) {
                IOException ioe = new IOException();
                ioe.initCause(rootCase);
                throw ioe;
            }
            if (rootCase instanceof RuntimeException) {
                throw (RuntimeException)rootCase;
            }
            IOException ioe = new IOException();
            ioe.initCause(rootCase);
            throw ioe;
        }
        return currentId;
    }

    static long createTaggedController(FileObject fo, int position, long timestamp, Object[] controller) throws IOException {
        ClasspathInfo cpi = ClasspathInfo.create(fo);
        Set<Source> sources = Collections.singleton(Source.create((FileObject)fo));
        CompilationController cc = (CompilationController)controller[0];
        NewComilerTask _task = new NewComilerTask(cpi, position, cc, timestamp);
        try {
            ParserManager.parse(sources, (UserTask)_task);
            controller[0] = _task.getCompilationController();
            return _task.getTimeStamp();
        }
        catch (ParseException pe) {
            Throwable rootCase = pe.getCause();
            if (rootCase instanceof Symbol.CompletionFailure) {
                throw new IOException(rootCase);
            }
            if (rootCase instanceof RuntimeException) {
                throw (RuntimeException)rootCase;
            }
            throw new IOException(rootCase);
        }
    }

    long createTaggedController(long timestamp, Object[] controller) throws IOException {
        assert (controller.length == 1);
        assert (controller[0] == null || controller[0] instanceof CompilationController);
        try {
            CompilationController cc = (CompilationController)controller[0];
            NewComilerTask _task = new NewComilerTask(this.classpathInfo, -1, cc, timestamp);
            ParserManager.parse(this.sources, (UserTask)_task);
            controller[0] = _task.getCompilationController();
            return _task.getTimeStamp();
        }
        catch (ParseException pe) {
            Throwable rootCase = pe.getCause();
            if (rootCase instanceof Symbol.CompletionFailure) {
                throw new IOException(rootCase);
            }
            if (rootCase instanceof RuntimeException) {
                throw (RuntimeException)rootCase;
            }
            throw new IOException(rootCase);
        }
    }

    @NonNull
    public Future<Void> runWhenScanFinished(@NonNull Task<CompilationController> task, boolean shared) throws IOException {
        Parameters.notNull((CharSequence)"task", task);
        if (this.sources.isEmpty()) {
            try {
                return ParserManager.parseWhenScanFinished((String)"text/x-java", (UserTask)new MimeTask(this, task, this.classpathInfo));
            }
            catch (ParseException pe) {
                Throwable rootCase = pe.getCause();
                if (rootCase instanceof Symbol.CompletionFailure) {
                    IOException ioe = new IOException();
                    ioe.initCause(rootCase);
                    throw ioe;
                }
                if (rootCase instanceof RuntimeException) {
                    throw (RuntimeException)rootCase;
                }
                IOException ioe = new IOException();
                ioe.initCause(rootCase);
                throw ioe;
            }
        }
        try {
            MultiTask _task = new MultiTask(this, task, this.classpathInfo);
            return ParserManager.parseWhenScanFinished(this.sources, (UserTask)_task);
        }
        catch (ParseException pe) {
            Throwable rootCase = pe.getCause();
            if (rootCase instanceof Symbol.CompletionFailure) {
                IOException ioe = new IOException();
                ioe.initCause(rootCase);
                throw ioe;
            }
            if (rootCase instanceof RuntimeException) {
                throw (RuntimeException)rootCase;
            }
            IOException ioe = new IOException();
            ioe.initCause(rootCase);
            throw ioe;
        }
    }

    @NonNull
    public ModificationResult runModificationTask(final @NonNull Task<WorkingCopy> task) throws IOException {
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        final ModificationResult result = new ModificationResult();
        final ElementOverlay overlay = ElementOverlay.getOrCreateOverlay();
        long start = System.currentTimeMillis();
        Task<CompilationController> inner = new Task<CompilationController>(){

            @Override
            public void run(CompilationController cc) throws Exception {
                WorkingCopy copy = new WorkingCopy(cc.impl, overlay);
                copy.setJavaSource(JavaSource.this);
                if (JavaSource.this.sources.isEmpty()) {
                    copy.toPhase(Phase.PARSED);
                }
                task.run(copy);
                List<ModificationResult.Difference> diffs = copy.getChanges(result.tag2Span);
                if (diffs != null && diffs.size() > 0) {
                    FileObject file = copy.getFileObject();
                    result.diffs.put(file != null ? file : FileUtil.createMemoryFileSystem().getRoot().createData("temp", "java"), diffs);
                }
            }
        };
        this.runUserActionTask(inner, true);
        if (this.sources.size() == 1) {
            Logger.getLogger("TIMER").log(Level.FINE, "Modification Task", new Object[]{this.sources.iterator().next().getFileObject(), System.currentTimeMillis() - start});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClasspathInfo getClasspathInfo() {
        JavaSource javaSource = this;
        synchronized (javaSource) {
            if (this.cachedCpInfo != null) {
                return this.cachedCpInfo;
            }
        }
        ClasspathInfo _tmp = this.classpathInfo;
        if (_tmp == null) {
            assert (!this.files.isEmpty());
            _tmp = ClasspathInfo.create(this.files.iterator().next());
        }
        JavaSource javaSource2 = this;
        synchronized (javaSource2) {
            if (this.cachedCpInfo == null) {
                this.cachedCpInfo = _tmp;
            }
            return this.cachedCpInfo;
        }
    }

    @NonNull
    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    static {
        JavaSourceAccessor.setINSTANCE(new JavaSourceAccessorImpl());
        LOGGER = Logger.getLogger(JavaSource.class.getName());
        file2JavaSource = new WeakHashMap<FileObject, Reference<JavaSource>>();
        supportedMIMETypes = new String[]{"application/x-class-file", "text/x-java"};
    }

    private static class MultiTask
    extends ClasspathInfoTask {
        private final JavaSource js;
        private final Task<CompilationController> task;

        public MultiTask(JavaSource js, Task<CompilationController> task, ClasspathInfo cpInfo) {
            super(cpInfo);
            assert (js != null);
            assert (task != null);
            this.js = js;
            this.task = task;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            Snapshot snapshot = resultIterator.getSnapshot();
            if ("text/x-java".equals(snapshot.getMimeType()) || "application/x-class-file".equals(snapshot.getMimeType())) {
                Parser.Result result = resultIterator.getParserResult();
                if (result == null) {
                    return;
                }
                CompilationController cc = CompilationController.get(result);
                assert (cc != null);
                cc.setJavaSource(this.js);
                this.task.run(cc);
            } else {
                Parser.Result result = this.findEmbeddedJava(resultIterator);
                if (result == null) {
                    return;
                }
                CompilationController cc = CompilationController.get(result);
                assert (cc != null);
                cc.setJavaSource(this.js);
                this.task.run(cc);
            }
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.task.getClass().getName() + "]";
        }

        private Parser.Result findEmbeddedJava(ResultIterator theMess) throws ParseException {
            ArrayList<Embedding> todo = new ArrayList<Embedding>();
            for (Embedding embedding : theMess.getEmbeddings()) {
                if ("text/x-java".equals(embedding.getMimeType())) {
                    return theMess.getResultIterator(embedding).getParserResult();
                }
                todo.add(embedding);
            }
            for (Embedding embedding : todo) {
                Parser.Result result = this.findEmbeddedJava(theMess.getResultIterator(embedding));
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    private static class JavaSourceAccessorImpl
    extends JavaSourceAccessor {
        private JavaSourceAccessorImpl() {
        }

        @Override
        public JavacTaskImpl getJavacTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.impl.getJavacTask();
        }

        @Override
        public JavaSource create(ClasspathInfo cpInfo, PositionConverter binding, Collection<? extends FileObject> files) throws IllegalArgumentException {
            return JavaSource.create(cpInfo, files);
        }

        @Override
        public CompilationController createCompilationController(Source s, ClasspathInfo cpInfo) throws IOException, ParseException {
            Snapshot snapshot;
            JavacParserFactory factory = JavacParserFactory.getDefault();
            JavacParser parser = factory.createPrivateParser(snapshot = s != null ? s.createSnapshot() : null);
            if (parser == null) {
                return null;
            }
            ClasspathInfoTask dummy = new ClasspathInfoTask(cpInfo){

                public void run(ResultIterator resultIterator) throws Exception {
                }
            };
            parser.parse(snapshot, (org.netbeans.modules.parsing.api.Task)dummy, null);
            return CompilationController.get(parser.getResult((org.netbeans.modules.parsing.api.Task)dummy));
        }

        @Override
        public long createTaggedCompilationController(FileObject f, int position, long currentTag, Object[] out) throws IOException {
            return JavaSource.createTaggedController(f, position, currentTag, out);
        }

        @Override
        public long createTaggedCompilationController(JavaSource js, long currentTag, Object[] out) throws IOException {
            return js.createTaggedController(currentTag, out);
        }

        @Override
        public CompilationInfo createCompilationInfo(CompilationInfoImpl impl) {
            return new CompilationInfo(impl);
        }

        @Override
        public CompilationController createCompilationController(CompilationInfoImpl impl) {
            return new CompilationController(impl);
        }

        @Override
        public void invalidate(CompilationInfo info) {
            assert (info != null);
            info.invalidate();
        }

        @Override
        public Collection<Source> getSources(JavaSource js) {
            assert (js != null);
            return js.sources;
        }

        @Override
        public void setJavaSource(CompilationInfo info, JavaSource js) {
            assert (info != null);
            assert (js != null);
            info.setJavaSource(js);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateCachedClasspathInfo(FileObject file) {
            JavaSource js;
            assert (file != null);
            Reference ref = (Reference)file2JavaSource.get(file);
            if (ref != null && (js = (JavaSource)ref.get()) != null) {
                JavaSource javaSource = js;
                synchronized (javaSource) {
                    js.cachedCpInfo = null;
                }
            }
        }

        @Override
        public CompilationInfoImpl getCompilationInfoImpl(CompilationInfo info) {
            assert (info != null);
            return info.impl;
        }

        @Override
        @NonNull
        public String generateReadableParameterName(@NonNull String typeName, @NonNull Set<String> used) {
            return ParameterNameProviderImpl.generateReadableParameterName(typeName, used);
        }

        @Override
        public ModificationResult.Difference createDifference(ModificationResult.Difference.Kind kind, Position startPos, Position endPos, String oldText, String newText, String description, Source src) {
            return new ModificationResult.Difference(kind, startPos, endPos, oldText, newText, description, src);
        }

        @Override
        public ModificationResult.Difference createNewFileDifference(JavaFileObject fileObject, String text) {
            return new ModificationResult.CreateChange(fileObject, text);
        }

        @Override
        public ModificationResult createModificationResult(Map<FileObject, List<ModificationResult.Difference>> diffs, Map<?, int[]> tag2Span) {
            ModificationResult result = new ModificationResult();
            result.diffs = diffs;
            result.tag2Span = tag2Span;
            return result;
        }

        @Override
        public ElementUtilities createElementUtilities(@NonNull JavacTaskImpl jt) {
            return new ElementUtilities(jt);
        }

        @Override
        public Map<FileObject, List<ModificationResult.Difference>> getDiffsFromModificationResult(ModificationResult mr) {
            return mr.diffs;
        }

        @Override
        public Map<?, int[]> getTagsFromModificationResult(ModificationResult mr) {
            return mr.tag2Span;
        }

        @Override
        public ClassIndex createClassIndex(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath, boolean supportsChanges) {
            return new ClassIndex(bootPath, classPath, sourcePath, supportsChanges);
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String message, FileObject fo) {
            super(message);
            this.fo = fo;
        }

        private InsufficientMemoryException(FileObject fo) {
            this(NbBundle.getMessage(JavaSource.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fo)), fo);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }

    public static enum Phase {
        MODIFIED,
        PARSED,
        ELEMENTS_RESOLVED,
        RESOLVED,
        UP_TO_DATE;

    }
}

