/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;

public class NbiLabel
extends JLabel {
    private boolean collapsePaths;
    private String text;
    public static final String DEFAULT_TEXT = " ";
    public static final String DEFAULT_TOOLTIP_TEXT = null;
    public static final char DEFAULT_MNEMONIC = '\u0000';

    public NbiLabel() {
        this.setText(null);
        this.collapsePaths = false;
    }

    public NbiLabel(boolean collapsePaths) {
        this();
        this.collapsePaths = collapsePaths;
        if (collapsePaths) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String shortenedString = NbiLabel.this.shortenString(NbiLabel.this.text);
                    NbiLabel.super.setText(shortenedString);
                    NbiLabel.super.setToolTipText(StringUtils.stripMnemonic(shortenedString));
                }
            });
        }
    }

    public void clearText() {
        this.setText(null);
    }

    @Override
    public void setText(String text) {
        if (text == null || text.equals("")) {
            this.text = DEFAULT_TEXT;
            super.setText(DEFAULT_TEXT);
            super.setDisplayedMnemonic('\u0000');
            super.setToolTipText(DEFAULT_TOOLTIP_TEXT);
        } else {
            this.text = text;
            if (this.collapsePaths) {
                String shortenedString = this.shortenString(text);
                super.setText(shortenedString);
                super.setToolTipText(StringUtils.stripMnemonic(shortenedString));
            } else {
                super.setText(StringUtils.stripMnemonic(text));
                super.setToolTipText(StringUtils.stripMnemonic(text));
            }
            if (!SystemUtils.isMacOS()) {
                super.setDisplayedMnemonic(StringUtils.fetchMnemonic(text));
            }
        }
    }

    private String shortenString(String text) {
        String string = StringUtils.stripMnemonic(text);
        String separator = SystemUtils.getFileSeparator();
        int boundsWidth = this.getBounds().width;
        int lastIndex = string.lastIndexOf(separator);
        int stringWidth = this.getStringBounds((Graphics)this.getGraphics(), (String)text).width;
        int index = string.lastIndexOf(separator, lastIndex - 1);
        String shortenedString = string;
        while (lastIndex != -1 && index != -1 && stringWidth > boundsWidth) {
            shortenedString = StringUtils.replace(string, "...", index + 1, lastIndex);
            stringWidth = this.getStringBounds((Graphics)this.getGraphics(), (String)shortenedString).width;
            index = string.lastIndexOf(separator, index - 1);
        }
        return shortenedString;
    }

    private Rectangle getStringBounds(Graphics graphics, String text) {
        return this.getFontMetrics(this.getFont()).getStringBounds(text, graphics).getBounds();
    }
}

