/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.steps;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.cloud.oracle.assets.AbstractStep;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.steps.Bundle;
import org.openide.NotifyDescriptor;

public final class DatabaseConnectionStep
extends AbstractStep<DatabaseItem> {
    private final Map<String, DatabaseItem> adbConnections = new HashMap<String, DatabaseItem>();
    private DatabaseItem selected = null;

    public DatabaseConnectionStep() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            String name = connections[i].getDisplayName();
            String ocid = connections[i].getConnectionProperties().getProperty("OCID");
            String compartmentId = connections[i].getConnectionProperties().getProperty("CompartmentOCID");
            String description = connections[i].getConnectionProperties().getProperty("Description");
            if (ocid == null || compartmentId == null) continue;
            DatabaseItem dbItem = new DatabaseItem(OCID.of(ocid, "Databases"), compartmentId, name, null, name);
            dbItem.setDescription(description);
            this.adbConnections.put(name, dbItem);
        }
    }

    @Override
    public NotifyDescriptor createInput() {
        return Steps.createQuickPick(this.adbConnections, Bundle.SelectDBConnection());
    }

    @Override
    public void setValue(String selected) {
        this.selected = this.adbConnections.get(selected);
    }

    @Override
    public DatabaseItem getValue() {
        return this.selected;
    }

    @Override
    public boolean onlyOneChoice() {
        return this.adbConnections.isEmpty();
    }
}

