/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.policy;

import java.util.Collection;
import org.netbeans.modules.cloud.oracle.assets.SuggestedItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public class PolicyGenerator {
    public static String createPolicies(Collection<OCIItem> items) {
        OCIItem execution = null;
        for (OCIItem item : items) {
            if (!"Cluster".equals(item.getKey().getPath()) && !"ComputeInstance".equals(item.getKey().getPath())) continue;
            if (execution != null) {
                throw new IllegalStateException("More than one execution environment found");
            }
            execution = item;
        }
        if (execution == null) {
            return "# Resolve execution environment suggestion";
        }
        String principalType = "ComputeInstance".equals(execution.getKey().getPath()) ? "instance" : "cluster";
        StringBuilder result = new StringBuilder();
        for (OCIItem item : items) {
            switch (item.getKey().getPath()) {
                case "Databases": {
                    result.append("Allow any-user to manage autonomous-database-family \nin compartment id " + item.getCompartmentId() + "\nwhere ALL { \n    target.autonomous-database.id = '" + item.getKey().getValue() + "',\n    request.principal.type = '" + principalType + "',\n    request.principal.compartment.id = '" + execution.getCompartmentId() + "'\n}\n\n");
                    break;
                }
                case "Bucket": {
                    result.append("Allow any-user to manage object-family \nin compartment id " + item.getCompartmentId() + "\nwhere ALL {\n    request.principal.type = '" + principalType + "',\n    request.principal.compartment.id = '" + execution.getCompartmentId() + "'\n}\n\n");
                    break;
                }
                case "Vault": {
                    result.append("Allow any-user to read secret-family \nin compartment id " + item.getCompartmentId() + "\nwhere ALL {\n    request.principal.type = '" + principalType + "',\n    request.principal.compartment.id = '" + execution.getCompartmentId() + "'\n}");
                    break;
                }
                case "Suggested": {
                    result.append("# Resolve suggestion:" + ((SuggestedItem)item).getPath() + "'\n");
                }
            }
        }
        return result.toString();
    }
}

