/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;

public final class ContainerTagItem
extends OCIItem {
    private String digest;
    private String version;
    private String regionCode;
    private String namespace;
    private String repositoryName;

    public ContainerTagItem(OCID id, String compartmentId, String repositoryName, String regionCode, String namespace, String version, String digest) {
        super(id, compartmentId, version != null ? version : digest);
        this.regionCode = regionCode;
        this.version = version;
        this.digest = digest;
        this.repositoryName = repositoryName;
        this.namespace = namespace;
    }

    public ContainerTagItem() {
    }

    public String getUrl() {
        if (this.version != null) {
            return String.format("%s.ocir.io/%s/%s:%s", this.regionCode, this.namespace, this.repositoryName, this.version);
        }
        return String.format("%s.ocir.io/%s/%s@%s", this.regionCode, this.namespace, this.repositoryName, this.digest);
    }

    public String getDigest() {
        return this.digest;
    }

    public String getVersion() {
        if (this.version == null) {
            return "";
        }
        return this.version;
    }
}

