/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.compute;

import com.oracle.bmc.containerengine.ContainerEngineClient;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.core.model.Instance;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.compute.Bundle;
import org.netbeans.modules.cloud.oracle.compute.ClusterItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class ClusterNode
extends OCINode {
    private static final String CLUSTER_ICON = "org/netbeans/modules/cloud/oracle/resources/cluster.svg";

    public ClusterNode(ClusterItem cluster) {
        super((OCIItem)cluster, Children.LEAF);
        this.setName(cluster.getName());
        this.setDisplayName(cluster.getName());
        this.setIconBaseWithExtension(CLUSTER_ICON);
        this.setShortDescription(Bundle.ClusterDesc(cluster.getName()));
    }

    public static NodeProvider<ClusterItem> createNode() {
        return ClusterNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, ClusterItem> getClusters() {
        return (compartmentId, session) -> {
            ContainerEngineClient client = session.newClient(ContainerEngineClient.class);
            ListClustersRequest listClustersRequest = ListClustersRequest.builder().compartmentId(compartmentId.getKey().getValue()).limit(Integer.valueOf(88)).build();
            return client.listClusters(listClustersRequest).getItems().stream().filter(c -> !c.getLifecycleState().equals((Object)Instance.LifecycleState.Terminated)).map(d -> new ClusterItem(OCID.of(d.getId(), "Cluster"), compartmentId.getKey().getValue(), d.getName())).collect(Collectors.toList());
        };
    }
}

