/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public class KnowledgeBaseItem
extends OCIItem
implements URLProvider {
    private static Map<OCID, Collection<Reference<KnowledgeBaseItem>>> itemInstances = new HashMap<OCID, Collection<Reference<KnowledgeBaseItem>>>();
    protected final Date timeUpdated;

    public KnowledgeBaseItem(OCID id, String compartmentId, String displayName, Date timeUpdated) {
        super(id, compartmentId, displayName);
        this.timeUpdated = timeUpdated;
        this.registerItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerItem() {
        Class<KnowledgeBaseItem> clazz = KnowledgeBaseItem.class;
        synchronized (KnowledgeBaseItem.class) {
            itemInstances.computeIfAbsent(this.getKey(), x -> new ArrayList()).add(new WeakReference<KnowledgeBaseItem>(this));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public URL getURL() {
        try {
            return new URL("https://cloud.oracle.com/adm/knowledgeBases/" + this.getKey().getValue());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public int maxInProject() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<KnowledgeBaseItem> findKnownInstances(OCID ocid) {
        ArrayList<KnowledgeBaseItem> items = new ArrayList<KnowledgeBaseItem>();
        Class<KnowledgeBaseItem> clazz = KnowledgeBaseItem.class;
        synchronized (KnowledgeBaseItem.class) {
            Collection<Reference<KnowledgeBaseItem>> refItems = itemInstances.get(ocid);
            if (refItems == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Collections.emptyList();
            }
            Iterator<Reference<KnowledgeBaseItem>> it = refItems.iterator();
            while (it.hasNext()) {
                Reference<KnowledgeBaseItem> r = it.next();
                KnowledgeBaseItem i = r.get();
                if (i == null) {
                    it.remove();
                    continue;
                }
                items.add(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return items;
        }
    }
}

