/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.jshell.model.Rng;

public final class ConsoleSection {
    private final int start;
    private int len;
    private final Type type;
    private boolean incomplete;
    private int contentStart = -1;
    private Rng[] partOffsets;
    private Rng[] snippetOffsets;

    public ConsoleSection(int start, Type type, int len) {
        this.start = start;
        this.type = type;
        this.len = len;
    }

    public ConsoleSection(int start, Type type) {
        this.start = start;
        this.type = type;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.len;
    }

    public int getLen() {
        return this.len;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasMoreParts() {
        return this.partOffsets != null;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public int getPartBegin() {
        return this.contentStart;
    }

    public int getPartLen() {
        return this.contentStart == -1 ? this.len : this.len - (this.contentStart - this.start);
    }

    public Rng[] getPartRanges() {
        if (this.hasMoreParts()) {
            return this.partOffsets;
        }
        if (this.contentStart == -1) {
            return new Rng[0];
        }
        return new Rng[]{new Rng(this.getPartBegin(), this.start + this.len)};
    }

    public Rng getSnippetBounds(int index) {
        if (this.snippetOffsets == null) {
            if (index > 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return new Rng(this.getPartBegin(), this.start + this.len);
        }
        return this.snippetOffsets[index];
    }

    public Rng[] getAllSnippetBounds() {
        if (this.snippetOffsets == null) {
            return new Rng[]{new Rng(this.getPartBegin(), this.start + this.len)};
        }
        return this.snippetOffsets;
    }

    void extendTo(int endOffset) {
        this.len = endOffset - this.start;
    }

    void extendToWithRanges(List<Rng> ranges) {
        Rng last = ranges.get(ranges.size() - 1);
        this.len = last.end - this.start;
        Rng first = ranges.get(0);
        this.contentStart = first.start;
        if (ranges.size() > 1) {
            this.partOffsets = (Rng[])ranges.toArray(Rng[]::new);
        }
    }

    void setSnippetRanges(List<Rng> ranges) {
        if (ranges.size() > 1) {
            this.snippetOffsets = (Rng[])ranges.toArray(Rng[]::new);
        }
    }

    void extendWithPart(int s, int e) {
        if (this.contentStart == -1) {
            this.contentStart = s;
            this.len = e - this.start;
            return;
        }
        if (this.partOffsets == null) {
            int x = this.contentStart + this.getPartLen();
            if (x >= s) {
                if (e < x) {
                    return;
                }
                this.len = e - this.start;
                return;
            }
            this.partOffsets = new Rng[2];
            this.partOffsets[0] = new Rng(this.contentStart, this.getEnd());
        } else {
            this.partOffsets = Arrays.copyOf(this.partOffsets, this.partOffsets.length + 1);
        }
        Rng r = new Rng(s, e);
        assert (this.start + this.len <= e);
        this.partOffsets[this.partOffsets.length - 1] = r;
    }

    void setComplete(boolean complete) {
        this.incomplete = !complete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.toString() + "[").append(this.start).append("-").append(this.start + this.len).append("");
        if (this.partOffsets != null) {
            sb.append("; snippets = ").append(Arrays.asList(this.partOffsets).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getRangeContents(Document d, Rng snippetRange) {
        try {
            Rng[] ranges;
            StringBuilder sb = new StringBuilder();
            for (Rng r : ranges = this.computeFragments(snippetRange)) {
                sb.append(d.getText(r.start, r.len()));
            }
            return sb.toString();
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    public String getRangeContents(CharSequence s, Rng snippetRange) {
        Rng[] ranges;
        StringBuilder sb = new StringBuilder();
        for (Rng r : ranges = this.computeFragments(snippetRange)) {
            sb.append(s.subSequence(r.start, r.start + r.len()));
        }
        return sb.toString();
    }

    public String getContents(Document d) {
        return this.getContents(d, 0);
    }

    private String getContents(Document d, int startFrom) {
        try {
            int l = d.getLength() + 1;
            if (startFrom > l) {
                startFrom = l;
            }
            if (this.hasMoreParts()) {
                StringBuilder sb = new StringBuilder();
                for (Rng r : this.partOffsets) {
                    if (startFrom >= r.end) continue;
                    if (startFrom > r.start) {
                        sb.append(d.getText(startFrom, Math.min(l, r.end) - startFrom));
                        continue;
                    }
                    startFrom = Math.min(l, r.start);
                    sb.append(d.getText(r.start, Math.min(l, r.end) - startFrom));
                }
                return sb.toString();
            }
            if (startFrom >= this.getEnd()) {
                return "";
            }
            if (startFrom > this.contentStart) {
                int e = Math.min(l, this.contentStart + this.getPartLen());
                return d.getText(startFrom, e - startFrom);
            }
            startFrom = Math.min(l, this.contentStart);
            return d.getText(startFrom, Math.min(l - startFrom, this.getPartLen()));
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public Rng[] computeFragments(Rng jr) {
        ArrayList<Rng> res;
        block8: {
            Rng[] parts = this.getPartRanges();
            int partIndex = 0;
            res = new ArrayList<Rng>();
            Rng pr = parts[partIndex];
            assert (pr.start <= jr.start);
            if (jr.end <= pr.end) {
                res.add(jr);
            } else {
                int l = pr.end - jr.start;
                res.add(new Rng(jr.start, pr.end));
                ++partIndex;
                while (jr.end > pr.end) {
                    if (partIndex < parts.length) {
                        res.add(parts[partIndex++]);
                        continue;
                    }
                    break block8;
                }
                assert (partIndex < parts.length);
                pr = parts[partIndex];
                if (jr.end == pr.end) {
                    res.add(pr);
                } else {
                    res.add(new Rng(pr.start, jr.end));
                }
            }
        }
        return (Rng[])res.toArray(Rng[]::new);
    }

    public int offsetToContents(int offset, boolean acceptOutside) {
        int idx = 0;
        for (Rng r : this.getPartRanges()) {
            if (offset < r.start) {
                return acceptOutside ? idx : -1;
            }
            if (offset < r.end) {
                return idx + offset - r.start;
            }
            idx += r.len();
        }
        return acceptOutside ? idx : -1;
    }

    public int offsetFromContents(int offset) {
        for (Rng r : this.getPartRanges()) {
            if (offset < r.len()) {
                return r.start + offset;
            }
            offset -= r.len();
        }
        return this.getEnd();
    }

    public static enum Type {
        JAVA(true, true),
        JAVA_INCOMPLETE(true, true),
        MESSAGE(false, false),
        OUTPUT(false, false),
        COMMAND(true, false);

        public final boolean input;
        public final boolean java;

        private Type(boolean input, boolean java) {
            this.input = input;
            this.java = java;
        }
    }
}

