/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.dashboard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.ide.dashboard.Bundle;
import org.netbeans.modules.project.ui.api.RecentProjects;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RecentProjectsWidget
implements DashboardWidget {
    private static final int MAX_PROJECTS = 5;
    private static final RequestProcessor RP = new RequestProcessor("RecentProjects");
    private final List<WidgetElement> elements = new ArrayList<WidgetElement>();
    private final List<UnloadedProjectInformation> projects = new ArrayList<UnloadedProjectInformation>();
    private final Set<DashboardDisplayer.Panel> active = new HashSet<DashboardDisplayer.Panel>();
    private final PropertyChangeListener projectsListener = e -> {
        if ("RecentProjectInformation".equals(e.getPropertyName())) {
            this.loadProjects();
        }
    };
    private final Action newProject;
    private final Action openProject;
    private final Action projectGroups;

    public RecentProjectsWidget() {
        Action newProjectOriginal = Actions.forID((String)"Project", (String)"org.netbeans.modules.project.ui.NewProject");
        this.newProject = newProjectOriginal != null ? new ProjectDelegateAction(newProjectOriginal) : null;
        Action openProjectOriginal = Actions.forID((String)"Project", (String)"org.netbeans.modules.project.ui.OpenProject");
        this.openProject = openProjectOriginal != null ? new ProjectDelegateAction(openProjectOriginal) : null;
        Action projectGroupsOriginal = Actions.forID((String)"Project", (String)"org.netbeans.modules.project.ui.groups.GroupsMenu");
        this.projectGroups = projectGroupsOriginal != null ? new ProjectDelegateAction(projectGroupsOriginal) : null;
        this.buildElements();
        this.loadProjects();
    }

    public String title(DashboardDisplayer.Panel panel) {
        return Bundle.TITLE_RecentProjects();
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel panel) {
        return List.copyOf(this.elements);
    }

    public void showing(DashboardDisplayer.Panel panel) {
        if (this.active.isEmpty()) {
            RecentProjects.getDefault().addPropertyChangeListener(this.projectsListener);
        }
        this.active.add(panel);
        panel.refresh();
        this.loadProjects();
    }

    public void hidden(DashboardDisplayer.Panel panel) {
        this.active.remove(panel);
        if (this.active.isEmpty()) {
            RecentProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        }
    }

    private void loadProjects() {
        RP.execute(() -> {
            ArrayList<UnloadedProjectInformation> existingProjects = new ArrayList<UnloadedProjectInformation>(5);
            for (UnloadedProjectInformation p : RecentProjects.getDefault().getRecentProjectInformation()) {
                try {
                    File projectDir = Utilities.toFile((URI)p.getURL().toURI());
                    if (!projectDir.exists() || !projectDir.isDirectory()) continue;
                    existingProjects.add(p);
                    if (existingProjects.size() < 5) continue;
                    break;
                }
                catch (Exception ex) {
                    Logger.getLogger(RecentProjectsWidget.class.getName()).log(Level.FINE, null, ex);
                }
            }
            EventQueue.invokeLater(() -> this.updateProjectsList(existingProjects));
        });
    }

    private void buildElements() {
        this.elements.clear();
        if (this.projects.isEmpty()) {
            this.elements.add((WidgetElement)WidgetElement.unavailable((String)Bundle.LBL_NoRecentProjects()));
        } else {
            for (UnloadedProjectInformation project : this.projects) {
                this.elements.add((WidgetElement)WidgetElement.actionLink((Action)new OpenProjectAction(project)));
            }
        }
        if (this.newProject != null || this.openProject != null || this.projectGroups != null) {
            this.elements.add((WidgetElement)WidgetElement.separator());
        }
        if (this.newProject != null) {
            this.elements.add((WidgetElement)WidgetElement.actionLink((Action)this.newProject));
        }
        if (this.openProject != null) {
            this.elements.add((WidgetElement)WidgetElement.actionLink((Action)this.openProject));
        }
        if (this.projectGroups != null) {
            this.elements.add((WidgetElement)WidgetElement.actionLink((Action)this.projectGroups));
        }
    }

    private void updateProjectsList(List<UnloadedProjectInformation> projects) {
        if (!this.projects.equals(projects)) {
            this.projects.clear();
            this.projects.addAll(projects);
            this.buildElements();
            this.active.forEach(DashboardDisplayer.Panel::refresh);
        }
    }

    private static class ProjectDelegateAction
    extends AbstractAction {
        private final Action delegate;

        private ProjectDelegateAction(Action delegate) {
            super(Actions.cutAmpersand((String)String.valueOf(delegate.getValue("Name")).replace("...", "")));
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }
    }

    private static class OpenProjectAction
    extends AbstractAction {
        private final UnloadedProjectInformation project;

        private OpenProjectAction(UnloadedProjectInformation project) {
            super(project.getDisplayName(), project.getIcon());
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable task = () -> {
                URL url = this.project.getURL();
                Project prj = null;
                FileObject dir = URLMapper.findFileObject((URL)url);
                if (dir != null && dir.isFolder()) {
                    try {
                        prj = ProjectManager.getDefault().findProject(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (prj != null) {
                    OpenProjects.getDefault().open(new Project[]{prj}, false, true);
                } else {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.ERR_InvalidProject(this.project.getDisplayName()));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            };
            BaseProgressUtils.runOffEventDispatchThread((Runnable)task, (String)Bundle.LBL_OpenRecentProject(), (AtomicBoolean)new AtomicBoolean(false), (boolean)false);
        }
    }
}

