/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.blame;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.blame.AnnotateLine;
import org.netbeans.modules.git.ui.blame.AnnotationMark;
import org.netbeans.modules.git.ui.blame.AnnotationMarkInstaller;
import org.netbeans.modules.git.ui.blame.AnnotationMarkProvider;
import org.netbeans.modules.git.ui.blame.Bundle;
import org.netbeans.modules.git.ui.blame.LinesReader;
import org.netbeans.modules.git.ui.blame.TooltipWindow;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;

final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private static boolean fieldsInitialized;
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private Caret caret;
    private Timer caretTimer;
    private boolean annotated;
    private Map<Element, AnnotateLine> elementAnnotations;
    private String elementAnnotationsSubstitute;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentStatusMessage;
    private String recentRevision;
    static RequestProcessor requestProcessor;
    private RequestProcessor.Task latestAnnotationTask = null;
    private File repositoryRoot;
    private Map<String, String> previousRevisions;
    private File referencedFile;
    private FileObject referencedFileObject;
    static final Logger LOG;
    private String annotatedRevision;
    private static final DateFormat dateFormat;
    private final Map renderingHints;
    private MouseListener mouseListener;

    public AnnotationBar(JTextComponent target) {
        this.textComponent = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.elementAnnotationsSubstitute = "";
        if (this.textComponent instanceof JEditorPane) {
            String mimeType = DocumentUtilities.getMimeType((JTextComponent)this.textComponent);
            FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)mimeType).lookup(FontColorSettings.class);
            this.renderingHints = (Map)fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
        } else {
            this.renderingHints = null;
        }
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void annotate() {
        this.annotated = true;
        this.elementAnnotations = null;
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    public void setAnnotationMessage(String message) {
        this.elementAnnotationsSubstitute = message;
        this.revalidate();
    }

    public void annotationLines(File file, List<AnnotateLine> annotateLines) {
        this.repositoryRoot = Git.getInstance().getRepositoryRoot(this.getCurrentFile());
        final LinkedList<AnnotateLine> lines = new LinkedList<AnnotateLine>(annotateLines);
        int lineCount = lines.size();
        final int[] ann2editorPermutation = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            ann2editorPermutation[i] = i + 1;
        }
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diff != null) {
            LinesReader r = new LinesReader(lines);
            Reader docReader = Utils.getDocumentReader((Document)this.doc);
            try {
                int secondLen;
                int firstLen;
                int firstShift;
                Difference d;
                int i;
                Difference[] differences = diff.computeDiff((Reader)r, docReader);
                for (i = 0; i < differences.length; ++i) {
                    int editorStart;
                    d = differences[i];
                    if (d.getType() == 1) continue;
                    firstShift = d.getFirstEnd() - d.getFirstStart() + 1;
                    if (d.getType() == 2) {
                        firstLen = d.getFirstEnd() - d.getFirstStart();
                        secondLen = d.getSecondEnd() - d.getSecondStart();
                        if (secondLen >= firstLen) continue;
                        editorStart = d.getSecondStart();
                        firstShift = firstLen - secondLen;
                    } else {
                        editorStart = d.getSecondStart() + 1;
                    }
                    int c = editorStart + firstShift - 1;
                    while (c < lineCount) {
                        int n = c++;
                        ann2editorPermutation[n] = ann2editorPermutation[n] - firstShift;
                    }
                }
                for (i = differences.length - 1; i >= 0; --i) {
                    int firstStart;
                    d = differences[i];
                    if (d.getType() == 0) continue;
                    firstShift = d.getSecondEnd() - d.getSecondStart() + 1;
                    if (d.getType() == 2) {
                        firstLen = d.getFirstEnd() - d.getFirstStart();
                        secondLen = d.getSecondEnd() - d.getSecondStart();
                        if (secondLen <= firstLen) continue;
                        firstShift = secondLen - firstLen;
                        firstStart = d.getFirstStart();
                    } else {
                        firstStart = d.getFirstStart() + 1;
                    }
                    int k = firstStart - 1;
                    while (k < lineCount) {
                        int n = k++;
                        ann2editorPermutation[n] = ann2editorPermutation[n] + firstShift;
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Cannot compute local diff required for annotations, ignoring...");
            }
        }
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                StyledDocument sd = (StyledDocument)AnnotationBar.this.doc;
                AnnotationBar.this.previousRevisions = Collections.synchronizedMap(new HashMap());
                AnnotationBar.this.elementAnnotations = Collections.synchronizedMap(new HashMap(lines.size()));
                for (AnnotateLine line : lines) {
                    int lineNum = ann2editorPermutation[line.getLineNum() - 1];
                    try {
                        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)(lineNum - 1));
                        Element element = sd.getParagraphElement(lineOffset);
                        AnnotationBar.this.elementAnnotations.put(element, line);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        });
        this.caret = this.textComponent.getCaret();
        if (this.caret != null) {
            this.caret.addChangeListener(this);
        }
        this.textComponent.addPropertyChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.onCurrentLine();
        this.revalidate();
        this.repaint();
    }

    File getCurrentFile() {
        DataObject dobj;
        File result = this.referencedFile;
        if (result == null && (dobj = (DataObject)this.doc.getProperty((Object)"stream")) != null) {
            FileObject fo = dobj.getPrimaryFile();
            result = FileUtil.toFile((FileObject)fo);
        }
        return result;
    }

    FileObject getCurrentFileObject() {
        FileObject result = this.referencedFileObject;
        if (result == null) {
            Object sdp = this.doc.getProperty((Object)"stream");
            if (sdp instanceof FileObject) {
                result = (FileObject)sdp;
            } else if (sdp instanceof DataObject) {
                result = ((DataObject)sdp).getPrimaryFile();
            }
        }
        return result;
    }

    Document getDocument() {
        return this.doc;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    AnnotationBar.this.createPopup(e).show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getID() == 502 && e.getButton() == 1) {
                    e.consume();
                    AnnotationBar.this.showTooltipWindow(e);
                }
            }
        };
        this.addMouseListener(this.mouseListener);
        this.setToolTipText("");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void showTooltipWindow(MouseEvent event) {
        Point p = new Point(event.getPoint());
        SwingUtilities.convertPointToScreen(p, this);
        Point p2 = new Point(p);
        SwingUtilities.convertPointFromScreen(p2, this.textComponent);
        AnnotateLine al = null;
        if (this.elementAnnotations != null) {
            al = this.getAnnotateLine(this.getLineFromMouseEvent(event));
        }
        if (al != null && al.getRevisionInfo() != null) {
            TooltipWindow ttw = new TooltipWindow(this, al);
            ttw.show(new Point(p.x - p2.x, p.y));
        }
    }

    private JPopupMenu createPopup(MouseEvent e) {
        int sourceLine;
        final ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        final JPopupMenu popupMenu = new JPopupMenu();
        AnnotateLine al = null;
        if (this.elementAnnotations != null) {
            al = this.getAnnotateLine(this.getLineFromMouseEvent(e));
        }
        final GitRevisionInfo revisionPerLine = al == null ? null : al.getRevisionInfo();
        final File file = this.getCurrentFile();
        final File originalFile = al == null ? null : al.getFile();
        boolean revisionCanBeRolledBack = al == null || this.referencedFile != null ? false : al.canBeRolledBack();
        int n = sourceLine = al == null ? -1 : al.getSourceLineNum();
        if (revisionPerLine != null) {
            boolean hasPrevious;
            final JMenuItem diffMenu = new JMenuItem(loc.getString("CTL_MenuItem_DiffToPrevious"));
            diffMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(originalFile, revisionPerLine);
                    pri.runWithRevision(Git.getInstance().getRequestProcessor(), new Runnable(){

                        @Override
                        public void run() {
                            ((DiffAction)SystemAction.get(DiffAction.class)).diff(originalFile, new Revision(pri.getPreviousRevision(), pri.getPreviousRevision()), new Revision(revisionPerLine.getRevision(), revisionPerLine.getRevision()), sourceLine);
                        }
                    }, true, null);
                }
            });
            popupMenu.add(diffMenu);
            JMenuItem showCommitMenu = new JMenuItem(Bundle.CTL_AnnotationBar_action_showCommit(revisionPerLine.getRevision().substring(0, 7)));
            showCommitMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchHistoryAction.openSearch(AnnotationBar.this.repositoryRoot, file, file.getName(), revisionPerLine.getRevision(), revisionPerLine.getRevision());
                }
            });
            popupMenu.add(showCommitMenu);
            JMenuItem checkoutMenu = new JMenuItem();
            checkoutMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnnotationBar.this.checkout(file, revisionPerLine.getRevision());
                }
            });
            popupMenu.add(checkoutMenu);
            checkoutMenu.setEnabled(revisionCanBeRolledBack);
            final JMenuItem checkoutPrevItem = new JMenuItem();
            checkoutPrevItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(originalFile, revisionPerLine);
                    pri.runWithRevision(Git.getInstance().getRequestProcessor(AnnotationBar.this.repositoryRoot), new Runnable(){

                        @Override
                        public void run() {
                            String previousRevision = pri.getPreviousRevision();
                            AnnotationBar.this.checkout(originalFile, previousRevision);
                        }
                    }, false, null);
                }
            });
            popupMenu.add(checkoutPrevItem);
            checkoutPrevItem.setVisible(false);
            JMenuItem annotationsForSelectedItem = new JMenuItem(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_ShowAnnotationsFor", (Object)revisionPerLine.getRevision().substring(0, 7)));
            annotationsForSelectedItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new GitProgressSupport(){

                        @Override
                        protected void perform() {
                            try {
                                GitUtils.openInRevision(originalFile, sourceLine, revisionPerLine.getRevision(), true, this.getProgressMonitor());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }.start(Git.getInstance().getRequestProcessor(), AnnotationBar.this.repositoryRoot, NbBundle.getMessage(AnnotationBar.class, (String)"MSG_Annotation_Progress"));
                }
            });
            popupMenu.add(annotationsForSelectedItem);
            final JMenuItem previousAnnotationsMenu = new JMenuItem();
            previousAnnotationsMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(originalFile, revisionPerLine);
                    pri.runWithRevision(Git.getInstance().getRequestProcessor(AnnotationBar.this.repositoryRoot), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String previousRevision = pri.getPreviousRevision();
                                if (sourceLine > 0) {
                                    GitUtils.openInRevision(originalFile, revisionPerLine.getRevision(), sourceLine, previousRevision, true, pri.getProgressMonitor());
                                } else {
                                    GitUtils.openInRevision(originalFile, -1, previousRevision, true, pri.getProgressMonitor());
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }, false, NbBundle.getMessage(AnnotationBar.class, (String)"MSG_Annotation_Progress"));
                }
            });
            popupMenu.add(previousAnnotationsMenu);
            previousAnnotationsMenu.setVisible(false);
            JPopupMenu.Separator separator = new JPopupMenu.Separator();
            popupMenu.add(separator);
            String key = this.getKeyFor(originalFile, revisionPerLine.getRevision());
            String previousRevision = this.getPreviousRevisions().get(key);
            boolean bl = hasPrevious = previousRevision != null || !this.getPreviousRevisions().containsKey(key);
            if (previousRevision == null && hasPrevious) {
                final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(originalFile, revisionPerLine);
                pri.runWithRevision(Git.getInstance().getRequestProcessor(), new Runnable(){

                    @Override
                    public void run() {
                        String prevRev = pri.getPreviousRevision();
                        boolean showing = popupMenu.isShowing();
                        if (prevRev != null && showing) {
                            popupMenu.setVisible(false);
                            prevRev = prevRev.substring(0, 7);
                            String format = loc.getString("CTL_MenuItem_ShowAnnotationsPrevious.revision");
                            previousAnnotationsMenu.setText(MessageFormat.format(format, prevRev));
                            format = loc.getString("CTL_MenuItem_DiffToPrevious.revision");
                            diffMenu.setText(MessageFormat.format(format, prevRev));
                            checkoutPrevItem.setText(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_CheckoutPrevious.revision", (Object[])new Object[]{prevRev}));
                            popupMenu.setVisible(true);
                        }
                    }
                }, true, null);
            } else if (hasPrevious) {
                previousRevision = previousRevision.substring(0, 7);
            }
            String format = loc.getString(previousRevision == null ? "CTL_MenuItem_DiffToPrevious" : "CTL_MenuItem_DiffToPrevious.revision");
            diffMenu.setText(MessageFormat.format(format, previousRevision));
            diffMenu.setVisible(originalFile != null);
            format = loc.getString("CTL_MenuItem_Checkout");
            checkoutMenu.setText(MessageFormat.format(format, revisionPerLine.getRevision().substring(0, 7)));
            checkoutMenu.setVisible(true);
            separator.setVisible(true);
            annotationsForSelectedItem.setVisible(originalFile != null && revisionPerLine != null && !revisionPerLine.getRevision().equals(this.annotatedRevision));
            if (hasPrevious && originalFile != null) {
                format = loc.getString(previousRevision == null ? "CTL_MenuItem_ShowAnnotationsPrevious" : "CTL_MenuItem_ShowAnnotationsPrevious.revision");
                previousAnnotationsMenu.setText(MessageFormat.format(format, previousRevision));
                previousAnnotationsMenu.setVisible(true);
                previousAnnotationsMenu.setEnabled(!"-1".equals(previousRevision));
                if (file.equals(originalFile)) {
                    format = loc.getString(previousRevision == null ? "CTL_MenuItem_CheckoutPrevious" : "CTL_MenuItem_CheckoutPrevious.revision");
                    checkoutPrevItem.setText(MessageFormat.format(format, previousRevision));
                    checkoutPrevItem.setVisible(true);
                    checkoutPrevItem.setEnabled(true);
                }
            }
        }
        JMenu showMenu = this.createShowSubmenu();
        popupMenu.add(showMenu);
        popupMenu.add(new JPopupMenu.Separator());
        JMenuItem closeMenu = new JMenuItem(loc.getString("CTL_MenuItem_CloseAnnotations"));
        closeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationBar.this.hideBar();
            }
        });
        popupMenu.add(closeMenu);
        return popupMenu;
    }

    private JMenu createShowSubmenu() {
        JMenu showMenu = new JMenu(Bundle.LBL_Blame_menu_show());
        for (final DisplayField field : DisplayField.values()) {
            final JCheckBoxMenuItem mItem = new JCheckBoxMenuItem(Bundle.LBL_Blame_menu_show_commitId(), field.visible);
            Actions.connect((JMenuItem)mItem, (Action)new AbstractAction(field.label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    field.visible = mItem.isSelected();
                    int toStore = 0;
                    for (DisplayField field2 : DisplayField.values()) {
                        if (!field2.visible) continue;
                        toStore += field2.value;
                    }
                    final int toStoreFinal = toStore;
                    Utils.post((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GitModuleConfig.getDefault().setAnnotationDisplayedFields(toStoreFinal);
                        }
                    });
                    AnnotationBar.this.revalidate();
                    AnnotationBar.this.repaint();
                }
            }, (boolean)this.annotated);
            showMenu.add(mItem);
        }
        return showMenu;
    }

    void setAnnotatedRevision(String revision) {
        this.annotatedRevision = revision;
    }

    private String getKeyFor(File file, String revision) {
        return file.getAbsolutePath() + "#" + revision;
    }

    boolean isAnnotated() {
        return this.annotated;
    }

    private void checkout(File file, String revision) {
        File root = Git.getInstance().getRepositoryRoot(file);
        if (root == null) {
            return;
        }
        File[] files = new File[]{file};
        ((CheckoutPathsAction)SystemAction.get(CheckoutPathsAction.class)).checkoutFiles(this.repositoryRoot, new File[]{file}, revision);
    }

    void hideBar() {
        this.annotated = false;
        this.revalidate();
        this.release();
    }

    private static synchronized RequestProcessor getRequestProcessor() {
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if (this.isAnnotated()) {
            this.latestAnnotationTask = AnnotationBar.getRequestProcessor().post((Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Caret carett = this.caret;
        if (carett == null || !this.isAnnotated()) {
            return;
        }
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        StatusBar statusBar = this.editorUI.getStatusBar();
        this.recentStatusMessage = loc.getString("CTL_StatusBar_WaitFetchAnnotation");
        statusBar.setText("main", this.recentStatusMessage);
        int line = -1;
        int offset = carett.getDot();
        try {
            line = Utilities.getLineOffset((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, "Can not get line for caret at offset ", offset);
            this.clearRecentFeedback();
            return;
        }
        AnnotateLine al = this.getAnnotateLine(line);
        if (al == null) {
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                amp.setMarks(Collections.emptyList());
            }
            this.clearRecentFeedback();
            if (this.recentRevision != null) {
                this.recentRevision = null;
                this.repaint();
            }
            return;
        }
        String revision = al.getRevisionInfo().getRevision();
        if (!revision.equals(this.recentRevision)) {
            this.recentRevision = revision;
            this.repositoryRoot = Git.getInstance().getRepositoryRoot(this.getCurrentFile());
            this.repaint();
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                Iterator<Map.Entry<Element, AnnotateLine>> it2;
                ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
                Map<Element, AnnotateLine> map = this.elementAnnotations;
                synchronized (map) {
                    it2 = new HashSet<Map.Entry<Element, AnnotateLine>>(this.elementAnnotations.entrySet()).iterator();
                }
                while (it2.hasNext()) {
                    Map.Entry<Element, AnnotateLine> next = it2.next();
                    AnnotateLine annotateLine = next.getValue();
                    if (annotateLine.getRevisionInfo() != null && revision.equals(annotateLine.getRevisionInfo().getRevision())) {
                        Element element = next.getKey();
                        if (!this.elementAnnotations.containsKey(element)) continue;
                        int elementOffset = element.getStartOffset();
                        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)elementOffset);
                        AnnotationMark mark = new AnnotationMark(lineNumber, revision);
                        marks.add(mark);
                    }
                    if (!Thread.interrupted()) continue;
                    this.clearRecentFeedback();
                    return;
                }
                amp.setMarks(marks);
            }
        }
        if (al.getRevisionInfo() != null) {
            this.recentStatusMessage = al.getRevisionInfo().getShortMessage();
            statusBar.setText("main", al.getRevisionInfo().getRevision().substring(0, 7) + " - " + al.getAuthor().toString() + ": " + this.recentStatusMessage);
        } else {
            this.clearRecentFeedback();
        }
    }

    private void clearRecentFeedback() {
        StatusBar statusBar = this.editorUI.getStatusBar();
        if (statusBar.getText("main") == this.recentStatusMessage) {
            statusBar.setText("main", "");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        Dimension dim = this.textComponent.getSize();
        dim.width = width = this.annotated ? this.getBarWidth() : 0;
        dim.height *= 2;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBarWidth() {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return 0;
        }
        String longestString = "";
        if (this.elementAnnotations == null) {
            longestString = this.elementAnnotationsSubstitute;
        } else {
            Map<Element, AnnotateLine> map = this.elementAnnotations;
            synchronized (map) {
                for (AnnotateLine line : this.elementAnnotations.values()) {
                    String displayName = this.getDisplayName(line);
                    if (displayName.length() <= longestString.length()) continue;
                    longestString = displayName;
                }
            }
        }
        char[] data = longestString.toCharArray();
        int w = this.getGraphics().getFontMetrics(component.getFont()).charsWidth(data, 0, data.length);
        return w + 4;
    }

    private String getDisplayName(AnnotateLine line) {
        StringBuilder sb = new StringBuilder(20);
        if (line.getRevisionInfo() != null) {
            for (DisplayField field : AnnotationBar.getDisplayedFields()) {
                sb.append(field.format(line)).append(" ");
            }
            if (sb.length() == 0) {
                sb.append(Bundle.MSG_Blame_noDisplayField());
            } else {
                sb.delete(sb.length() - 1, sb.length());
            }
        }
        return sb.toString();
    }

    private void release() {
        AnnotationMarkProvider amp;
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.textComponent.removePropertyChangeListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        if (this.caret != null) {
            this.caret.removeChangeListener(this);
        }
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.elementAnnotations = null;
        this.previousRevisions = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if ((amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            amp.setMarks(Collections.emptyList());
        }
        this.clearRecentFeedback();
    }

    private void paintView(View view, Graphics g, int yBase) {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        String annotation = "";
        AnnotateLine al = null;
        if (this.elementAnnotations != null) {
            al = this.getAnnotateLine(line);
            if (al != null) {
                annotation = this.getDisplayName(al);
            }
        } else {
            annotation = this.elementAnnotationsSubstitute;
        }
        if (al != null && al.getRevisionInfo().getRevision().equals(this.recentRevision)) {
            g.setColor(this.selectedColor());
        } else {
            g.setColor(this.foregroundColor());
        }
        int texty = yBase + this.editorUI.getLineAscent();
        int textx = 2;
        g.setFont(component.getFont());
        g.drawString(annotation, textx, texty);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        StringBuilder annotation = new StringBuilder();
        if (this.elementAnnotations != null) {
            AnnotateLine al = this.getAnnotateLine(line);
            if (al != null && al.getRevisionInfo() != null) {
                String escapedAuthor = NbBundle.getMessage(AnnotationBar.class, (String)"TT_Annotation");
                try {
                    escapedAuthor = XMLUtil.toElementContent((String)al.getAuthor().toString());
                }
                catch (CharConversionException e1) {
                    LOG.log(Level.INFO, "HG.AB: can not HTML escape: ", al.getAuthor());
                }
                annotation.append("<html><!-- line=").append(line++).append(" -->").append(al.getRevisionInfo().getRevision().substring(0, 7)).append(" - <b>").append(escapedAuthor).append("</b>");
                annotation.append(" ").append(DateFormat.getDateInstance().format(new Date(al.getRevisionInfo().getCommitTime())));
                String message = al.getRevisionInfo().getFullMessage();
                if (message != null) {
                    String escaped = null;
                    try {
                        escaped = XMLUtil.toElementContent((String)message);
                    }
                    catch (CharConversionException e1) {
                        LOG.log(Level.INFO, "HG.AB: can not HTML escape: ", message);
                    }
                    if (escaped != null) {
                        String lined = escaped.replace("\n", "<br>");
                        annotation.append("<p>").append(lined);
                    }
                }
            }
        } else {
            annotation.append(this.elementAnnotationsSubstitute);
        }
        return annotation.toString();
    }

    private AnnotateLine getAnnotateLine(int line) {
        StyledDocument sd = (StyledDocument)this.doc;
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)line);
        Element element = sd.getParagraphElement(lineOffset);
        AnnotateLine al = this.elementAnnotations.get(element);
        if (al != null) {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            try {
                int len = endOffset - startOffset;
                String text = this.doc.getText(startOffset, len - 1);
                String content = al.getContent();
                if (text.equals(content)) {
                    return al;
                }
            }
            catch (BadLocationException e) {
                LOG.log(Level.INFO, "HG.AB: can not locate line annotation.");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block14: {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            if (g instanceof Graphics2D && this.renderingHints != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.addRenderingHints(this.renderingHints);
            }
            AbstractDocument doc = (AbstractDocument)component.getDocument();
            doc.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block14;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        Rectangle rec = component.modelToView(view.getStartOffset());
                        if (rec == null) {
                        } else {
                            int y = rec.y;
                            this.paintView(view, g, y);
                            if (y < clipEndY) continue;
                        }
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, null, ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        if (this.backgroundColor.equals(this.backgroundColor())) {
            return this.selectedColor;
        }
        if (this.textComponent != null) {
            return this.textComponent.getCaretColor();
        }
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset((BaseDocument)this.doc, (int)clickOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String id = evt.getPropertyName();
        if (evt.getSource() == this.textComponent) {
            if ("caret".equals(id)) {
                if (this.caret != null) {
                    this.caret.removeChangeListener(this);
                }
                this.caret = this.textComponent.getCaret();
                if (this.caret != null) {
                    this.caret.addChangeListener(this);
                }
            }
            return;
        }
        if ("component".equals(id) && evt.getNewValue() == null) {
            this.release();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.elementAnnotations != null) {
            Element[] elements = e.getDocument().getRootElements();
            Map<Element, AnnotateLine> map = this.elementAnnotations;
            synchronized (map) {
                for (int i = 0; i < elements.length; ++i) {
                    Element key;
                    AnnotateLine recent;
                    Element[] added;
                    Element element = elements[i];
                    DocumentEvent.ElementChange change = e.getChange(element);
                    if (change == null) continue;
                    Element[] removed = change.getChildrenRemoved();
                    if (removed.length == (added = change.getChildrenAdded()).length) {
                        for (int c = 0; c < removed.length; ++c) {
                            recent = this.elementAnnotations.get(removed[c]);
                            if (recent == null) continue;
                            this.elementAnnotations.remove(removed[c]);
                            this.elementAnnotations.put(added[c], recent);
                        }
                        continue;
                    }
                    if (removed.length != 1 || added.length <= 0 || (recent = this.elementAnnotations.get(key = removed[0])) == null) continue;
                    this.elementAnnotations.remove(key);
                    this.elementAnnotations.put(added[0], recent);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        final int length = e.getDocument().getLength();
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (length == 0) {
                    AnnotationBar.this.hideBar();
                }
                AnnotationBar.this.repaint();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        assert (e.getSource() == this.caret);
        this.caretTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private Map<String, String> getPreviousRevisions() {
        HashMap revisions = this.previousRevisions;
        return revisions == null ? new HashMap(0) : revisions;
    }

    void setReferencedFile(File file) {
        this.referencedFile = FileUtil.normalizeFile((File)file);
        this.referencedFileObject = FileUtil.toFileObject((File)file);
    }

    private static Set<DisplayField> getDisplayedFields() {
        assert (EventQueue.isDispatchThread());
        EnumSet<DisplayField> fields = EnumSet.noneOf(DisplayField.class);
        if (!fieldsInitialized) {
            fieldsInitialized = true;
            int stored = GitModuleConfig.getDefault().getAnnotationDisplayedFields(DisplayField.COMMIT_ID.value + DisplayField.AUTHOR.value);
            DisplayField[] displayFieldArray = DisplayField.values();
            int n = displayFieldArray.length;
            for (int i = 0; i < n; ++i) {
                DisplayField field = displayFieldArray[i];
                field.visible = (stored & field.value) != 0;
            }
        }
        for (DisplayField field : DisplayField.values()) {
            if (!field.visible) continue;
            fields.add(field);
        }
        return fields;
    }

    static {
        requestProcessor = null;
        LOG = Logger.getLogger(AnnotationBar.class.getName());
        dateFormat = new SimpleDateFormat("YYYY-MM-dd");
    }

    private class PreviousRevisionInvoker
    extends GitProgressSupport.NoOutputLogging {
        private final GitRevisionInfo revisionPerLine;
        private String parent;
        private boolean inAWT;
        private Runnable runnable;
        private boolean progressNameSet;
        private final File originalFile;

        private PreviousRevisionInvoker(File originalFile, GitRevisionInfo revisionPerLine) {
            this.revisionPerLine = revisionPerLine;
            this.originalFile = originalFile;
        }

        public void runWithRevision(RequestProcessor rp, Runnable runnable, boolean inAWT, String progressName) {
            this.runnable = runnable;
            this.inAWT = inAWT;
            this.progressNameSet = progressName != null;
            this.start(rp, AnnotationBar.this.repositoryRoot, this.progressNameSet ? progressName : NbBundle.getMessage(AnnotationBar.class, (String)"MSG_GettingPreviousRevision"));
        }

        @Override
        protected void perform() {
            if (this.progressNameSet) {
                this.setProgress(NbBundle.getMessage(AnnotationBar.class, (String)"MSG_GettingPreviousRevision"));
            }
            String previousRevision = this.getParentRevision(this.originalFile, this.revisionPerLine);
            if (!this.isCanceled() && previousRevision != null) {
                if (this.inAWT) {
                    EventQueue.invokeLater(this.runnable);
                } else {
                    if (this.progressNameSet) {
                        this.setProgress(null);
                    }
                    this.runnable.run();
                }
            }
        }

        private String getParentRevision(File file, GitRevisionInfo revision) {
            String key = AnnotationBar.this.getKeyFor(file, this.revisionPerLine.getRevision());
            this.parent = AnnotationBar.this.getPreviousRevisions().get(key);
            if (this.parent == null) {
                GitRevisionInfo parentInfo = null;
                try {
                    if (revision.getParents().length == 1) {
                        parentInfo = this.getClient().getPreviousRevision(file, revision.getRevision(), this.getProgressMonitor());
                    }
                    if (parentInfo == null) {
                        parentInfo = this.getClient().getCommonAncestor(revision.getParents(), this.getProgressMonitor());
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                if (parentInfo != null) {
                    this.parent = parentInfo.getRevision();
                }
                AnnotationBar.this.getPreviousRevisions().put(key, this.parent);
            }
            return this.parent;
        }

        private String getPreviousRevision() {
            return this.parent;
        }
    }

    private static enum DisplayField {
        COMMIT_ID(1, Bundle.LBL_Blame_menu_show_commitId(), true){

            @Override
            String format(AnnotateLine line) {
                return line.getRevisionInfo().getRevision().substring(0, 7);
            }
        }
        ,
        DATE(2, Bundle.LBL_Blame_menu_show_date(), false){

            @Override
            String format(AnnotateLine line) {
                return dateFormat.format(new Date(line.getRevisionInfo().getCommitTime()));
            }
        }
        ,
        AUTHOR(4, Bundle.LBL_Blame_menu_show_author(), true){

            @Override
            String format(AnnotateLine line) {
                return line.getAuthorShort();
            }
        };

        private final int value;
        private final String label;
        private boolean visible;

        private DisplayField(int val, String label, boolean visibleByDefault) {
            this.value = val;
            this.label = label;
            this.visible = visibleByDefault;
        }

        abstract String format(AnnotateLine var1);
    }
}

