/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.build;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.build.AdvancedTask;

public final class Tasks {
    private final List<AdvancedTask> advancedTasks;
    private final boolean showSimpleTasks;
    @NullAllowed
    private final List<String> simpleTasks;

    public Tasks(List<AdvancedTask> advancedTasks, boolean showSimpleTasks, @NullAllowed List<String> simpleTasks) {
        assert (advancedTasks != null);
        this.advancedTasks = new CopyOnWriteArrayList<AdvancedTask>(advancedTasks);
        this.showSimpleTasks = showSimpleTasks;
        this.simpleTasks = simpleTasks == null ? null : new CopyOnWriteArrayList<String>(simpleTasks);
    }

    public List<AdvancedTask> getAdvancedTasks() {
        return Collections.unmodifiableList(this.advancedTasks);
    }

    public boolean isShowSimpleTasks() {
        return this.showSimpleTasks;
    }

    @CheckForNull
    public List<String> getSimpleTasks() {
        if (this.simpleTasks == null) {
            return null;
        }
        return Collections.unmodifiableList(this.simpleTasks);
    }

    public String toString() {
        return "Tasks{advancedTasks=" + this.advancedTasks + ", showSimpleTasks=" + this.showSimpleTasks + ", simpleTasks=" + this.simpleTasks + '}';
    }
}

