/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.progress;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.progress.ProgressListener;

public class Progress {
    protected String title = "";
    protected String detail = "";
    protected int percentage = 0;
    protected boolean canceled = false;
    private ProgressListener synchronizer = null;
    private Progress source = null;
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    public static final int START = 0;
    public static final int COMPLETE = 100;
    public static final String ERROR_WRONG_PERCENTAGE = ResourceUtils.getString(Progress.class, "P.error.percentage");

    public Progress() {
    }

    public Progress(ProgressListener initialListener) {
        this();
        this.addProgressListener(initialListener);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (!this.title.equals(title)) {
            this.title = title;
            this.notifyListeners();
        }
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        if (!this.detail.equals(detail)) {
            this.detail = detail;
            this.notifyListeners();
        }
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) {
        if (this.percentage != percentage) {
            if (percentage < 0 || percentage > 100) {
                LogManager.log(StringUtils.format(ERROR_WRONG_PERCENTAGE, percentage, 0, 100));
            } else {
                this.percentage = percentage;
            }
            this.notifyListeners();
        }
    }

    public void setPercentage(long percentage) {
        this.setPercentage((int)percentage);
    }

    public void addPercentage(int addition) {
        int result = this.percentage + addition;
        if (this.percentage != result) {
            if (result < 0 || result > 100) {
                LogManager.log(StringUtils.format(ERROR_WRONG_PERCENTAGE, result, 0, 100));
            } else {
                this.percentage = result;
            }
            this.notifyListeners();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        if (this.canceled != canceled) {
            this.canceled = canceled;
            if (this.source != null) {
                this.source.setCanceled(canceled);
            }
            this.notifyListeners();
        }
    }

    public void synchronizeFrom(Progress progress) {
        if (this.source != null) {
            this.source.removeProgressListener(this.synchronizer);
        }
        if (progress != null) {
            this.synchronizer = new ProgressListener(){

                @Override
                public void progressUpdated(Progress progress) {
                    Progress.this.setTitle(progress.getTitle());
                    Progress.this.setDetail(progress.getDetail());
                    Progress.this.setPercentage(progress.getPercentage());
                }
            };
            this.source = progress;
            this.source.addProgressListener(this.synchronizer);
        }
    }

    public void reverseSynchronizeFrom(Progress progress) {
        if (this.source != null) {
            this.source.removeProgressListener(this.synchronizer);
        }
        if (progress != null) {
            this.synchronizer = new ProgressListener(){

                @Override
                public void progressUpdated(Progress progress) {
                    Progress.this.setTitle(progress.getTitle());
                    Progress.this.setDetail(progress.getDetail());
                    Progress.this.setPercentage(100 - progress.getPercentage());
                }
            };
            this.source = progress;
            this.source.addProgressListener(this.synchronizer);
        }
    }

    public void synchronizeTo(Progress progress) {
        progress.synchronizeFrom(this);
    }

    public void reverseSynchronizeTo(Progress progress) {
        progress.reverseSynchronizeFrom(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        List<ProgressListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        List<ProgressListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        ProgressListener[] progressListenerArray = this.listeners;
        synchronized (this.listeners) {
            ProgressListener[] clone = this.listeners.toArray(new ProgressListener[this.listeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ProgressListener listener : clone) {
                listener.progressUpdated(this);
            }
            return;
        }
    }
}

