/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDatabaseRequest
extends BmcRequest<Void> {
    private String databaseId;
    private String ifMatch;
    private Boolean performFinalBackup;
    private String opcRequestId;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getPerformFinalBackup() {
        return this.performFinalBackup;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).ifMatch(this.ifMatch).performFinalBackup(this.performFinalBackup).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",performFinalBackup=").append(String.valueOf(this.performFinalBackup));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDatabaseRequest)) {
            return false;
        }
        DeleteDatabaseRequest other = (DeleteDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.performFinalBackup, other.performFinalBackup) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.performFinalBackup == null ? 43 : this.performFinalBackup.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDatabaseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String ifMatch = null;
        private Boolean performFinalBackup = null;
        private String opcRequestId = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder performFinalBackup(Boolean performFinalBackup) {
            this.performFinalBackup = performFinalBackup;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.ifMatch(o.getIfMatch());
            this.performFinalBackup(o.getPerformFinalBackup());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDatabaseRequest build() {
            DeleteDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDatabaseRequest buildWithoutInvocationCallback() {
            DeleteDatabaseRequest request = new DeleteDatabaseRequest();
            request.databaseId = this.databaseId;
            request.ifMatch = this.ifMatch;
            request.performFinalBackup = this.performFinalBackup;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

