/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject;

import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ServerURLMappingImpl
implements ServerURLMappingImplementation {
    private final ClientSideProject project;

    public ServerURLMappingImpl(ClientSideProject project) {
        this.project = project;
    }

    public URL toServer(int projectContext, FileObject projectFile) {
        URL url;
        if (projectContext == 1) {
            URL u = null;
            if (this.project.isUsingEmbeddedServer()) {
                u = WebServer.getWebserver().toServer(projectFile);
            } else {
                String relPath = FileUtil.getRelativePath((FileObject)this.project.getSiteRootFolder(), (FileObject)projectFile);
                String root = this.project.getEvaluator().getProperty("external.project.url");
                if (root == null) {
                    return null;
                }
                if (!root.endsWith("/")) {
                    root = root + "/";
                }
                if (root.contains(":80/")) {
                    root = root.replace(":80/", "/");
                } else if (root.contains(":443/") && root.contains("https")) {
                    root = root.replace(":443/", "/");
                }
                u = WebUtils.stringToUrl((String)(root + relPath));
            }
            WebBrowser browser = this.project.getProjectWebBrowser();
            if (browser != null && u != null) {
                u = browser.toBrowserURL((Project)this.project, projectFile, u);
            }
            return u;
        }
        JsTestingProvider testingProvider = this.project.getJsTestingProvider(false);
        if (testingProvider != null && (url = testingProvider.toServer((Project)this.project, projectFile)) != null) {
            return url;
        }
        return null;
    }

    public FileObject fromServer(int projectContext, URL serverURL) {
        JsTestingProvider testingProvider;
        if ((serverURL = WebUtils.stringToUrl((String)WebUtils.urlToString((URL)serverURL, (boolean)true))) == null) {
            return null;
        }
        WebBrowser browser = this.project.getProjectWebBrowser();
        if (browser != null) {
            serverURL = browser.fromBrowserURL((Project)this.project, serverURL);
        }
        FileObject fo = null;
        if (this.project.isUsingEmbeddedServer()) {
            fo = WebServer.getWebserver().fromServer(serverURL);
        } else {
            String root = this.project.getEvaluator().getProperty("external.project.url");
            if (root == null) {
                return null;
            }
            String u = WebUtils.urlToString((URL)serverURL);
            if (!u.startsWith(root)) {
                if (root.contains(":80/")) {
                    if (u.startsWith(root.replace(":80/", "/"))) {
                        root = root.replace(":80/", "/");
                    }
                } else if (root.contains(":443/") && u.startsWith(root.replace(":443/", "/"))) {
                    root = root.replace(":443/", "/");
                }
            }
            if (u.startsWith(root)) {
                FileObject siteRoot;
                if ((u = u.substring(root.length())).startsWith("/")) {
                    u = u.substring(1);
                }
                if ((siteRoot = this.project.getSiteRootFolder()) != null) {
                    fo = siteRoot.getFileObject(u);
                } else {
                    return null;
                }
            }
        }
        if (fo == null && (testingProvider = this.project.getJsTestingProvider(false)) != null) {
            fo = testingProvider.fromServer((Project)this.project, serverURL);
        }
        return fo;
    }
}

