/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.CreateAutonomousDBDialog;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class CreateAutonomousDBAction
extends AbstractAction
implements ContextAwareAction {
    private final CompartmentItem context;
    private OCIProfile session;

    public CreateAutonomousDBAction(CompartmentItem context) {
        this.context = context;
        this.session = OCIManager.getDefault().getActiveProfile();
    }

    CreateAutonomousDBAction(OCIProfile session, CompartmentItem context) {
        this.context = context;
        this.session = session;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        OCIProfile session = (OCIProfile)actionContext.lookup(OCIProfile.class);
        return new CreateAutonomousDBAction(session, this.context);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Optional<Pair<String, char[]>> result = CreateAutonomousDBDialog.showDialog(this.context);
        result.ifPresent(p -> RequestProcessor.getDefault().execute(() -> {
            Optional<String> message = this.session.createAutonomousDatabase(this.context.getKey().getValue(), (String)p.first(), (char[])p.second());
            if (!message.isPresent()) {
                this.context.refresh();
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_DBCreated(p.first())));
            } else {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_DBNotCreated(p.first(), message.get())));
            }
        }));
    }
}

