/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.symbol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.micronaut.symbol.MicronautSymbolFinder;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MicronautSymbolSearcher
implements IndexSearcher {
    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String textForQuery, QuerySupport.Kind searchType, IndexSearcher.Helper helper) {
        return Collections.emptySet();
    }

    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String textForQuery, QuerySupport.Kind searchType, IndexSearcher.Helper helper) {
        if (project == null || !textForQuery.startsWith("@") || IndexingManager.getDefault().isIndexing()) {
            return Collections.emptySet();
        }
        if (textForQuery.equals("@/")) {
            RequestProcessor.getDefault().post(() -> {
                try {
                    Set duplicates = MicronautSymbolSearcher.getSymbolsWithPathDuplicates(project, null).stream().map(descriptor -> descriptor.getFileObject()).collect(Collectors.toSet());
                    if (!duplicates.isEmpty()) {
                        Diagnostic.ReporterControl control = Diagnostic.findReporterControl((Lookup)Lookup.getDefault(), (FileObject)project.getProjectDirectory());
                        control.diagnosticChanged(duplicates, "text/x-java");
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        return MicronautSymbolSearcher.getSymbols(project, textForQuery);
    }

    static Set<SymbolDescriptor> getSymbolsWithPathDuplicates(Project project, FileObject fo) throws IOException {
        JavaSource js;
        EditorCookie ec = fo != null ? (EditorCookie)fo.getLookup().lookup(EditorCookie.class) : null;
        StyledDocument doc = ec != null ? ec.openDocument() : null;
        HashSet<SymbolDescriptor> duplicates = new HashSet<SymbolDescriptor>();
        HashMap<String, SymbolDescriptor> map = new HashMap<String, SymbolDescriptor>();
        for (SymbolDescriptor symbol : MicronautSymbolSearcher.getSymbols(project, "@/")) {
            SymbolDescriptor previous;
            if (doc != null && symbol.getFileObject() == fo || (previous = map.put(symbol.getSimpleName().replaceAll("\\{.*}", "{}"), symbol)) == null) continue;
            duplicates.add(symbol);
            duplicates.add(previous);
        }
        JavaSource javaSource = js = doc != null ? JavaSource.forDocument((Document)doc) : null;
        if (js != null) {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (MicronautSymbolFinder.SymbolLocation sl : MicronautSymbolFinder.scan(cc, true)) {
                    SymbolDescriptor symbol = new SymbolDescriptor(sl.getName(), fo, sl.getSelectionStart(), sl.getSelectionEnd());
                    SymbolDescriptor previous = map.put(symbol.getSimpleName().replaceAll("\\{.*}", "{}"), symbol);
                    if (previous == null) continue;
                    duplicates.add(symbol);
                    duplicates.add(previous);
                }
            }, true);
        }
        return duplicates;
    }

    private static Set<SymbolDescriptor> getSymbols(Project project, String textForQuery) {
        HashSet<SymbolDescriptor> symbols = new HashSet<SymbolDescriptor>();
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            try {
                FileObject cacheRoot = MicronautSymbolSearcher.getCacheRoot(sg.getRootFolder().toURL());
                if (cacheRoot == null) continue;
                cacheRoot.refresh();
                Enumeration children = cacheRoot.getChildren(true);
                while (children.hasMoreElements()) {
                    FileObject child = (FileObject)children.nextElement();
                    if (!child.hasExt("mn")) continue;
                    MicronautSymbolSearcher.loadSymbols(child, textForQuery, symbols);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return symbols;
    }

    private static void loadSymbols(FileObject input, String textForQuery, Set<SymbolDescriptor> symbols) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            FileObject fo = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("url: ")) {
                    String url = line.substring(5);
                    fo = URLMapper.findFileObject((URL)URI.create(url).toURL());
                    if (fo != null) continue;
                    return;
                }
                if (!line.startsWith("symbol: ")) continue;
                String info = line.substring(8);
                int idx = info.lastIndexOf(58);
                if (idx < 0) {
                    return;
                }
                String name = info.substring(0, idx).trim();
                if (!name.startsWith(textForQuery)) continue;
                String[] range = info.substring(idx + 1).split("-");
                int start = range.length > 0 ? Integer.parseInt(range[0]) : 0;
                int end = range.length > 1 ? Integer.parseInt(range[1]) : start;
                symbols.add(new SymbolDescriptor(name, fo, start, end));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static FileObject getCacheRoot(URL root) throws IOException {
        FileObject dataFolder = CacheFolder.getDataFolder((URL)root, (boolean)true);
        return dataFolder != null ? FileUtil.createFolder((FileObject)dataFolder, (String)"mn/1") : null;
    }

    static class SymbolDescriptor
    extends IndexSearcher.Descriptor
    implements ElementHandle {
        private final String name;
        private final FileObject fo;
        private final Project project;
        private final OffsetRange range;

        private SymbolDescriptor(String name, FileObject fo, int start, int end) {
            this.name = name;
            this.fo = fo;
            this.project = FileOwnerQuery.getOwner((FileObject)fo);
            this.range = new OffsetRange(start, end);
        }

        public ElementHandle getElement() {
            return this;
        }

        public String getSimpleName() {
            return this.name;
        }

        public String getOuterName() {
            return null;
        }

        public String getTypeName() {
            return null;
        }

        public String getContextName() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public String getProjectName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public Icon getProjectIcon() {
            return ProjectUtils.getInformation((Project)this.project).getIcon();
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public int getOffset() {
            return this.range.getStart();
        }

        public void open() {
            GsfUtilities.open((FileObject)this.getFileObject(), (int)this.getOffset(), null);
        }

        public String getMimeType() {
            return this.getFileObject().getMIMEType();
        }

        public String getName() {
            return this.getSimpleName();
        }

        public String getIn() {
            return this.getOuterName();
        }

        public ElementKind getKind() {
            return ElementKind.INTERFACE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.singleton(Modifier.PUBLIC);
        }

        public boolean signatureEquals(ElementHandle handle) {
            if (handle instanceof SymbolDescriptor) {
                return this.getName().equals(handle.getName());
            }
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return this.range;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.fo);
            hash = 67 * hash + Objects.hashCode(this.range);
            hash = 67 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SymbolDescriptor other = (SymbolDescriptor)((Object)obj);
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.fo, other.fo)) {
                return false;
            }
            return Objects.equals(this.range, other.range);
        }
    }
}

