/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

class MultiPartHandler {
    private static final int DEFAULT_MAX_UPLOAD_SIZE = 0x100000;
    protected Hashtable<String, Vector<String>> formFields = new Hashtable();
    Hashtable<String, OneUpload> uploadFiles = new Hashtable();
    private RequestFacade req;
    private InputFacade in;
    private String boundary;
    private byte[] buf = new byte[8192];
    private File uploadDir;
    private String fieldEncoding = "ISO-8859-1";

    public MultiPartHandler(RequestFacade request, String tmpDirectory) throws IOException {
        this(request, tmpDirectory, 0x100000, "ISO-8859-1");
    }

    public MultiPartHandler(RequestFacade request, String tmpDirectory, int maxUploadSize) throws IOException {
        this(request, tmpDirectory, maxUploadSize, "ISO-8859-1");
    }

    public MultiPartHandler(RequestFacade request, String tmpDirectory, int maxUploadSize, String fieldEncoding) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (tmpDirectory == null) {
            throw new IllegalArgumentException("tmp Dir is null");
        }
        if (maxUploadSize <= 0) {
            throw new IllegalArgumentException("Max size is < 0");
        }
        this.uploadDir = new File(tmpDirectory);
        if (!this.uploadDir.isDirectory()) {
            throw new IllegalArgumentException("Not a Directory");
        }
        if (!this.uploadDir.canWrite()) {
            throw new IllegalArgumentException("write protected");
        }
        String type = request.getContentType();
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("type null");
        }
        this.fieldEncoding = fieldEncoding;
        this.req = request;
    }

    public void parseMultipartUpload() throws IOException {
        this.startMultipartParse();
        HashMap partHeaders = this.parsePartHeaders();
        while (partHeaders != null) {
            String fieldName = (String)partHeaders.get("fieldName");
            String fileName = (String)partHeaders.get("fileName");
            if (fileName != null) {
                if (fileName.equals("")) {
                    fileName = null;
                }
                if (fileName != null) {
                    String content = (String)partHeaders.get("content-type");
                    fileName = this.saveUploadFile(fileName, content);
                    this.uploadFiles.put(fieldName, new OneUpload(this.uploadDir.toString(), fileName, content));
                } else {
                    this.uploadFiles.put(fieldName, new OneUpload(null, null, null));
                }
            } else {
                byte[] valueBytes = this.parseFormFieldBytes();
                String value = new String(valueBytes, this.fieldEncoding);
                Vector<String> existingValues = this.formFields.get(fieldName);
                if (existingValues == null) {
                    existingValues = new Vector();
                    this.formFields.put(fieldName, existingValues);
                }
                existingValues.addElement(value);
            }
            partHeaders.clear();
            partHeaders = this.parsePartHeaders();
        }
    }

    private void startMultipartParse() throws IOException {
        String boundary = this.parseBoundary(this.req.getContentType());
        if (boundary == null) {
            throw new IOException("boundary is nul");
        }
        this.in = this.req.getInput();
        this.boundary = boundary;
        String line = this.readLine();
        if (line == null) {
            throw new IOException("line is null");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("not start with boundary");
        }
    }

    private HashMap parsePartHeaders() throws IOException {
        HashMap<String, String> partHeaders = new HashMap<String, String>();
        Vector<String> headers = new Vector<String>();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        headers.addElement(line);
        while ((line = this.readLine()) != null && line.length() > 0) {
            headers.addElement(line);
        }
        if (line == null) {
            return null;
        }
        partHeaders.put("content-type", "text/plain");
        Enumeration ee = headers.elements();
        while (ee.hasMoreElements()) {
            String headerline = (String)ee.nextElement();
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                this.parseContentDisposition(headerline, partHeaders);
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:")) continue;
            this.parseContentType(headerline, partHeaders);
        }
        return partHeaders;
    }

    private String parseBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private void parseContentDisposition(String line, HashMap<String, String> partHeaders) throws IOException {
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("end reached");
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("fome-data not match");
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("data corrupt");
        }
        String name = origline.substring(start + 6, end);
        String fileName = null;
        String origFileName = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origFileName = fileName = origline.substring(start + 10, end);
            int slash = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92));
            if (slash > -1) {
                fileName = fileName.substring(slash + 1);
            }
        }
        partHeaders.put("disposition", disposition);
        partHeaders.put("fieldName", name);
        partHeaders.put("fileName", fileName);
        partHeaders.put("filePath", origFileName);
    }

    private void parseContentType(String line, HashMap<String, String> partHeaders) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("no start");
            }
            contentType = line.substring(start + 1);
            partHeaders.put("content-type", contentType);
        } else if (line.length() != 0) {
            throw new IOException("length 0");
        }
    }

    private byte[] parseFormFieldBytes() throws IOException {
        int read;
        MultipartInputStream pis = new MultipartInputStream(this.in, this.boundary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        byte[] buf = new byte[128];
        while ((read = pis.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        pis.close();
        baos.close();
        return baos.toByteArray();
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, StandardCharsets.ISO_8859_1));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    private String saveUploadFile(String fileName, String content) throws IOException {
        long written = 0L;
        File file = new File(this.uploadDir, fileName);
        try (OutputStream fileOut = null;){
            int numBytes;
            InputStream partInput;
            int i = 0;
            while (file.exists() && file.exists()) {
                file = new File(this.uploadDir, fileName + "." + i);
                ++i;
            }
            fileName = file.getName();
            fileOut = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[8192];
            boolean canCloseStream = true;
            if (content.equals("x-application/gzip")) {
                partInput = this.in.getInputStream();
                canCloseStream = false;
            } else {
                partInput = new MultipartInputStream(this.in, this.boundary);
            }
            while ((numBytes = partInput.read(buf)) != -1) {
                fileOut.write(buf, 0, numBytes);
                written += (long)numBytes;
            }
            if (canCloseStream) {
                partInput.close();
            }
        }
        return fileName;
    }

    public Enumeration getParameterNames() {
        return this.formFields.keys();
    }

    public Enumeration getFileNames() {
        return this.uploadFiles.keys();
    }

    public String getParameter(String name) {
        try {
            Vector<String> values = this.formFields.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = values.elementAt(values.size() - 1);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector<String> values = this.formFields.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFileName(String name) {
        try {
            OneUpload file = this.uploadFiles.get(name);
            return file.getFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFileType(String name) {
        try {
            OneUpload file = this.uploadFiles.get(name);
            return file.getFileType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            OneUpload file = this.uploadFiles.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() throws IOException {
        this.req = null;
        this.in = null;
        this.boundary = null;
        this.buf = null;
        this.uploadDir = null;
    }

    public static interface RequestFacade {
        public int getContentLength();

        public String getContentType();

        public InputFacade getInput() throws IOException;
    }

    private static class OneUpload {
        private String dir;
        private String filename;
        private String type;

        OneUpload(String dir, String filename, String type) {
            this.dir = dir;
            this.filename = filename;
            this.type = type;
        }

        public String getFileType() {
            return this.type;
        }

        public String getFileName() {
            return this.filename;
        }

        public File getFile() {
            if (this.dir == null || this.filename == null) {
                return null;
            }
            return new File(this.dir + File.separator + this.filename);
        }
    }

    public static interface InputFacade {
        public int readLine(byte[] var1, int var2, int var3) throws IOException;

        public InputStream getInputStream();
    }

    private static class MultipartInputStream
    extends FilterInputStream {
        private String boundary;
        private byte[] buf = new byte[65536];
        private int count;
        private int pos;
        private boolean eof;
        private InputFacade facade;

        MultipartInputStream(InputFacade in, String boundary) throws IOException {
            super(in.getInputStream());
            this.boundary = boundary;
            this.facade = in;
        }

        private void fill() throws IOException {
            if (this.eof) {
                return;
            }
            if (this.count > 0) {
                if (this.count - this.pos == 2) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                    this.count -= this.pos;
                    this.pos = 0;
                } else {
                    throw new IllegalStateException("should never happen");
                }
            }
            int read = 0;
            int maxRead = this.buf.length - this.boundary.length();
            while (this.count < maxRead) {
                read = this.facade.readLine(this.buf, this.count, this.buf.length - this.count);
                if (read == -1) {
                    throw new IOException("read is -1");
                }
                if (read >= this.boundary.length()) {
                    this.eof = true;
                    for (int i = 0; i < this.boundary.length(); ++i) {
                        if (this.boundary.charAt(i) == this.buf[this.count + i]) continue;
                        this.eof = false;
                        break;
                    }
                    if (this.eof) break;
                }
                this.count += read;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.count - this.pos <= 2) {
                this.fill();
                if (this.count - this.pos <= 2) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            if (len == 0) {
                return 0;
            }
            int avail = this.count - this.pos - 2;
            if (avail <= 0) {
                this.fill();
                avail = this.count - this.pos - 2;
                if (avail <= 0) {
                    return -1;
                }
            }
            int copy = Math.min(len, avail);
            System.arraycopy(this.buf, this.pos, b, off, copy);
            this.pos += copy;
            total += copy;
            while (total < len) {
                this.fill();
                avail = this.count - this.pos - 2;
                if (avail <= 0) {
                    return total;
                }
                copy = Math.min(len - total, avail);
                System.arraycopy(this.buf, this.pos, b, off + total, copy);
                this.pos += copy;
                total += copy;
            }
            return total;
        }

        @Override
        public int available() throws IOException {
            int avail = this.count - this.pos - 2 + this.in.available();
            return avail < 0 ? 0 : avail;
        }

        @Override
        public void close() throws IOException {
            if (!this.eof) {
                while (this.read(this.buf, 0, this.buf.length) != -1) {
                }
            }
        }
    }
}

