/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi.customizer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;

public final class InstructionsConverter {
    private static final String DELIMITER = ",";
    private static final String ALL_MARK = ".*";
    public static final Integer EXPORT_PACKAGE = 1;
    public static final Integer PRIVATE_PACKAGE = 2;

    public static Map<Integer, String> computeExportInstructions(Map<String, Boolean> items, Project project) {
        HashMap<Integer, String> instructionsMap = new HashMap<Integer, String>(2);
        StringBuilder exportIns = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Boolean> entry : items.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            if (!isFirst) {
                exportIns.append(DELIMITER);
            }
            exportIns.append(entry.getKey());
            isFirst = false;
        }
        instructionsMap.put(EXPORT_PACKAGE, exportIns.toString());
        Iterator baseNames = FileUtilities.getBasePackageNames((Project)project).iterator();
        StringBuilder privateIns = new StringBuilder();
        while (baseNames.hasNext()) {
            String baseName = (String)baseNames.next();
            privateIns.append(baseName);
            if (baseNames.hasNext()) {
                privateIns.append(".*,");
                continue;
            }
            privateIns.append(ALL_MARK);
        }
        String privateText = privateIns.toString();
        if (!privateText.equals("..*")) {
            instructionsMap.put(PRIVATE_PACKAGE, privateText);
        }
        return instructionsMap;
    }

    public static SortedMap<String, Boolean> computeExportList(Map<Integer, String> exportInstructions, Project project) {
        TreeMap<String, Boolean> pkgMap = new TreeMap<String, Boolean>();
        SortedSet pkgNames = FileUtilities.getPackageNames((Project)project);
        for (String name : pkgNames) {
            pkgMap.put(name, Boolean.FALSE);
        }
        String exportIns = exportInstructions.get(EXPORT_PACKAGE);
        if (exportIns != null) {
            StringTokenizer strTok = new StringTokenizer(exportIns, DELIMITER);
            while (strTok.hasMoreTokens()) {
                String cur = strTok.nextToken();
                pkgMap.remove(cur);
                pkgMap.put(cur, Boolean.TRUE);
            }
        }
        return pkgMap;
    }

    public static String computeEmbedInstruction(Map<String, Boolean> items) {
        return null;
    }

    public static Map<String, Boolean> computeEmbedList(String embedInstruction) {
        return null;
    }
}

