/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.jakarta.web.beans.api.model.CdiException;
import org.netbeans.modules.jakarta.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.jakarta.web.beans.api.model.Result;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.CDIPanel;
import org.netbeans.modules.jakarta.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaElement;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.jakarta.web.beans.navigation.actions.ModelActionStrategy;
import org.netbeans.modules.jakarta.web.beans.navigation.actions.WebBeansActionHelper;

public class BindingsPanel
extends CDIPanel {
    private static final long serialVersionUID = 1230555367053797509L;
    static final String NON_BINDING_MEMBER_ANNOTATION = "jakarta.enterprise.inject.NonBinding";
    static final String DEFAULT = "Default";
    static final String DEFAULT_QUALIFIER_ANNOTATION = "jakarta.enterprise.inject.Default";
    private StringBuilder myFqnElementName;
    private StringBuilder myShortElementName;
    private String myFqnBindings;
    private String myShortBindings;
    private MetadataModel<WebBeansModel> myModel;
    private Result myResult;

    public BindingsPanel(final Object[] subject, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, JavaHierarchyModel treeModel, Result result) {
        super(treeModel);
        this.myModel = metaModel;
        this.myResult = result;
        this.setVisibleScope(result instanceof DependencyInjectionResult.ResolutionResult);
        this.setVisibleStereotypes(result != null);
        if (model == null) {
            try {
                metaModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                    public Void run(WebBeansModel model) throws Exception {
                        BindingsPanel.this.initCDIContext(subject, model);
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                Logger.getLogger(CDIPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                Logger.getLogger(CDIPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            this.initCDIContext(subject, model);
        }
    }

    BindingsPanel(Object[] subject, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, JavaHierarchyModel treeModel) {
        this(subject, metaModel, model, treeModel, null);
    }

    protected void setVisibleScope(boolean visible) {
        this.getScopeComponent().setVisible(visible);
        this.getScopeLabel().setVisible(visible);
    }

    protected void setVisibleStereotypes(boolean visible) {
        this.getStereotypeLabel().setVisible(visible);
        this.getStereotypesComponent().setVisible(visible);
    }

    protected void setContextElement(Element context, CompilationController controller) {
        TypeMirror typeMirror = context.asType();
        this.setContextType(typeMirror, controller);
    }

    protected void setContextType(TypeMirror typeMirror, CompilationController controller) {
        BindingsPanel.fillElementType(typeMirror, this.myShortElementName, this.myFqnElementName, controller);
    }

    protected Element getSelectedQualifiedElement(Element context, WebBeansModel model) {
        return context;
    }

    protected Element getSubjectElement(Element context, WebBeansModel model) {
        return context;
    }

    @Override
    protected void showSelectedCDI() {
        Object node;
        this.getSelectedBindingsComponent().setToolTipText(null);
        TreePath treePath = this.getJavaTree().getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof InjectableTreeNode) {
            final ElementHandle elementHandle = ((InjectableTreeNode)node).getElementHandle();
            try {
                this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                    public Void run(WebBeansModel model) throws Exception {
                        BindingsPanel.this.doShowSelectedCDI(elementHandle, model);
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                Logger.getLogger(CDIPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                Logger.getLogger(CDIPanel.class.getName()).log(Level.WARNING, e.getMessage(), e);
            }
            this.getSelectedBindingsComponent().setCaretPosition(0);
            this.getSelectedBindingsComponent().setToolTipText(((JavaElement)node).getTooltip());
        }
    }

    @Override
    protected void reloadSubjectElement() {
        if (this.showFqns()) {
            this.getInitialBindingsComponent().setText(this.getFqnBindings());
            this.getInitialElement().setText(this.getFqnElementName().toString());
        } else {
            this.getInitialBindingsComponent().setText(this.getShortBindings());
            this.getInitialElement().setText(this.getShortElementName().toString());
        }
    }

    protected StringBuilder getShortElementName() {
        return this.myShortElementName;
    }

    protected StringBuilder getFqnElementName() {
        return this.myFqnElementName;
    }

    protected String getFqnBindings() {
        return this.myFqnBindings;
    }

    protected String getShortBindings() {
        return this.myShortBindings;
    }

    protected void setFqnBindings(String bindings) {
        this.myFqnBindings = bindings;
    }

    protected void setShortBindings(String bindings) {
        this.myShortBindings = bindings;
    }

    protected void initBindings(WebBeansModel model, Element element) {
        List<AnnotationMirror> qualifiers = model.getQualifiers(element, true);
        StringBuilder fqnBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        if (model.hasImplicitDefaultQualifier(element)) {
            fqnBuilder.append('@');
            builder.append('@');
            fqnBuilder.append(DEFAULT_QUALIFIER_ANNOTATION);
            builder.append(DEFAULT);
            fqnBuilder.append(", ");
            builder.append(", ");
        }
        for (AnnotationMirror annotationMirror : qualifiers) {
            this.appendAnnotationMirror(annotationMirror, fqnBuilder, true);
            this.appendAnnotationMirror(annotationMirror, builder, false);
        }
        if (fqnBuilder.length() > 0) {
            this.myFqnBindings = fqnBuilder.substring(0, fqnBuilder.length() - 2);
            this.myShortBindings = builder.substring(0, builder.length() - 2);
        } else {
            this.myFqnBindings = "";
            this.myShortBindings = "";
        }
        if (this.showFqns()) {
            this.getInitialBindingsComponent().setText(this.myFqnBindings);
        } else {
            this.getInitialBindingsComponent().setText(this.myShortBindings);
        }
    }

    protected void appendAnnotationMirror(AnnotationMirror mirror, StringBuilder builder, boolean isFqn) {
        DeclaredType type = mirror.getAnnotationType();
        Element annotation = type.asElement();
        builder.append('@');
        String annotationName = isFqn ? (annotation instanceof TypeElement ? ((TypeElement)annotation).getQualifiedName().toString() : annotation.getSimpleName().toString()) : annotation.getSimpleName().toString();
        builder.append(annotationName);
        this.appendBindingParamters(mirror, builder);
        builder.append(", ");
    }

    protected void doShowSelectedCDI(ElementHandle<?> elementHandle, WebBeansModel model) throws CdiException {
        Element element = elementHandle.resolve((CompilationInfo)model.getCompilationController());
        if (element == null) {
            this.getSelectedBindingsComponent().setText("");
        } else {
            element = this.getSelectedQualifiedElement(element, model);
            List<AnnotationMirror> bindings = model.getQualifiers(element, true);
            StringBuilder builder = new StringBuilder();
            if (model.hasImplicitDefaultQualifier(element)) {
                builder.append('@');
                if (this.showFqns()) {
                    builder.append(DEFAULT_QUALIFIER_ANNOTATION);
                } else {
                    builder.append(DEFAULT);
                }
                builder.append(", ");
            }
            for (AnnotationMirror annotationMirror : bindings) {
                this.appendAnnotationMirror(annotationMirror, builder, this.showFqns());
            }
            String bindingsString = "";
            if (builder.length() > 0) {
                bindingsString = builder.substring(0, builder.length() - 2);
            }
            this.getSelectedBindingsComponent().setText(bindingsString);
            this.setScope(model, element);
            this.setStereotypes(model, element);
        }
    }

    protected void setStereotypes(WebBeansModel model, Element element) throws CdiException {
        if (this.getResult() != null) {
            List<AnnotationMirror> stereotypes = this.getResult().getAllStereotypes(element);
            if (stereotypes.isEmpty()) {
                this.getStereotypesComponent().setText("");
                return;
            }
            StringBuilder text = new StringBuilder();
            boolean isFqn = this.showFqns();
            for (AnnotationMirror stereotype : stereotypes) {
                this.appendAnnotationMirror(stereotype, text, isFqn);
            }
            this.getStereotypesComponent().setText(text.substring(0, text.length() - 2));
        }
    }

    protected void setScope(WebBeansModel model, Element element) throws CdiException {
        if (this.getResult() instanceof DependencyInjectionResult.ResolutionResult) {
            String scope = model.getScope(element);
            if (scope == null) {
                return;
            }
            String text = "";
            if (this.showFqns()) {
                text = "@" + scope;
            } else {
                Element scopeElement;
                TypeMirror scopeType = model.resolveType(scope);
                if (scopeType != null && (scopeElement = model.getCompilationController().getTypes().asElement(scopeType)) instanceof TypeElement) {
                    Name name = ((TypeElement)scopeElement).getSimpleName();
                    text = "@" + name.toString();
                }
            }
            this.getScopeComponent().setText(text);
        }
    }

    private void initCDIContext(Object[] subject, WebBeansModel model) {
        Element element = null;
        element = subject[2] == ModelActionStrategy.InspectActionId.INJECTABLES_CONTEXT ? WebBeansActionHelper.findVariable(model, subject) : ((ElementHandle)subject[0]).resolve((CompilationInfo)model.getCompilationController());
        Element context = this.getSubjectElement(element, model);
        if (context == null) {
            return;
        }
        this.myShortElementName = new StringBuilder();
        this.myFqnElementName = new StringBuilder();
        this.setContextElement(context, model.getCompilationController());
        this.initBindings(model, context);
        this.reloadSubjectElement();
    }

    private void appendBindingParamters(AnnotationMirror mirror, StringBuilder builder) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        StringBuilder params = new StringBuilder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement key = entry.getKey();
            AnnotationValue value = entry.getValue();
            List<? extends AnnotationMirror> annotationMirrors = key.getAnnotationMirrors();
            boolean nonBinding = false;
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                Element element = annotationType.asElement();
                if (!(element instanceof TypeElement) || !((TypeElement)element).getQualifiedName().contentEquals(NON_BINDING_MEMBER_ANNOTATION)) continue;
                nonBinding = true;
                break;
            }
            if (nonBinding) continue;
            params.append(key.getSimpleName().toString());
            params.append("=");
            if (value.getValue() instanceof String) {
                params.append('\"');
                params.append(value.getValue().toString());
                params.append('\"');
            } else {
                params.append(value.getValue().toString());
            }
            params.append(", ");
        }
        if (params.length() > 0) {
            builder.append("(");
            builder.append(params.substring(0, params.length() - 2));
            builder.append(")");
        }
    }

    private Result getResult() {
        return this.myResult;
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }

    static void fillElementType(TypeMirror typeMirror, StringBuilder shortName, StringBuilder fqnName, CompilationController controller) {
        Element element;
        if (typeMirror.getKind().isPrimitive()) {
            shortName.append(typeMirror.getKind().toString().toLowerCase());
            fqnName.append((CharSequence)shortName);
            return;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            BindingsPanel.fillArrayType(typeMirror, shortName, fqnName, controller);
            shortName = shortName.append("[]");
            fqnName = fqnName.append("[]");
        }
        if ((element = controller.getTypes().asElement(typeMirror)) != null) {
            fqnName.append(element instanceof TypeElement ? ((TypeElement)element).getQualifiedName().toString() : element.getSimpleName().toString());
            shortName.append(element.getSimpleName().toString());
        }
    }

    static void fillArrayType(TypeMirror typeMirror, StringBuilder shortName, StringBuilder fqnName, CompilationController controller) {
        TypeMirror componentType = ((ArrayType)typeMirror).getComponentType();
        BindingsPanel.fillElementType(componentType, shortName, fqnName, controller);
    }
}

