/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectConfigurations;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCompositeCategoryProvider;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.cookies.CloseCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JWSProjectPropertiesUtils {
    private static final String MASTER_NAME_APPLICATION = "master-application.jnlp";
    private static final String MASTER_NAME_APPLET = "master-applet.jnlp";
    private static final String MASTER_NAME_COMPONENT = "master-component.jnlp";
    private static final String PREVIEW_NAME_APPLICATION = "preview-application.html";
    private static final String PREVIEW_NAME_APPLET = "preview-applet.html";
    private static final String JWS_ANT_TASKS_LIB_NAME = "JWSAntTasks";
    private static final String BUILD_TEMPLATE = "Templates/JWS/jnlp-impl.xml";
    private static final String CURRENT_EXTENSION = "jws";
    private static final String[] OLD_EXTENSIONS = new String[0];
    private static final String JNLP_BUILD_IMPL_PATH = "nbproject/jnlp-impl.xml";
    private static final Logger LOG = Logger.getLogger(JWSProjectPropertiesUtils.class.getName());
    private static volatile String currentJnlpImplCRCCache;

    private JWSProjectPropertiesUtils() {
    }

    public static String getCurrentExtensionName() {
        return CURRENT_EXTENSION;
    }

    public static Iterable<? extends String> getOldExtensionNames() {
        return Arrays.asList(OLD_EXTENSIONS);
    }

    public static boolean copyJnlpImplTemplate(Project proj) throws IOException {
        boolean res = false;
        FileObject projDir = proj.getProjectDirectory();
        FileObject jnlpBuildFile = projDir.getFileObject(JNLP_BUILD_IMPL_PATH);
        if (jnlpBuildFile != null && !JWSProjectPropertiesUtils.isJnlpImplUpToDate(proj)) {
            FileObject nbproject;
            FileObject backupFile;
            DataObject dobj = DataObject.find((FileObject)jnlpBuildFile);
            CloseCookie closeCookie = (CloseCookie)dobj.getLookup().lookup(CloseCookie.class);
            if (closeCookie != null) {
                closeCookie.close();
            }
            if ((backupFile = (nbproject = projDir.getFileObject("nbproject")).getFileObject("jnlp-impl_backup", "xml")) != null) {
                backupFile.delete();
            }
            FileUtil.moveFile((FileObject)jnlpBuildFile, (FileObject)nbproject, (String)"jnlp-impl_backup");
            jnlpBuildFile = null;
        }
        if (jnlpBuildFile == null) {
            FileObject templateFO = FileUtil.getConfigFile((String)BUILD_TEMPLATE);
            if (templateFO != null) {
                FileUtil.copyFile((FileObject)templateFO, (FileObject)projDir.getFileObject("nbproject"), (String)"jnlp-impl");
            }
            res = true;
        }
        return res;
    }

    public static boolean isJnlpImplUpToDate(Project prj) {
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        FileObject jnlpImlpFO = prj.getProjectDirectory().getFileObject(JNLP_BUILD_IMPL_PATH);
        if (jnlpImlpFO == null) {
            return false;
        }
        try {
            String _currentJnlpImplCRC = currentJnlpImplCRCCache;
            if (_currentJnlpImplCRC == null) {
                FileObject template = FileUtil.getConfigFile((String)BUILD_TEMPLATE);
                currentJnlpImplCRCCache = _currentJnlpImplCRC = JWSProjectPropertiesUtils.computeCrc32(template);
            }
            return _currentJnlpImplCRC.equals(JWSProjectPropertiesUtils.computeCrc32(jnlpImlpFO));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot read: nbproject/jnlp-impl.xml", ex);
            return false;
        }
    }

    public static boolean updateJnlpExtension(Project project) throws IOException {
        boolean changed = JWSProjectPropertiesUtils.copyJnlpImplTemplate(project);
        changed |= JWSProjectPropertiesUtils.modifyBuildXml(project);
        return changed |= JWSProjectPropertiesUtils.copyJWSAntTasksLibrary(project);
    }

    static void updateJnlpExtensionAndSave(JWSProjectProperties props, Project project) {
        JWSProjectPropertiesUtils.updateMasterFiles(props, project);
        JWSProjectPropertiesUtils.savePropsAndUpdateMetaFiles(props, project);
    }

    private static void updateMasterFiles(JWSProjectProperties props, Project proj) {
        try {
            if (props.isJWSEnabled()) {
                FileObject masterFO;
                J2SEProjectConfigurations.createConfigurationFiles((Project)proj, (String)"JWS_generated", (EditableProperties)JWSProjectPropertiesUtils.prepareSharedProps(), null);
                FileObject projDirFO = proj.getProjectDirectory();
                JWSProjectProperties.DescType descType = props.getDescTypeProp();
                if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                    FileObject previewFO;
                    FileObject masterFO2 = projDirFO.getFileObject(MASTER_NAME_APPLICATION);
                    if (masterFO2 == null || !masterFO2.isValid()) {
                        JWSProjectPropertiesUtils.createMasterFile(projDirFO, MASTER_NAME_APPLICATION, descType);
                    }
                    if ((previewFO = projDirFO.getFileObject(PREVIEW_NAME_APPLICATION)) == null || !previewFO.isValid()) {
                        JWSProjectPropertiesUtils.createPreviewFile(projDirFO, PREVIEW_NAME_APPLICATION, descType);
                    }
                } else if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                    FileObject previewFO;
                    FileObject masterFO3 = projDirFO.getFileObject(MASTER_NAME_APPLET);
                    if (masterFO3 == null || !masterFO3.isValid()) {
                        JWSProjectPropertiesUtils.createMasterFile(projDirFO, MASTER_NAME_APPLET, descType);
                    }
                    if ((previewFO = projDirFO.getFileObject(PREVIEW_NAME_APPLET)) == null || !previewFO.isValid()) {
                        JWSProjectPropertiesUtils.createPreviewFile(projDirFO, PREVIEW_NAME_APPLET, descType);
                    }
                } else if (JWSProjectProperties.DescType.component.equals((Object)descType) && ((masterFO = projDirFO.getFileObject(MASTER_NAME_COMPONENT)) == null || !masterFO.isValid())) {
                    JWSProjectPropertiesUtils.createMasterFile(projDirFO, MASTER_NAME_COMPONENT, descType);
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private static EditableProperties prepareSharedProps() {
        EditableProperties props = new EditableProperties(true);
        props.setProperty("$label", NbBundle.getMessage(JWSCompositeCategoryProvider.class, (String)"LBL_Category_WebStart"));
        props.setProperty("$target.run", "jws-run");
        props.setProperty("$target.debug", "jws-debug");
        props.setProperty("compile.on.save.unsupported.javawebstart", "true");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createMasterFile(FileObject prjDir, String flName, JWSProjectProperties.DescType desc) throws IOException {
        FileObject masterFile = prjDir.createData(flName);
        FileLock lock = masterFile.lock();
        try {
            OutputStream os = masterFile.getOutputStream(lock);
            PrintWriter writer = new PrintWriter(os);
            writer.println("<jnlp spec=\"1.0+\" codebase=\"${jnlp.codebase}\" href=\"launch.jnlp\">");
            writer.println("    <information>");
            writer.println("        <title>${APPLICATION.TITLE}</title>");
            writer.println("        <vendor>${APPLICATION.VENDOR}</vendor>");
            writer.println("        <homepage href=\"${APPLICATION.HOMEPAGE}\"/>");
            writer.println("        <description>${APPLICATION.DESC}</description>");
            writer.println("        <description kind=\"short\">${APPLICATION.DESC.SHORT}</description>");
            writer.println("        <!--${JNLP.ICONS}-->");
            writer.println("        <!--${JNLP.OFFLINE.ALLOWED}-->");
            writer.println("    </information>");
            writer.println("    <!--${JNLP.UPDATE}-->");
            writer.println("    <!--${JNLP.SECURITY}-->");
            writer.println("    <resources>");
            writer.println("        <!--${JNLP.RESOURCES.RUNTIME}-->");
            writer.println("        <!--${JNLP.RESOURCES.MAIN.JAR}-->");
            writer.println("        <!--${JNLP.RESOURCES.JARS}-->");
            writer.println("        <!--${JNLP.RESOURCES.EXTENSIONS}-->");
            writer.println("    </resources>");
            if (desc.equals((Object)JWSProjectProperties.DescType.application)) {
                writer.println("    <application-desc main-class=\"${jnlp.main.class}\">");
                writer.println("        <!--${JNLP.APPLICATION.ARGS}-->");
                writer.println("    </application-desc>");
            } else if (desc.equals((Object)JWSProjectProperties.DescType.applet)) {
                writer.println("    <applet-desc main-class=\"${jnlp.main.class}\" name=\"${APPLICATION.TITLE}\"\n        width=\"${jnlp.applet.width}\" height=\"${jnlp.applet.height}\">");
                writer.println("        <!--${JNLP.APPLET.PARAMS}-->");
                writer.println("    </applet-desc>");
            } else if (desc.equals((Object)JWSProjectProperties.DescType.component)) {
                writer.println("    <component-desc/>");
            }
            writer.println("</jnlp>");
            writer.flush();
            writer.close();
            os.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPreviewFile(FileObject prjDir, String flName, JWSProjectProperties.DescType descType) throws IOException {
        FileObject previewFile = prjDir.createData(flName);
        FileLock lock = previewFile.lock();
        try {
            OutputStream os = previewFile.getOutputStream(lock);
            PrintWriter writer = new PrintWriter(os);
            writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                writer.println("<!-- ########################## IMPORTANT NOTE ############################ -->");
                writer.println("<!-- This preview HTML page will work only with JDK 6 update 10 and higher! -->");
                writer.println("<!-- ###################################################################### -->");
            }
            writer.println("<html>");
            writer.println("    <head>");
            if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                writer.println("        <title>Test page for launching the applet via JNLP</title>");
            } else if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                writer.println("        <title>Test page for launching the application via JNLP</title>");
            }
            writer.println("    </head>");
            writer.println("    <body>");
            if (JWSProjectProperties.DescType.applet.equals((Object)descType)) {
                writer.println("        <h3>Test page for launching the applet via JNLP</h3>");
                writer.println("        <script src=\"http://java.com/js/deployJava.js\"></script>");
                writer.println("        <script>");
                writer.println("            var attributes = {");
                writer.println("                code:       \"${JNLP.APPLET.CLASS}\",");
                writer.println("                archive:    \"${JNLP.RESOURCES.MAIN.JAR}\",");
                writer.println("                width:      ${JNLP.APPLET.WIDTH},");
                writer.println("                height:     ${JNLP.APPLET.HEIGHT}");
                writer.println("            };");
                writer.println("            var parameters = {${JNLP.APPLET.PARAMS}}; <!-- Applet Parameters -->");
                writer.println("            var version = \"${JNLP_VM_VERSION}\"; <!-- Required Java Version -->");
                writer.println("            deployJava.runApplet(attributes, parameters, version);");
                writer.println("        </script>");
                writer.println("        <!-- Or use the following applet element to launch the applet using jnlp_href -->");
                writer.println("        <!--");
                writer.println("        <applet width=\"${JNLP.APPLET.WIDTH}\" height=\"${JNLP.APPLET.HEIGHT}\">");
                writer.println("            <param name=\"jnlp_href\" value=\"${JNLP.FILE}\"/>");
                writer.println("        </applet>");
                writer.println("        -->");
            } else if (JWSProjectProperties.DescType.application.equals((Object)descType)) {
                writer.println("        <h3>Test page for launching the application via JNLP</h3>");
                writer.println("        <script src=\"http://java.com/js/deployJava.js\"></script>");
                writer.println("        <script>");
                writer.println("            deployJava.createWebStartLaunchButton(\"${JNLP.FILE}\")");
                writer.println("        </script>");
                writer.println("        <!-- Or use the following link element to launch with the application -->");
                writer.println("        <!--");
                writer.println("        <a href=\"${JNLP.FILE}\">Launch the application</a>");
                writer.println("        -->");
            }
            writer.println("    </body>");
            writer.println("</html>");
            writer.flush();
            writer.close();
            os.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePropsAndUpdateMetaFiles(JWSProjectProperties props, Project proj) {
        try {
            try {
                props.store();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            ProjectConfigurationProvider configProvider = (ProjectConfigurationProvider)proj.getLookup().lookup(ProjectConfigurationProvider.class);
            if (props.wasJWSActivated()) {
                JWSProjectPropertiesUtils.setActiveConfig(configProvider, NbBundle.getMessage(JWSCompositeCategoryProvider.class, (String)"LBL_Category_WebStart"));
                JWSProjectPropertiesUtils.copyJnlpImplTemplate(proj);
                boolean needsSave = JWSProjectPropertiesUtils.modifyBuildXml(proj);
                if (needsSave |= JWSProjectPropertiesUtils.copyJWSAntTasksLibrary(proj)) {
                    ProjectManager.getDefault().saveProject(proj);
                }
            } else if (props.wasJWSDeactivated()) {
                JWSProjectPropertiesUtils.setActiveConfig(configProvider, NbBundle.getMessage(JWSCompositeCategoryProvider.class, (String)"LBL_Category_Default"));
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            props.resetWebStartChanged();
        }
    }

    private static <C extends ProjectConfiguration> void setActiveConfig(final ProjectConfigurationProvider<C> provider, String displayName) throws IOException {
        Collection configs = provider.getConfigurations();
        for (final ProjectConfiguration c : configs) {
            if (!displayName.equals(c.getDisplayName())) continue;
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        provider.setActiveConfiguration(c);
                        return null;
                    }
                });
            }
            catch (MutexException mex) {
                throw (IOException)mex.getException();
            }
        }
    }

    private static boolean modifyBuildXml(Project proj) throws IOException {
        boolean res = false;
        FileObject projDir = proj.getProjectDirectory();
        final FileObject buildXmlFO = JWSProjectPropertiesUtils.getBuildXml(proj);
        if (buildXmlFO == null) {
            LOG.warning("The project build script does not exist, the project cannot be extended by JWS.");
            return res;
        }
        Document xmlDoc = null;
        try {
            xmlDoc = XMLUtil.parse((InputSource)new InputSource(buildXmlFO.toURL().toExternalForm()), (boolean)false, (boolean)true, null, null);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        FileObject jnlpBuildFile = projDir.getFileObject(JNLP_BUILD_IMPL_PATH);
        AntBuildExtender extender = (AntBuildExtender)proj.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            assert (jnlpBuildFile != null);
            if (extender.getExtension(CURRENT_EXTENSION) == null) {
                AntBuildExtender.Extension ext = extender.addExtension(CURRENT_EXTENSION, jnlpBuildFile);
                ext.addDependency("jar", "jnlp");
                ext.addDependency("-post-jar", "jnlp");
                res = true;
            }
        } else {
            LOG.log(Level.INFO, "Trying to include JWS build snippet in project type that doesn't support AntBuildExtender API contract.");
        }
        Element docElem = xmlDoc.getDocumentElement();
        NodeList nl = docElem.getElementsByTagName("target");
        Element target = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (e.getAttribute("name") == null || !"-post-jar".equals(e.getAttribute("name"))) continue;
            target = e;
            break;
        }
        boolean changed = false;
        if (target != null && target.getAttribute("depends") != null && target.getAttribute("depends").contains("jnlp")) {
            String old = target.getAttribute("depends");
            old = old.replaceAll("jnlp", "");
            old = old.replaceAll(",[\\s]*$", "");
            old = old.replaceAll("^[\\s]*,", "");
            old = old.replaceAll(",[\\s]*,", ",");
            if ((old = old.trim()).length() == 0) {
                target.removeAttribute("depends");
            } else {
                target.setAttribute("depends", old);
            }
            changed = true;
        }
        nl = docElem.getElementsByTagName("import");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            if (e.getAttribute("file") == null || !JNLP_BUILD_IMPL_PATH.equals(e.getAttribute("file"))) continue;
            e.getParentNode().removeChild(e);
            changed = true;
            break;
        }
        if (changed) {
            final Document fdoc = xmlDoc;
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        FileLock lock = buildXmlFO.lock();
                        try (OutputStream os = buildXmlFO.getOutputStream(lock);){
                            XMLUtil.write((Document)fdoc, (OutputStream)os, (String)"UTF-8");
                        }
                        finally {
                            lock.releaseLock();
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mex) {
                throw (IOException)mex.getException();
            }
        }
        return res;
    }

    private static boolean copyJWSAntTasksLibrary(Project proj) throws IOException {
        AntBuildExtender extender = (AntBuildExtender)proj.getLookup().lookup(AntBuildExtender.class);
        if (extender != null) {
            LibraryManager.getDefault();
            extender.addLibrary(LibraryManager.getDefault().getLibrary(JWS_ANT_TASKS_LIB_NAME));
            return true;
        }
        return false;
    }

    private static FileObject getBuildXml(Project prj) {
        J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        assert (j2sepe != null);
        PropertyEvaluator eval = j2sepe.evaluator();
        String buildScriptPath = eval.getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return prj.getProjectDirectory().getFileObject(buildScriptPath);
    }

    private static String computeCrc32(FileObject fo) throws IOException {
        CRC32 crc = new CRC32();
        try (BufferedInputStream in = new BufferedInputStream(fo.getInputStream());){
            int curr;
            int last = -1;
            while ((curr = ((InputStream)in).read()) != -1) {
                if (curr != 10 && last == 13) {
                    crc.update(10);
                }
                if (curr != 13) {
                    crc.update(curr);
                }
                last = curr;
            }
            if (last == 13) {
                crc.update(10);
            }
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }
}

