/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.ArrowFunctionScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ArrowFunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.LambdaFunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTErrorExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.openide.filesystems.FileObject;

class FunctionScopeImpl
extends ScopeImpl
implements FunctionScope,
VariableNameFactory {
    private static final Logger LOGGER = Logger.getLogger(FunctionScopeImpl.class.getName());
    private static final String TYPE_SEPARATOR_REGEXP = "\\|";
    private static final String TYPE_SEPARATOR_INTERSECTION_REGEXP = "\\&";
    private List<? extends ParameterElement> paremeters;
    private final boolean hasDeclaredReturnType;
    @NullAllowed
    private String returnType;
    @NullAllowed
    private final String declaredReturnType;
    private final boolean isReturnUnionType;
    private final boolean isReturnIntersectionType;
    private static Set<String> recursionDetection = new HashSet<String>();

    FunctionScopeImpl(Scope inScope, FunctionDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((FunctionDeclaration)info.getOriginalNode()).getBody(), isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
        this.hasDeclaredReturnType = !info.getReturnTypes().isEmpty();
        this.declaredReturnType = this.hasDeclaredReturnType ? CodeUtils.extractQualifiedName(((FunctionDeclaration)info.getOriginalNode()).getReturnType()) : null;
        this.isReturnUnionType = ((FunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof UnionType;
        this.isReturnIntersectionType = ((FunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof IntersectionType;
    }

    FunctionScopeImpl(Scope inScope, LambdaFunctionDeclarationInfo info) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((LambdaFunctionDeclaration)info.getOriginalNode()).getBody(), inScope.isDeprecated());
        this.paremeters = info.getParameters();
        this.isReturnUnionType = ((LambdaFunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof UnionType;
        this.isReturnIntersectionType = ((LambdaFunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof IntersectionType;
        boolean bl = this.hasDeclaredReturnType = ((LambdaFunctionDeclaration)info.getOriginalNode()).getReturnType() != null;
        if (this.hasDeclaredReturnType) {
            this.declaredReturnType = this.returnType = CodeUtils.extractQualifiedName(((LambdaFunctionDeclaration)info.getOriginalNode()).getReturnType());
        } else {
            this.returnType = null;
            this.declaredReturnType = null;
        }
    }

    FunctionScopeImpl(Scope inScope, ArrowFunctionDeclarationInfo info, Block block) {
        super(inScope, info, PhpModifiers.fromBitMask(1), block, inScope.isDeprecated());
        this.paremeters = info.getParameters();
        this.isReturnUnionType = ((ArrowFunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof UnionType;
        this.isReturnIntersectionType = ((ArrowFunctionDeclaration)info.getOriginalNode()).getReturnType() instanceof IntersectionType;
        boolean bl = this.hasDeclaredReturnType = ((ArrowFunctionDeclaration)info.getOriginalNode()).getReturnType() != null;
        if (this.hasDeclaredReturnType) {
            this.declaredReturnType = this.returnType = CodeUtils.extractQualifiedName(((ArrowFunctionDeclaration)info.getOriginalNode()).getReturnType());
        } else {
            this.returnType = null;
            this.declaredReturnType = null;
        }
    }

    protected FunctionScopeImpl(Scope inScope, MethodDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, info.getAccessModifiers(), ((MethodDeclaration)info.getOriginalNode()).getFunction().getBody(), isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
        this.hasDeclaredReturnType = ((MethodDeclaration)info.getOriginalNode()).getFunction().getReturnType() != null;
        this.declaredReturnType = this.hasDeclaredReturnType ? CodeUtils.extractQualifiedName(((MethodDeclaration)info.getOriginalNode()).getFunction().getReturnType()) : null;
        this.isReturnUnionType = ((MethodDeclaration)info.getOriginalNode()).getFunction().getReturnType() instanceof UnionType;
        this.isReturnIntersectionType = ((MethodDeclaration)info.getOriginalNode()).getFunction().getReturnType() instanceof IntersectionType;
    }

    protected FunctionScopeImpl(Scope inScope, MagicMethodDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, info.getAccessModifiers(), null, isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
        this.declaredReturnType = null;
        this.hasDeclaredReturnType = false;
        this.isReturnUnionType = false;
        this.isReturnIntersectionType = false;
    }

    FunctionScopeImpl(Scope inScope, BaseFunctionElement indexedFunction) {
        this(inScope, indexedFunction, PhpElementKind.FUNCTION);
    }

    protected FunctionScopeImpl(Scope inScope, BaseFunctionElement element, PhpElementKind kind) {
        super(inScope, element, kind);
        this.paremeters = element.getParameters();
        this.returnType = element.asString(BaseFunctionElement.PrintAs.ReturnSemiTypes);
        this.declaredReturnType = element.getDeclaredReturnType();
        this.hasDeclaredReturnType = StringUtils.hasText((String)this.declaredReturnType);
        this.isReturnUnionType = element.isReturnUnionType();
        this.isReturnIntersectionType = element.isReturnIntersectionType();
    }

    public static FunctionScopeImpl createElement(Scope scope, LambdaFunctionDeclaration node) {
        return new FunctionScopeImpl(scope, LambdaFunctionDeclarationInfo.create(node)){

            @Override
            public boolean isAnonymous() {
                return true;
            }
        };
    }

    public static FunctionScopeImpl createElement(Scope scope, ArrowFunctionDeclaration node) {
        Expression expression = node.getExpression();
        int startOffset = expression.getStartOffset();
        int endOffset = expression.getEndOffset();
        if (expression instanceof ASTErrorExpression) {
            endOffset += FunctionScopeImpl.getWhitespacesBehindASTErrorExpression(scope, endOffset);
        }
        Block block = new Block(startOffset, endOffset, Collections.emptyList(), false);
        return new ArrowFunctionScopeImpl(scope, ArrowFunctionDeclarationInfo.create(node), block);
    }

    private static int getWhitespacesBehindASTErrorExpression(Scope scope, int endOffset) {
        FileObject fileObject = scope.getFileObject();
        int wsCount = 0;
        if (fileObject != null) {
            int length;
            BaseDocument document = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
            Scope inScope = scope.getInScope();
            if (document != null && inScope != null && (length = inScope.getBlockRange().getEnd() - endOffset) > 0) {
                try {
                    char[] chars;
                    for (char c : chars = document.getChars(endOffset, length)) {
                        if (c != ' ' && c != '\t') break;
                        ++wsCount;
                    }
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, "Invalid offset: " + ex.offsetRequested(), ex);
                }
            }
        }
        return wsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReturnType(String type) {
        if (this.hasDeclaredReturnType) {
            return;
        }
        FunctionScopeImpl functionScopeImpl = this;
        synchronized (functionScopeImpl) {
            if (!StringUtils.hasText((String)this.returnType)) {
                this.returnType = type;
            } else {
                HashSet<String> distinctTypes = new HashSet<String>();
                distinctTypes.addAll(Arrays.asList(this.returnType.split(TYPE_SEPARATOR_REGEXP)));
                distinctTypes.add(type);
                this.returnType = Type.asUnionType(distinctTypes);
            }
        }
    }

    protected synchronized String getReturnType() {
        return this.returnType;
    }

    @Override
    @CheckForNull
    public String getDeclaredReturnType() {
        return this.declaredReturnType;
    }

    @Override
    public Collection<? extends TypeScope> getReturnTypes() {
        return this.getReturnTypesDescriptor(this.getReturnType(), false).getModifiedResult(Collections.emptyList());
    }

    @Override
    public synchronized Collection<? extends String> getReturnTypeNames() {
        List retval = Collections.emptyList();
        String type = this.getReturnType();
        if (type != null && type.length() > 0) {
            String[] typeNames;
            retval = new ArrayList();
            for (String typeName : typeNames = this.isReturnIntersectionType ? type.split(TYPE_SEPARATOR_INTERSECTION_REGEXP) : type.split(TYPE_SEPARATOR_REGEXP)) {
                if (VariousUtils.isSemiType(typeName)) continue;
                retval.add(typeName);
            }
        }
        return retval;
    }

    @Override
    public Collection<? extends TypeScope> getReturnTypes(boolean resolveSemiTypes, Collection<? extends TypeScope> callerTypes) {
        assert (callerTypes != null);
        String types = this.getReturnType();
        Scope inScope = this.getInScope();
        HashSet<? extends TypeScope> cTypes = new HashSet<TypeScope>();
        List<String> typeNames = Arrays.asList(Type.splitTypes(types));
        if (typeNames.contains("static") && inScope instanceof TypeScope) {
            TypeScope typeScope = (TypeScope)inScope;
            for (TypeScope typeScope2 : callerTypes) {
                if (typeScope2.isSubTypeOf(typeScope)) {
                    cTypes.add(typeScope2);
                    continue;
                }
                cTypes.add(typeScope);
            }
        } else {
            cTypes.addAll(callerTypes);
        }
        Collection<? extends TypeScope> result = this.getReturnTypesDescriptor(types, resolveSemiTypes, cTypes).getModifiedResult(cTypes);
        if (!this.hasDeclaredReturnType) {
            this.updateReturnTypes(types, result);
        }
        return result;
    }

    @Override
    public boolean isReturnUnionType() {
        return this.isReturnUnionType;
    }

    @Override
    public boolean isReturnIntersectionType() {
        return this.isReturnIntersectionType;
    }

    private ReturnTypesDescriptor getReturnTypesDescriptor(String types, boolean resolveSemiTypes) {
        return this.getReturnTypesDescriptor(types, resolveSemiTypes, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnTypesDescriptor getReturnTypesDescriptor(String types, boolean resolveSemiTypes, Collection<? extends TypeScope> callerTypes) {
        ReturnTypesDescriptor result = ReturnTypesDescriptor.NONE;
        if (StringUtils.hasText((String)types)) {
            Object[] typeNames = Type.splitTypes(types);
            HashSet<TypeScope> retval = new HashSet<TypeScope>();
            for (int i = 0; i < typeNames.length; ++i) {
                Object typeName = typeNames[i];
                if (CodeUtils.isNullableType((String)typeName)) {
                    typeName = ((String)typeName).substring(1);
                }
                if ("static".equals(typeName)) {
                    typeName = "\\" + (String)typeName;
                }
                if (FunctionScopeImpl.isSpecialTypeName((String)typeName)) {
                    typeNames[i] = typeName;
                    continue;
                }
                if (((String)typeName).trim().length() <= 0) continue;
                boolean bl = false;
                try {
                    bl = recursionDetection.add((String)typeName);
                    if (!bl || recursionDetection.size() >= 15) continue;
                    if (resolveSemiTypes && VariousUtils.isSemiType((String)typeName)) {
                        retval.addAll(VariousUtils.getType(this, (String)typeName, this.getLastValidMethodOffset(), false, callerTypes));
                        continue;
                    }
                    Object modifiedTypeName = typeName;
                    if (((String)typeName).indexOf("[") != -1) {
                        modifiedTypeName = ((String)typeName).replaceAll("\\[.*\\]", "");
                    }
                    retval.addAll(IndexScopeImpl.getTypes(QualifiedName.create((String)modifiedTypeName), this));
                    continue;
                }
                finally {
                    if (bl) {
                        recursionDetection.remove(typeName);
                    }
                }
            }
            Arrays.sort(typeNames);
            Scope inScope = this.getInScope();
            if (FunctionScopeImpl.canBeSelfDependent(inScope, (String[])typeNames)) {
                retval.add((TypeScope)inScope);
            }
            if (FunctionScopeImpl.canBeParentDependent(inScope, (String[])typeNames)) {
                if (inScope instanceof ClassScope) {
                    ClassScope classScope = (ClassScope)inScope;
                    classScope.getSuperClasses().forEach(superClass -> retval.add((TypeScope)superClass));
                } else if (inScope instanceof TraitScope) {
                    for (TypeScope typeScope : callerTypes) {
                        ClassScope classScope;
                        if (!(typeScope instanceof ClassScope) || !(classScope = (ClassScope)typeScope).getTraits().contains((TraitScope)inScope)) continue;
                        classScope.getSuperClasses().forEach(superClass -> retval.add((TypeScope)superClass));
                    }
                }
            }
            result = FunctionScopeImpl.canBeCallerDependent(inScope, (String[])typeNames) ? new CallerDependentTypesDescriptor(retval) : new CommonTypesDescriptor(retval);
        }
        return result;
    }

    private static boolean canBeSelfDependent(Scope scope, String[] types) {
        if (scope instanceof ClassScope || scope instanceof InterfaceScope) {
            return FunctionScopeImpl.containsSelfDependentType(types);
        }
        return false;
    }

    private static boolean canBeParentDependent(Scope scope, String[] types) {
        if (scope instanceof ClassScope || scope instanceof TraitScope) {
            return FunctionScopeImpl.containsParentDependentType(types);
        }
        return false;
    }

    private static boolean canBeCallerDependent(Scope scope, String[] types) {
        if (scope instanceof TraitScope) {
            return FunctionScopeImpl.containsCallerDependentType(types) || FunctionScopeImpl.containsSelfDependentType(types);
        }
        return FunctionScopeImpl.containsCallerDependentType(types);
    }

    private int getLastValidMethodOffset() {
        int result = this.getOffset();
        List<? extends ModelElement> elements = ModelUtils.getElements(this, true);
        if (elements != null && !elements.isEmpty()) {
            elements.sort(new ModelElementsPositionComparator());
            result = elements.get(0).getNameRange().getEnd();
        }
        return result;
    }

    private static boolean containsCallerDependentType(String[] typeNames) {
        return Arrays.binarySearch(typeNames, "\\this") >= 0 || Arrays.binarySearch(typeNames, "\\static") >= 0;
    }

    private static boolean containsSelfDependentType(String[] typeNames) {
        return Arrays.binarySearch(typeNames, "\\self") >= 0 || Arrays.binarySearch(typeNames, "object") >= 0;
    }

    private static boolean containsParentDependentType(String[] typeNames) {
        return Arrays.binarySearch(typeNames, "\\parent") >= 0;
    }

    private static boolean isSpecialTypeName(String typeName) {
        return typeName.equals("\\this") || typeName.equals("\\static") || typeName.equals("\\self") || typeName.equals("\\parent") || typeName.equals("object");
    }

    private void updateReturnTypes(String oldTypes, Collection<? extends TypeScope> resolvedReturnTypes) {
        if (VariousUtils.isSemiType(oldTypes)) {
            this.updateSemiReturnTypes(oldTypes, resolvedReturnTypes);
        }
    }

    private void updateSemiReturnTypes(String oldTypes, Collection<? extends TypeScope> resolvedReturnTypes) {
        StringBuilder sb = new StringBuilder();
        for (TypeScope typeScope : resolvedReturnTypes) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append(typeScope.getNamespaceName().append(typeScope.getName()).toString());
        }
        this.updateReturnTypesIfNotChanged(oldTypes, sb.toString());
    }

    private synchronized void updateReturnTypesIfNotChanged(String oldTypes, String newTypes) {
        if (oldTypes.equals(this.getReturnType()) && StringUtils.hasText((String)newTypes)) {
            this.returnType = newTypes;
        }
    }

    @Override
    @NonNull
    public List<? extends String> getParameterNames() {
        assert (this.paremeters != null);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterElement parameterElement : this.paremeters) {
            parameterNames.add(parameterElement.getName());
        }
        return parameterNames;
    }

    @Override
    @NonNull
    public List<? extends ParameterElement> getParameters() {
        return Collections.unmodifiableList(this.paremeters);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append('(');
        List<? extends String> parameters = this.getParameterNames();
        for (int i = 0; i < parameters.size(); ++i) {
            String param = parameters.get(i);
            if (i > 0) {
                sb.append(',').append(' ');
            }
            sb.append(param);
        }
        sb.append(')');
        sb.append(':');
        boolean first = true;
        if (this.hasDeclaredReturnType) {
            sb.append(' ').append(this.getDeclaredReturnType());
        } else {
            Collection<? extends TypeScope> returnTypes = this.getReturnTypes();
            for (TypeScope typeScope : returnTypes) {
                if (first) {
                    first = false;
                    sb.append(' ');
                } else {
                    sb.append(Type.getTypeSeparator(this.isReturnIntersectionType));
                }
                sb.append(typeScope.getName());
            }
        }
        return sb.toString();
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return FunctionScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        indexDocument.addPair("base", this.getIndexSignature(), true, true);
        indexDocument.addPair("top", this.getName().toLowerCase(), true, true);
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        List<? extends ParameterElement> parameters = this.getParameters();
        for (int idx = 0; idx < parameters.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameters.get(idx);
            if (idx > 0) {
                sb.append(',');
            }
            sb.append(parameter.getSignature());
        }
        sb.append(';');
        String type = this.getReturnType();
        if (type != null) {
            sb.append(type);
        }
        sb.append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        assert (namespaceScope != null);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        sb.append(this.isReturnUnionType() ? 1 : 0).append(';');
        sb.append(this.isReturnIntersectionType() ? 1 : 0).append(';');
        sb.append(this.getDeclaredReturnType() != null ? this.getDeclaredReturnType() : "").append(';');
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof FunctionElement) {
            FunctionElement indexedFunction = (FunctionElement)this.indexedElement;
            return indexedFunction.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    private static interface ReturnTypesDescriptor {
        public static final ReturnTypesDescriptor NONE = new ReturnTypesDescriptor(){

            @Override
            public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
                return Collections.emptyList();
            }
        };

        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> var1);
    }

    private static final class CallerDependentTypesDescriptor
    implements ReturnTypesDescriptor {
        private final Collection<? extends TypeScope> rawTypes;

        public CallerDependentTypesDescriptor(Collection<? extends TypeScope> rawTypes) {
            assert (rawTypes != null);
            this.rawTypes = rawTypes;
        }

        @Override
        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
            assert (callerTypes != null);
            HashSet<? extends TypeScope> types = new HashSet<TypeScope>(this.rawTypes);
            types.addAll(callerTypes);
            return types;
        }
    }

    private static final class CommonTypesDescriptor
    implements ReturnTypesDescriptor {
        private final Collection<? extends TypeScope> rawTypes;

        public CommonTypesDescriptor(Collection<? extends TypeScope> rawTypes) {
            assert (rawTypes != null);
            this.rawTypes = rawTypes;
        }

        @Override
        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
            assert (callerTypes != null);
            return this.rawTypes;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class ModelElementsPositionComparator
    implements Comparator<ModelElement> {
        private ModelElementsPositionComparator() {
        }

        @Override
        public int compare(ModelElement o1, ModelElement o2) {
            int o2End;
            int o1End = o1.getNameRange().getEnd();
            if (o1End < (o2End = o2.getNameRange().getEnd())) {
                return 1;
            }
            if (o1End > o2End) {
                return -1;
            }
            return 0;
        }
    }
}

