/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import java.io.File;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.netbeans.modules.java.disco.AbstractWizardPanel;
import org.netbeans.modules.java.disco.DownloadPanel;
import org.netbeans.modules.java.disco.WizardState;
import org.openide.WizardDescriptor;

public class DownloadWizardPanel
extends AbstractWizardPanel<DownloadPanel> {
    private final WizardState state;

    DownloadWizardPanel(WizardState state) {
        this.state = state;
    }

    @Override
    @UIEffect
    protected DownloadPanel createComponent() {
        DownloadPanel component = DownloadPanel.create(this.state);
        component.addPropertyChangeListener("downloadFinished", e -> {
            if (component.getDownload().isFile()) {
                component.putClientProperty("WizardPanel_warningMessage", "Could not unarchive package, please install it manually");
            }
            this.fireChangeListeners();
        });
        return component;
    }

    public boolean isValid() {
        return ((DownloadPanel)this.getComponent()).isDownloadFinished();
    }

    @Override
    public void storeSettings(WizardDescriptor wiz) {
        File file = ((DownloadPanel)this.getComponent()).getDownload();
        if (file != null) {
            wiz.putProperty("download", (Object)file.getAbsolutePath());
        }
    }

    @Override
    public void readSettings(WizardDescriptor wiz) {
        String folder = (String)wiz.getProperty("downloadFolder");
        ((DownloadPanel)this.getComponent()).setDownloadFolder(folder);
    }
}

