/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;

public final class FxClassUtils {
    public static final String NAME_VALUE_OF = "valueOf";
    private static final String DEFAULT_PROPERTY_TYPE_NAME = "javafx.beans.DefaultProperty";
    private static final String DEFAULT_PROPERTY_VALUE_NAME = "value";
    private static final String FXML_ANNOTATION_TYPE = "javafx.fxml.FXML";
    private static final String FX_COLOR_CLASS = "javafx.scene.paint.Color";
    private static final String FX_PAINT_CLASS = "javafx.scene.paint.Paint";
    private static final String JL_STRING_CLASS = "java.lang.String";

    public static String getDefaultProperty(TypeElement te) {
        for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(DEFAULT_PROPERTY_TYPE_NAME)) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> m = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> en : m.entrySet()) {
                if (!en.getKey().getSimpleName().contentEquals(DEFAULT_PROPERTY_VALUE_NAME)) continue;
                Object v = en.getValue().getValue();
                return v == null ? null : v.toString();
            }
        }
        return null;
    }

    public static boolean isFxmlAccessible(Element el) {
        return el.getModifiers().contains((Object)Modifier.PUBLIC) || FxClassUtils.isFxmlAnnotated(el);
    }

    public static boolean isFxmlAnnotated(Element el) {
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(FXML_ANNOTATION_TYPE)) continue;
            return true;
        }
        return false;
    }

    public static ExecutableElement findValueOf(TypeElement te, CompilationInfo ci) {
        TypeElement stringType = ci.getElements().getTypeElement(JL_STRING_CLASS);
        List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
        for (ExecutableElement e : methods) {
            List<? extends VariableElement> params;
            if (!e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC) && !FxClassUtils.isFxmlAnnotated(e) || !e.getSimpleName().toString().equals(NAME_VALUE_OF) || !ci.getTypes().isSameType(e.getReturnType(), te.asType()) || (params = e.getParameters()).size() != 1) continue;
            VariableElement v = params.get(0);
            TypeMirror vType = v.asType();
            if (!ci.getTypes().isSameType(vType, stringType.asType())) continue;
            return e;
        }
        return null;
    }

    public static boolean isSimpleType(TypeMirror t, CompilationInfo ci) {
        if (FxClassUtils.isPrimitive(t)) {
            return true;
        }
        if (t.getKind() == TypeKind.DECLARED) {
            TypeElement tel = (TypeElement)ci.getTypes().asElement(t);
            if (FxClassUtils.findValueOf(tel, ci) != null) {
                return true;
            }
            String qn = tel.getQualifiedName().toString();
            if (FX_COLOR_CLASS.equals(qn) || FX_PAINT_CLASS.equals(qn) || JL_STRING_CLASS.equals(qn)) {
                return true;
            }
        }
        if (t.getKind() == TypeKind.ARRAY) {
            TypeMirror component = ((ArrayType)t).getComponentType();
            if (component.getKind() == TypeKind.ARRAY) {
                return false;
            }
            return FxClassUtils.isSimpleType(component, ci);
        }
        return false;
    }

    public static boolean isPrimitive(TypeMirror t) {
        switch (t.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }
}

