/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.PopupMenuUI;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.actions.PropertyAction;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.menu.DragOperation;
import org.netbeans.modules.form.menu.DropTargetLayer;
import org.netbeans.modules.form.menu.KeyboardMenuNavigator;
import org.netbeans.modules.form.menu.VisualDesignerJPanelPopup;
import org.netbeans.modules.form.menu.VisualDesignerPopupFactory;
import org.netbeans.modules.form.menu.VisualDesignerPopupMenuUI;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

public class MenuEditLayer
extends JPanel {
    public static final Border DRAG_MENU_BORDER = BorderFactory.createLineBorder(Color.BLACK, 1);
    public static final Border DRAG_SEPARATOR_BORDER = BorderFactory.createLineBorder(Color.RED, 1);
    public static final Color SELECTED_MENU_BACKGROUND = new Color(10856105);
    public static final Color EMPTY_ICON_COLOR = new Color(0xDDDDDD);
    public static final int EMPTY_ICON_BORDER_WIDTH = 2;
    private static final boolean USE_NEW_ITEM_COLOR_SWITCHING = false;
    VisualDesignerPopupFactory hackedPopupFactory = null;
    FormDesigner formDesigner;
    JLayeredPane layers;
    JComponent glassLayer;
    DropTargetLayer dropTargetLayer;
    boolean showMenubarWarning = false;
    private Map<JMenu, PopupMenuUI> menuPopupUIMap;
    private SelectedPortion selectedPortion = SelectedPortion.None;
    private KeyboardMenuNavigator keyboardMenuNavigator;
    private Map<RADVisualContainer, FormModelListener> formModelListeners;
    private DragOperation dragop;
    private FormModelListener menuBarFormListener;
    private PropertyChangeListener selectionListener;
    private boolean isAlive = true;
    private static final boolean USE_JSEPARATOR_FIX = true;
    PropertyChangeListener paletteListener = null;
    FileObject paletteContext = null;
    static final int ACCEL_PREVIEW_WIDTH = 80;
    private static final Border accel_border = new Border(){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.WHITE);
            int offset = 5;
            if (DropTargetLayer.isAqua()) {
                offset = 2;
            }
            int ioffset = 0;
            if (DropTargetLayer.isVista()) {
                ioffset = -2;
            }
            g.fillRect(width - 80 + offset, 1, 80 + ioffset, height + ioffset);
            g.setColor(EMPTY_ICON_COLOR);
            g.drawRect(width - 80 + offset, 1, 79 + ioffset, height + ioffset);
            g.drawRect(width - 80 + offset + 1, 2, 77 + ioffset, height - 2 + ioffset);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(new Font("SansSerif", 0, 10));
            String shortcut = NbBundle.getMessage(MenuEditLayer.class, (String)"MENU_Shortcut");
            g.drawString(shortcut, width - 80 + 15, height - 3 + ioffset);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 0, 80);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    };
    private List<RADComponent> selectedComponents = new ArrayList<RADComponent>();
    private Map<JComponent, Color> backgroundMap = new HashMap<JComponent, Color>();
    private JComponent prevRollover = null;
    private boolean dragProxying = false;

    public MenuEditLayer(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
        this.menuPopupUIMap = new HashMap<JMenu, PopupMenuUI>();
        this.formModelListeners = new HashMap<RADVisualContainer, FormModelListener>();
        this.layers = new JLayeredPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.layers, "Center");
        this.dragop = new DragOperation(this);
        this.glassLayer = new JComponent(){

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.layers.add((Component)this.glassLayer, new Integer(500));
        this.glassLayer.setSize(400, 400);
        this.dropTargetLayer = new DropTargetLayer(this);
        this.layers.add((Component)this.dropTargetLayer, new Integer(JLayeredPane.DRAG_LAYER - 5));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MenuEditLayer.this.glassLayer.setSize(MenuEditLayer.this.getSize());
                MenuEditLayer.this.dropTargetLayer.setSize(MenuEditLayer.this.getSize());
            }
        });
        GlassLayerMouseListener mia = new GlassLayerMouseListener();
        this.glassLayer.addMouseListener(mia);
        this.glassLayer.addMouseMotionListener(mia);
        this.glassLayer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    MenuEditLayer.this.dragop.fastEnd();
                }
            }
        });
        this.configureSelectionListener();
    }

    DragOperation getDragOperation() {
        return this.dragop;
    }

    public static boolean isMenuRelatedRADComponent(RADComponent comp) {
        if (comp == null) {
            return false;
        }
        return MenuEditLayer.isMenuRelatedComponentClass(comp.getBeanClass());
    }

    public static boolean isNonMenuJSeparator(RADComponent comp) {
        if (comp == null) {
            return false;
        }
        if (JSeparator.class.isAssignableFrom(comp.getBeanClass())) {
            RADComponent parent = comp.getParentComponent();
            return parent == null || !JMenu.class.isAssignableFrom(parent.getBeanClass());
        }
        return false;
    }

    public static boolean isMenuBarContainer(RADComponent comp) {
        if (comp == null) {
            return false;
        }
        Class<? extends Object> clas = comp.getBeanClass();
        if (clas == null) {
            return false;
        }
        return JMenuBar.class.isAssignableFrom(clas);
    }

    public static boolean isMenuRelatedContainer(RADComponent comp) {
        if (comp == null) {
            return false;
        }
        Class<? extends Object> clas = comp.getBeanClass();
        if (clas == null) {
            return false;
        }
        if (JMenu.class.isAssignableFrom(clas)) {
            return true;
        }
        return JPopupMenu.class.isAssignableFrom(clas);
    }

    public static boolean isMenuRelatedComponentClass(Class clas) {
        if (clas == null) {
            return false;
        }
        if (JMenuItem.class.isAssignableFrom(clas)) {
            return true;
        }
        if (JMenu.class.isAssignableFrom(clas)) {
            return true;
        }
        if (JSeparator.class.isAssignableFrom(clas)) {
            return true;
        }
        return JMenuBar.class.isAssignableFrom(clas);
    }

    public boolean isPossibleNewMenuComponent(PaletteItem item) {
        if (item == null) {
            return false;
        }
        if (item.getComponentClass() == null) {
            return false;
        }
        return JMenuItem.class.isAssignableFrom(item.getComponentClass());
    }

    public void startNewMenuComponentPickAndPlop(PaletteItem item, Point pt) {
        this.setVisible(true);
        this.requestFocus();
        this.dragop = new DragOperation(this);
        this.dragop.start(item, pt);
    }

    public void startNewMenuComponentDragAndDrop(PaletteItem item) {
        this.setVisible(true);
        this.requestFocus();
        this.configureGlassLayer();
        this.configureFormListeners();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.dispose();
    }

    public void openAndShowMenu(RADComponent metacomp, Component comp) {
        if (this.hackedPopupFactory == null) {
            this.hackedPopupFactory = new VisualDesignerPopupFactory(this);
        }
        this.openMenu(metacomp, comp);
        this.glassLayer.requestFocusInWindow();
    }

    void openMenu(RADComponent metacomp, Component comp) {
        this.getPopupFactory();
        this.configureGlassLayer();
        this.registerKeyListeners();
        this.configureFormListeners();
        this.configureSelectionListener();
        JMenu menu = (JMenu)comp;
        this.configureMenu(null, menu);
        this.showMenuPopup(menu);
        if (metacomp instanceof RADVisualContainer) {
            this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)metacomp);
        }
    }

    public void hideMenuLayer() {
        this.unconfigureFormListeners();
        this.unconfigureSelectionListener();
        for (JMenu m : this.menuPopupUIMap.keySet()) {
            this.unconfigureMenu(m);
        }
        this.menuPopupUIMap.clear();
        if (this.hackedPopupFactory != null) {
            this.hackedPopupFactory.containerMap.clear();
            this.hackedPopupFactory = null;
        }
        if (this.dragop.isStarted()) {
            this.dragop.fastEnd();
        }
        this.setVisible(false);
        if (this.keyboardMenuNavigator != null) {
            this.glassLayer.removeKeyListener(this.keyboardMenuNavigator);
            this.keyboardMenuNavigator.unconfigure();
            this.keyboardMenuNavigator = null;
        }
        this.backgroundMap.clear();
        if (this.formDesigner.getHandleLayer() != null) {
            this.formDesigner.getHandleLayer().requestFocusInWindow();
        }
    }

    private synchronized void registerKeyListeners() {
        if (this.keyboardMenuNavigator == null) {
            this.keyboardMenuNavigator = new KeyboardMenuNavigator(this);
            this.glassLayer.addKeyListener(this.keyboardMenuNavigator);
        }
    }

    private VisualDesignerPopupFactory getPopupFactory() {
        if (this.hackedPopupFactory == null) {
            this.hackedPopupFactory = new VisualDesignerPopupFactory(this);
        }
        return this.hackedPopupFactory;
    }

    private void configureGlassLayer() {
        try {
            this.glassLayer.setDropTarget(new DropTarget());
            this.glassLayer.getDropTarget().addDropTargetListener(new GlassLayerDropTargetListener());
        }
        catch (TooManyListenersException ex) {
            ex.printStackTrace();
        }
    }

    private void configureFormListeners() {
        if (this.menuBarFormListener == null) {
            this.menuBarFormListener = new FormModelListener(){

                @Override
                public void formChanged(FormModelEvent[] events) {
                    if (events != null) {
                        for (FormModelEvent evt : events) {
                            if (evt.getChangeType() == 8 && evt.getComponent() != null && JMenuBar.class.isAssignableFrom(evt.getComponent().getBeanClass())) {
                                MenuEditLayer.this.hideMenuLayer();
                            }
                            if (evt.getChangeType() == 3) {
                                MenuEditLayer.this.hideMenuLayer();
                                MenuEditLayer.this.isAlive = false;
                            }
                            if (evt.getChangeType() == 7 && !evt.getCreatedDeleted()) continue;
                        }
                    }
                }
            };
            this.formDesigner.getFormModel().addFormModelListener(this.menuBarFormListener);
        }
        if (this.paletteListener == null) {
            this.paletteListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ((PaletteUtils.getSelectedItem() == null || !MenuEditLayer.isMenuRelatedComponentClass(PaletteUtils.getSelectedItem().getComponentClass())) && MenuEditLayer.this.dragop != null && MenuEditLayer.this.dragop.isStarted()) {
                        MenuEditLayer.this.dragop.fastEnd();
                    }
                }
            };
            this.paletteContext = this.formDesigner.getFormEditor().getFormDataObject().getFormFile();
            PaletteUtils.addPaletteListener(this.paletteListener, this.paletteContext);
        }
    }

    private void unconfigureFormListeners() {
        if (this.menuBarFormListener != null && this.formDesigner != null && this.formDesigner.getFormModel() != null) {
            this.formDesigner.getFormModel().removeFormModelListener(this.menuBarFormListener);
        }
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.paletteContext);
            this.paletteContext = null;
            this.paletteListener = null;
        }
        this.menuBarFormListener = null;
    }

    private void configureSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!MenuEditLayer.this.isAlive || !"selectedNodes".equals(evt.getPropertyName())) {
                        return;
                    }
                    Node[] newNodes = (Node[])evt.getNewValue();
                    ArrayList<RADComponent> selectedNodes = new ArrayList<RADComponent>();
                    for (Node n : newNodes) {
                        if (!(n instanceof RADComponentNode)) continue;
                        RADComponentNode radn = (RADComponentNode)n;
                        selectedNodes.add(radn.getRADComponent());
                    }
                    MenuEditLayer.this.setSelectedRADComponents(selectedNodes);
                }
            };
            this.formDesigner.addPropertyChangeListener(this.selectionListener);
        }
    }

    private void unconfigureSelectionListener() {
        if (this.selectionListener != null) {
            this.formDesigner.removePropertyChangeListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    void showMenuPopup(final JMenu menu) {
        this.getPopupFactory();
        if (this.hackedPopupFactory.containerMap.containsKey(menu)) {
            JPanel view = this.hackedPopupFactory.containerMap.get(menu);
            view.setVisible(true);
        } else {
            JPopupMenu popup;
            if (!this.isConfigured(menu)) {
                this.configureMenu(null, menu);
            }
            if (!((popup = menu.getPopupMenu()).getUI() instanceof VisualDesignerPopupMenuUI)) {
                popup.setUI(new VisualDesignerPopupMenuUI(this, popup.getUI()));
            }
            if (menu.isShowing()) {
                this.hackedPopupFactory.getPopup(menu, null, 0, 0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            popup.show(menu, 0, menu.getHeight());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
        this.validate();
    }

    public boolean isMenuLayerComponent(RADComponent metacomp) {
        if (metacomp == null) {
            return false;
        }
        if (metacomp.getBeanClass().equals(JMenuItem.class)) {
            return true;
        }
        return metacomp.getBeanClass().equals(JMenu.class);
    }

    void configureMenu(JComponent parent, JMenu menu) {
        menu.setBorderPainted(true);
        if (!MenuEditLayer.isTopLevelMenu(menu) && !(menu.getIcon() instanceof WrapperIcon)) {
            menu.setIcon(new WrapperIcon(menu.getIcon()));
        }
        JPopupMenu popup = menu.getPopupMenu();
        this.menuPopupUIMap.put(menu, popup.getUI());
        popup.setUI(new VisualDesignerPopupMenuUI(this, popup.getUI()));
        Component[] subComps = menu.getMenuComponents();
        JPanel popupPanel = this.getPopupFactory().containerMap.get(menu);
        if (popupPanel != null) {
            subComps = popupPanel.getComponents();
        }
        RADVisualContainer menuRAD = (RADVisualContainer)this.formDesigner.getMetaComponent(menu);
        this.registerForm(menuRAD, menu);
        for (Component c : subComps) {
            if (c instanceof JMenu) {
                this.configureMenu(menu, (JMenu)c);
                RADComponent rad = this.formDesigner.getMetaComponent(c);
                this.registerForm((RADVisualContainer)rad, (JMenu)c);
                continue;
            }
            this.configureMenuItem(menu, (JComponent)c);
        }
    }

    private void unconfigureMenu(JMenu menu) {
        VisualDesignerJPanelPopup pop;
        if (this.hackedPopupFactory == null) {
            return;
        }
        menu.getPopupMenu().setUI(this.menuPopupUIMap.get(menu));
        JPanel popup = this.hackedPopupFactory.containerMap.get(menu);
        if (popup != null) {
            for (Component c : popup.getComponents()) {
                if (c instanceof JMenu) {
                    this.unconfigureMenu((JMenu)c);
                    continue;
                }
                this.unconfigureMenuItem((JComponent)c);
            }
            if (menu.getPopupMenu() != null) {
                menu.getPopupMenu().setVisible(false);
            }
            popup.setVisible(false);
        }
        if ((pop = this.hackedPopupFactory.getPopup(menu)) != null) {
            pop.hide();
        }
        if (popup != null) {
            popup.setVisible(false);
        }
        menu.setPopupMenuVisible(false);
        this.hackedPopupFactory.containerMap.remove(menu);
    }

    private boolean isConfigured(JComponent c) {
        return this.menuPopupUIMap.containsKey(c);
    }

    void configureMenuItem(JMenu parent, JComponent c) {
        if (c instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)c;
            if (!(item.getIcon() instanceof WrapperIcon)) {
                item.setIcon(new WrapperIcon(item.getIcon()));
            }
            MenuEditLayer.installAcceleratorPreview(item);
            item.setBorderPainted(true);
        }
    }

    private static void installAcceleratorPreview(JMenuItem item) {
        CompoundBorder comp;
        if (item instanceof JMenu) {
            return;
        }
        boolean already_has_accel = false;
        if (item.getAccelerator() != null) {
            already_has_accel = true;
        }
        if (item.getAction() != null && item.getAction().getValue("AcceleratorKey") != null) {
            already_has_accel = true;
        }
        boolean already_has_accel_border = false;
        if (item.getBorder() == accel_border) {
            already_has_accel_border = true;
            if (already_has_accel) {
                item.setBorder(null);
                return;
            }
        }
        if (item.getBorder() instanceof CompoundBorder && (comp = (CompoundBorder)item.getBorder()).getInsideBorder() == accel_border) {
            already_has_accel_border = true;
            if (already_has_accel) {
                item.setBorder(comp.getOutsideBorder());
                return;
            }
        }
        if (already_has_accel_border) {
            return;
        }
        if (already_has_accel) {
            return;
        }
        if (item.getBorder() == null) {
            item.setBorder(accel_border);
            return;
        }
        item.setBorder(BorderFactory.createCompoundBorder(item.getBorder(), accel_border));
    }

    void unconfigureMenuItem(JComponent c) {
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    boolean isAncestor(JComponent target, JComponent parent) {
        if (!(parent instanceof JMenu)) {
            return false;
        }
        RADComponent targetRad = this.formDesigner.getMetaComponent(target);
        RADComponent parentRad = targetRad.getParentComponent();
        if (parentRad == null) {
            return false;
        }
        Object possibleParent = this.formDesigner.getComponent(parentRad);
        RADComponent realParentRad = this.formDesigner.getMetaComponent(parent);
        if (parentRad == realParentRad) {
            return true;
        }
        if (parent == possibleParent) {
            return true;
        }
        if (possibleParent instanceof JMenu) {
            return this.isAncestor((JMenu)possibleParent, parent);
        }
        return false;
    }

    boolean hasSelectedDescendants(JMenu menu) {
        RADComponent comp = this.formDesigner.getMetaComponent(menu);
        if (comp instanceof RADVisualContainer) {
            return this.hasSelectedDescendants((RADVisualContainer)comp);
        }
        return false;
    }

    boolean hasSelectedDescendants(RADVisualContainer comp) {
        if (this.selectedComponents.contains(comp)) {
            return true;
        }
        for (RADComponent c : comp.getSubBeans()) {
            boolean sel;
            if (this.selectedComponents.contains(c)) {
                return true;
            }
            if (!(c instanceof RADVisualContainer) || !(sel = this.hasSelectedDescendants((RADVisualContainer)c))) continue;
            return true;
        }
        return false;
    }

    JComponent getMenuParent(JComponent menu) {
        Object possibleParent;
        RADComponent targetRad = this.formDesigner.getMetaComponent(menu);
        RADComponent parentRad = targetRad.getParentComponent();
        if (parentRad != null && (possibleParent = this.formDesigner.getComponent(parentRad)) instanceof JComponent) {
            return (JComponent)possibleParent;
        }
        return null;
    }

    List<RADComponent> getSelectedRADComponents() {
        return Collections.unmodifiableList(this.selectedComponents);
    }

    RADComponent getSingleSelectedComponent() {
        if (this.selectedComponents.isEmpty()) {
            return null;
        }
        if (this.selectedComponents.size() > 1) {
            this.setSelectedRADComponent(this.selectedComponents.get(0));
        }
        return this.selectedComponents.get(0);
    }

    boolean isComponentSelected() {
        return !this.selectedComponents.isEmpty();
    }

    void setSelectedRADComponent(RADComponent comp) {
        ArrayList<RADComponent> comps = new ArrayList<RADComponent>();
        comps.add(comp);
        this.setSelectedRADComponents(comps);
        this.formDesigner.setSelectedComponent(comp);
    }

    void addSelectedRADComponent(RADComponent comp) {
        if (!this.selectedComponents.contains(comp)) {
            ArrayList<RADComponent> comps = new ArrayList<RADComponent>();
            comps.addAll(this.selectedComponents);
            comps.add(comp);
            this.setSelectedRADComponents(comps);
            this.formDesigner.addComponentToSelection(comp);
        }
    }

    void toggleSelectedRADComponent(RADComponent comp) {
        if (this.selectedComponents.contains(comp)) {
            this.selectedComponents.remove(comp);
            ArrayList<RADComponent> comps = new ArrayList<RADComponent>();
            comps.addAll(this.selectedComponents);
            this.setSelectedRADComponents(comps);
            this.formDesigner.removeComponentFromSelection(comp);
        } else {
            this.addSelectedRADComponent(comp);
        }
    }

    void setSelectedRADComponents(List<RADComponent> comps) {
        try {
            JComponent c;
            for (RADComponent rad : this.selectedComponents) {
                if (!MenuEditLayer.isMenuRelatedRADComponent(rad) || MenuEditLayer.isMenuBarContainer(rad) || MenuEditLayer.isNonMenuJSeparator(rad) || (c = (JComponent)this.formDesigner.getComponent(rad)) == null) continue;
                c.setBackground(this.getNormalBackground(rad, c));
            }
            this.selectedComponents.clear();
            this.selectedComponents.addAll(comps);
            for (RADComponent c2 : this.selectedComponents) {
                if (MenuEditLayer.isMenuRelatedRADComponent(c2) && !MenuEditLayer.isNonMenuJSeparator(c2)) continue;
                this.setVisible(false);
                return;
            }
            this.registerKeyListeners();
            for (RADComponent rad : this.selectedComponents) {
                c = (JComponent)this.formDesigner.getComponent(rad);
                if (c == null) continue;
                if (!MenuEditLayer.isMenuBarContainer(rad)) {
                    c.setBackground(this.getSelectedBackground(c));
                }
                this.makeSureShowingOnScreen(rad, c);
                if (!(c instanceof JMenu)) continue;
                this.showMenuPopup((JMenu)c);
            }
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getComponentDefaultsPrefix(JComponent c) {
        if (c instanceof JMenuBar) {
            return "MenuBar";
        }
        if (c instanceof JMenu) {
            return "Menu";
        }
        if (c instanceof JCheckBoxMenuItem) {
            return "CheckBoxMenuItem";
        }
        if (c instanceof JRadioButtonMenuItem) {
            return "RadioButtonMenuItem";
        }
        return "MenuItem";
    }

    private Color getNormalBackground(RADComponent metacomp, JComponent c) {
        RADProperty prop = metacomp.getBeanProperty("background");
        Color color = null;
        if (prop != null) {
            try {
                Object value = prop.getTargetValue();
                if (value instanceof Color) {
                    color = (Color)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (color == null) {
            color = this.backgroundMap.get(c);
        }
        return color;
    }

    private Color getSelectedBackground(JComponent c) {
        if (!this.backgroundMap.containsKey(c)) {
            this.backgroundMap.put(c, c.getBackground());
        }
        return SELECTED_MENU_BACKGROUND;
    }

    private Color getNormalForeground(JComponent c) {
        String prefix = this.getComponentDefaultsPrefix(c);
        Color color = UIManager.getDefaults().getColor(prefix + ".foreground");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    private void makeSureShowingOnScreen(RADComponent rad, JComponent comp) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.registerKeyListeners();
            if (rad instanceof RADVisualContainer) {
                this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)rad);
            } else {
                this.keyboardMenuNavigator.setCurrentMenuRAD((RADVisualContainer)rad.getParentComponent());
            }
        }
        ArrayList<RADComponent> path = new ArrayList<RADComponent>();
        RADComponent temp = rad.getParentComponent();
        while (temp != null) {
            path.add(temp);
            if (MenuEditLayer.isMenuRelatedRADComponent(temp = temp.getParentComponent())) continue;
        }
        for (int i = path.size() - 1; i >= 0; --i) {
            RADComponent r = (RADComponent)path.get(i);
            JComponent c = (JComponent)this.formDesigner.getComponent(r);
            if (!(c instanceof JMenu)) continue;
            this.showMenuPopup((JMenu)c);
        }
    }

    private void showContextMenu(Point popupPos) {
        Node[] selectedNodes = this.formDesigner.getSelectedNodes();
        JPopupMenu popup = NodeOp.findContextMenu((Node[])selectedNodes);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (popup != null) {
            popup.show(this, popupPos.x, popupPos.y);
        }
    }

    public boolean canHighlightContainer(RADVisualContainer targetContainer, RADVisualComponent tcomp) {
        Class<? extends Object> beanclass = tcomp.getBeanClass();
        return targetContainer != null && targetContainer.isMenuComponent() && targetContainer.canAddComponent(beanclass);
    }

    public void rolloverContainer(RADVisualContainer targetContainer) {
        if (targetContainer == null && this.prevRollover != null) {
            this.clearRollover();
        }
        if (targetContainer != null) {
            JComponent rollover = (JComponent)this.formDesigner.getComponent(targetContainer);
            if (rollover != this.prevRollover) {
                this.clearRollover();
            }
            this.prevRollover = rollover;
            this.prevRollover.setBorder(new Border(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setStroke(DropTargetLayer.DROP_TARGET_LINE_STROKE);
                    g2.setColor(DropTargetLayer.DROP_TARGET_COLOR);
                    g2.drawRect(x, y, width, height);
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(2, 2, 2, 2);
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }
            });
            this.prevRollover.repaint();
            if (rollover instanceof JMenu) {
                this.formDesigner.openMenu(targetContainer);
            }
        }
    }

    public void clearRollover() {
        if (this.prevRollover == null) {
            return;
        }
        this.prevRollover.setBorder(BorderFactory.createEmptyBorder());
        this.prevRollover.repaint();
        this.prevRollover = null;
    }

    void addRadComponentToBefore(JComponent target, MetaComponentCreator creator) {
        this.addRadComponentTo(target, 0, creator);
    }

    void addRadComponentToAfter(JComponent target, MetaComponentCreator creator) {
        this.addRadComponentTo(target, 1, creator);
    }

    private void addRadComponentTo(JComponent target, int offset, MetaComponentCreator creator) {
        try {
            JComponent targetParent = this.getMenuParent(target);
            if (target.getParent() instanceof JMenuBar) {
                targetParent = (JComponent)target.getParent();
            }
            RADVisualComponent targetRad = (RADVisualComponent)this.formDesigner.getMetaComponent(target);
            RADVisualContainer targetParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(targetParent);
            assert (targetParentRad != null);
            int index2 = targetParentRad.getIndexOf(targetRad) + offset;
            creator.addPrecreatedComponent(targetParentRad, new Integer(index2));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    boolean addRadComponentToEnd(JComponent targetComponent, MetaComponentCreator creator) {
        RADVisualContainer targetContainer = (RADVisualContainer)this.formDesigner.getMetaComponent(targetComponent);
        Object constraints = null;
        boolean added = creator.addPrecreatedComponent(targetContainer, constraints);
        return added;
    }

    void moveRadComponentInto(JComponent payload, JComponent targetMenu) {
        try {
            if (payload == targetMenu) {
                return;
            }
            if (this.isAncestor(targetMenu, payload)) {
                return;
            }
            JComponent payloadParent = this.getMenuParent(payload);
            if (payloadParent == null) {
                payloadParent = (JComponent)payload.getParent();
            }
            RADVisualComponent payloadRad = (RADVisualComponent)this.formDesigner.getMetaComponent(payload);
            RADVisualContainer payloadParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(payloadParent);
            if (payloadRad != null && payloadParentRad != null) {
                int index = payloadParentRad.getIndexOf(payloadRad);
                payloadParentRad.remove(payloadRad);
                this.formDesigner.getFormModel().fireComponentRemoved(payloadRad, payloadParentRad, index, false);
            }
            RADVisualContainer targetMenuRad = (RADVisualContainer)this.formDesigner.getMetaComponent(targetMenu);
            targetMenuRad.add(payloadRad, -1);
            targetMenuRad.getLayoutSupport().addComponents(new RADVisualComponent[]{payloadRad}, null, -1);
            this.formDesigner.getFormModel().fireComponentAdded(payloadRad, false);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    void moveRadComponentToBefore(JComponent payload, JComponent target) {
        this.moveRadComponentTo(payload, target, 0);
    }

    void moveRadComponentToAfter(JComponent payload, JComponent target) {
        this.moveRadComponentTo(payload, target, 1);
    }

    private void moveRadComponentTo(JComponent payload, JComponent target, int offset) {
        try {
            if (payload == target) {
                return;
            }
            if (this.isAncestor(target, payload)) {
                return;
            }
            JComponent payloadParent = this.getMenuParent(payload);
            JComponent targetParent = this.getMenuParent(target);
            if (targetParent == null) {
                targetParent = (JComponent)target.getParent();
            }
            RADVisualComponent payloadRad = (RADVisualComponent)this.formDesigner.getMetaComponent(payload);
            RADVisualComponent targetRad = (RADVisualComponent)this.formDesigner.getMetaComponent(target);
            RADVisualContainer payloadParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(payloadParent);
            RADVisualContainer targetParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(targetParent);
            if (payload instanceof JMenu && payload.getParent() instanceof JMenuBar && target instanceof JMenu && target.getParent() instanceof JMenuBar) {
                targetParent = (JComponent)target.getParent();
                payloadParent = (JComponent)payload.getParent();
                payloadParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(payloadParent);
                targetParentRad = (RADVisualContainer)this.formDesigner.getMetaComponent(targetParent);
            }
            if (payloadRad != null && payloadParentRad != null) {
                int index = payloadParentRad.getIndexOf(payloadRad);
                payloadParentRad.remove(payloadRad);
                this.formDesigner.getFormModel().fireComponentRemoved(payloadRad, payloadParentRad, index, false);
            }
            if (payloadRad != null && !JMenu.class.isAssignableFrom(payloadRad.getBeanClass()) && target instanceof JMenu && targetParent instanceof JMenuBar) {
                targetParent = null;
            }
            if (targetParent == null && target instanceof JMenu && target.getParent() instanceof JMenuBar) {
                targetParentRad = (RADVisualContainer)targetRad;
                targetParentRad.add(payloadRad, -1);
                targetParentRad.getLayoutSupport().addComponents(new RADVisualComponent[]{payloadRad}, null, -1);
                this.formDesigner.getFormModel().fireComponentAdded(payloadRad, false);
                return;
            }
            if (targetParentRad != null) {
                int index2 = targetParentRad.getIndexOf(targetRad) + offset;
                targetParentRad.add(payloadRad, index2);
                targetParentRad.getLayoutSupport().addComponents(new RADVisualComponent[]{payloadRad}, null, index2);
                this.formDesigner.getFormModel().fireComponentAdded(payloadRad, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean addComponentToEndOfMenu(RADComponent targetContainer, PaletteItem paletteItem) {
        FormModel model = targetContainer.getFormModel();
        MetaComponentCreator creator = model.getComponentCreator();
        return creator.createComponent(paletteItem, targetContainer, null) != null;
    }

    void configureNewComponent(RADComponent item) {
        JComponent c;
        if (item != null && (c = (JComponent)this.formDesigner.getComponent(item)) != null) {
            c.setForeground(Color.LIGHT_GRAY);
        }
    }

    private void configureEditedComponent(JComponent c) {
        if (c == null) {
            return;
        }
    }

    void configureEditedComponent(RADComponent c) {
        if (c != null) {
            this.configureEditedComponent((JComponent)this.formDesigner.getComponent(c));
        }
    }

    private void registerForm(final RADVisualContainer metacomp, final JMenu menu) {
        if (!this.formModelListeners.containsKey(metacomp)) {
            FormModelListener fml = new FormModelListener(){

                @Override
                public void formChanged(FormModelEvent[] events) {
                    if (events != null) {
                        for (FormModelEvent evt : events) {
                            JComponent comp;
                            if (evt.getChangeType() == 3) {
                                MenuEditLayer.this.formModelListeners.remove(metacomp);
                                metacomp.getFormModel().addFormModelListener(this);
                                continue;
                            }
                            if (evt.getChangeType() == 10 && "action".equals(evt.getPropertyName())) {
                                MenuEditLayer.this.configureEditedComponent(evt.getComponent());
                            }
                            if (evt.getChangeType() == 10 || evt.getChangeType() == 16) {
                                if (evt.getContainer() == metacomp || evt.getComponent() == metacomp) {
                                    MenuEditLayer.this.rebuildOnScreenMenu(metacomp);
                                }
                                MenuEditLayer.this.updateIcon(evt.getComponent());
                            }
                            if (evt.getChangeType() == 7) {
                                Component co;
                                MenuEditLayer.this.updateIcon(evt.getComponent());
                                if (evt.getComponent() != null && (co = (Component)MenuEditLayer.this.formDesigner.getComponent(evt.getComponent())) instanceof JMenuItem) {
                                    MenuEditLayer.installAcceleratorPreview((JMenuItem)co);
                                }
                            }
                            if (evt.getChangeType() == 8 && evt.getComponent() == metacomp) {
                                MenuEditLayer.this.unconfigureMenu(menu);
                                continue;
                            }
                            if (evt.getChangeType() != 7 && evt.getChangeType() != 9 && evt.getChangeType() != 8) continue;
                            if (evt.getContainer() == metacomp) {
                                MenuEditLayer.this.rebuildOnScreenMenu(metacomp);
                                return;
                            }
                            if (evt.getContainer() != MenuEditLayer.this.getFormMenuBar() || (comp = (JComponent)MenuEditLayer.this.formDesigner.getComponent(MenuEditLayer.this.getFormMenuBar())) == null) continue;
                            RADVisualContainer rad = (RADVisualContainer)MenuEditLayer.this.getFormMenuBar();
                            comp.removeAll();
                            for (RADVisualComponent c : rad.getSubComponents()) {
                                if (c == null) continue;
                                comp.add((JComponent)MenuEditLayer.this.formDesigner.getComponent(c));
                            }
                        }
                    }
                }
            };
            this.formModelListeners.put(metacomp, fml);
            metacomp.getFormModel().addFormModelListener(fml);
        }
    }

    private void rebuildOnScreenMenu(RADVisualContainer menuRAD) {
        if (menuRAD == null) {
            return;
        }
        if (this.hackedPopupFactory == null) {
            return;
        }
        JMenu menu = (JMenu)this.formDesigner.getComponent(menuRAD);
        if (this.hackedPopupFactory.containerMap.containsKey(menu)) {
            JPanel popupContainer = this.hackedPopupFactory.containerMap.get(menu);
            if (popupContainer == null) {
                return;
            }
            for (Component c : popupContainer.getComponents()) {
                if (c instanceof JMenu) {
                    this.unconfigureMenu((JMenu)c);
                    continue;
                }
                this.unconfigureMenuItem((JComponent)c);
            }
            popupContainer.removeAll();
            for (RADVisualComponent child : menuRAD.getSubComponents()) {
                if (child == null) continue;
                JComponent jchild = (JComponent)this.formDesigner.getComponent(child);
                if (!this.isConfigured(jchild)) {
                    if (jchild instanceof JMenu) {
                        this.configureMenu(menu, (JMenu)jchild);
                    } else {
                        this.configureMenuItem(menu, jchild);
                    }
                }
                popupContainer.add(jchild);
            }
            popupContainer.setSize(popupContainer.getLayout().preferredLayoutSize(popupContainer));
            this.validate();
            popupContainer.repaint();
        }
    }

    private void updateIcon(RADComponent rad) {
        try {
            Component comp = (Component)this.formDesigner.getComponent(rad);
            if (comp instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)comp;
                RADProperty icon_prop = rad.getBeanProperty("icon");
                Object value = icon_prop.getValue();
                Icon icon = null;
                if (value instanceof Icon) {
                    icon = (Icon)value;
                }
                if (value instanceof IconEditor.NbImageIcon) {
                    icon = ((IconEditor.NbImageIcon)value).getIcon();
                }
                if (value instanceof ResourceValue) {
                    ResourceValue rv = (ResourceValue)value;
                    Object designValue = rv.getDesignValue();
                    if (designValue instanceof Icon) {
                        icon = (Icon)designValue;
                    }
                    if (designValue instanceof IconEditor.NbImageIcon) {
                        icon = ((IconEditor.NbImageIcon)designValue).getIcon();
                    }
                }
                if (!(item.getIcon() instanceof WrapperIcon) && !MenuEditLayer.isTopLevelMenu(item)) {
                    item.setIcon(new WrapperIcon(item.getIcon()));
                }
                if (item.getIcon() instanceof WrapperIcon) {
                    ((WrapperIcon)item.getIcon()).setIcon(icon);
                } else {
                    item.setIcon(icon);
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public static boolean containsMenuTypeComponent(RADVisualComponent[] comps) {
        if (comps == null) {
            return false;
        }
        if (comps.length < 1) {
            return false;
        }
        for (RADVisualComponent c : comps) {
            if (JMenuItem.class.isAssignableFrom(c.getBeanClass())) {
                return true;
            }
            if (JMenuBar.class.isAssignableFrom(c.getBeanClass())) {
                return true;
            }
            if (!JMenu.class.isAssignableFrom(c.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMenuBar(RADVisualComponent[] comps) {
        if (comps == null) {
            return false;
        }
        if (comps.length < 1) {
            return false;
        }
        for (RADVisualComponent c : comps) {
            if (!JMenuBar.class.isAssignableFrom(c.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidMenuContainer(RADVisualContainer cont) {
        if (cont == null) {
            return false;
        }
        if (JMenuBar.class.isAssignableFrom(cont.getBeanClass())) {
            return true;
        }
        return JMenu.class.isAssignableFrom(cont.getBeanClass());
    }

    public static boolean isTopLevelMenu(JComponent comp) {
        if (comp == null) {
            return false;
        }
        return comp instanceof JMenu && comp.getParent() instanceof JMenuBar;
    }

    public boolean doesFormContainMenuBar() {
        for (RADComponent comp : this.formDesigner.getFormModel().getAllComponents()) {
            if (!JMenuBar.class.isAssignableFrom(comp.getBeanClass())) continue;
            return true;
        }
        return false;
    }

    public RADComponent getFormMenuBar() {
        for (RADComponent comp : this.formDesigner.getFormModel().getAllComponents()) {
            if (!JMenuBar.class.isAssignableFrom(comp.getBeanClass())) continue;
            return comp;
        }
        return null;
    }

    private boolean shouldRedispatchDnDToHandle(DropTargetDragEvent dtde) {
        RADComponent rad = this.formDesigner.getHandleLayer().getMetaComponentAt(dtde.getLocation(), 0);
        if (rad != null && MenuEditLayer.isMenuRelatedComponentClass(rad.getBeanClass())) {
            return false;
        }
        PaletteItem item = PaletteUtils.getSelectedItem();
        return item != null && JSeparator.class.isAssignableFrom(item.getComponentClass());
    }

    public SelectedPortion getCurrentSelectedPortion() {
        return this.selectedPortion;
    }

    public boolean isDragProxying() {
        return this.dragProxying;
    }

    public static enum SelectedPortion {
        Icon,
        Text,
        Accelerator,
        All,
        None;

    }

    private class GlassLayerMouseListener
    extends MouseInputAdapter {
        Point pressPoint = null;
        JComponent pressComp = null;
        private boolean isEditing = false;
        private Point prevLeftMousePoint;

        private GlassLayerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JMenuItem item;
            JComponent c;
            if (MenuEditLayer.this.dragop.isStarted() && MenuEditLayer.this.dragop.getTargetComponent() != null && MenuEditLayer.isMenuRelatedComponentClass(MenuEditLayer.this.dragop.getTargetComponent().getClass())) {
                if (e.isShiftDown()) {
                    MenuEditLayer.this.dragop.end(e, false);
                    PaletteItem item2 = PaletteUtils.getSelectedItem();
                    MenuEditLayer.this.dragop.start(item2, e.getPoint());
                } else {
                    MenuEditLayer.this.dragop.end(e, true);
                }
                return;
            }
            if (this.shouldRedispatchToHandle()) {
                MenuEditLayer.this.dragop.fastEnd();
                MenuEditLayer.this.formDesigner.getHandleLayer().dispatchEvent(e);
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    MenuEditLayer.this.dragop.fastEnd();
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    MenuEditLayer.this.dragop.end(e);
                }
                return;
            }
            RADComponent rad = MenuEditLayer.this.formDesigner.getHandleLayer().getMetaComponentAt(e.getPoint(), 0);
            if (rad != null) {
                JComponent c2;
                Object o = MenuEditLayer.this.formDesigner.getComponent(rad);
                JComponent jComponent = c2 = o instanceof JComponent ? (JComponent)o : null;
                if (c2 != null && MenuEditLayer.isTopLevelMenu(c2) && rad instanceof RADVisualComponent) {
                    if (e.getClickCount() > 1) {
                        this.isEditing = true;
                        MenuEditLayer.this.configureEditedComponent(c2);
                        MenuEditLayer.this.formDesigner.startInPlaceEditing(rad);
                    } else {
                        boolean modifier;
                        MenuEditLayer.this.openMenu(rad, c2);
                        MenuEditLayer.this.glassLayer.requestFocusInWindow();
                        if (DropTargetLayer.isMultiselectPressed(e)) {
                            if (e.isShiftDown()) {
                                MenuEditLayer.this.addSelectedRADComponent(rad);
                            } else if (e.isControlDown()) {
                                MenuEditLayer.this.toggleSelectedRADComponent(rad);
                            }
                        } else {
                            MenuEditLayer.this.setSelectedRADComponent(rad);
                        }
                        if (e.isPopupTrigger()) {
                            MenuEditLayer.this.showContextMenu(e.getPoint());
                            return;
                        }
                        boolean bl = modifier = e.isControlDown() || e.isAltDown() || e.isShiftDown();
                        if (this.prevLeftMousePoint != null && this.prevLeftMousePoint.distance(e.getPoint()) <= 3.0 && !modifier) {
                            this.isEditing = true;
                            MenuEditLayer.this.configureEditedComponent(c2);
                            MenuEditLayer.this.formDesigner.startInPlaceEditing(rad);
                        }
                        if (!MenuEditLayer.this.dragop.isStarted()) {
                            this.pressPoint = e.getPoint();
                            this.pressComp = c2;
                            return;
                        }
                    }
                    return;
                }
                if (c2 instanceof JMenuBar) {
                    MenuEditLayer.this.setSelectedRADComponent(rad);
                    if (e.isPopupTrigger()) {
                        MenuEditLayer.this.showContextMenu(e.getPoint());
                        return;
                    }
                    return;
                }
            }
            if ((c = MenuEditLayer.this.dragop.getDeepestComponentInPopups(e.getPoint())) == null && !MenuEditLayer.isMenuRelatedRADComponent(rad)) {
                PaletteUtils.clearPaletteSelection();
                MenuEditLayer.this.hideMenuLayer();
                MenuEditLayer.this.formDesigner.getHandleLayer().mousePressed(e);
                return;
            }
            if (e.getClickCount() > 1) {
                if (c instanceof JMenuItem) {
                    item = (JMenuItem)c;
                    Point pt = SwingUtilities.convertPoint(MenuEditLayer.this.glassLayer, e.getPoint(), item);
                    SelectedPortion portion = DropTargetLayer.calculateSelectedPortion(item, pt);
                    RADComponent radcomp = MenuEditLayer.this.formDesigner.getMetaComponent(item);
                    MenuEditLayer.this.configureEditedComponent(c);
                    if (portion == SelectedPortion.Icon) {
                        this.showIconEditor(radcomp);
                    } else if (portion == SelectedPortion.Accelerator) {
                        this.showAcceleratorEditor(radcomp);
                    } else {
                        RADComponentNode node = radcomp.getNodeReference();
                        if (node != null) {
                            Action action = node.getPreferredAction();
                            if (action != null) {
                                action.actionPerformed(new ActionEvent(node, 1001, ""));
                                this.prevLeftMousePoint = null;
                            } else {
                                this.isEditing = true;
                                MenuEditLayer.this.formDesigner.startInPlaceEditing(radcomp);
                            }
                        }
                    }
                }
            } else {
                if (c instanceof JMenu) {
                    MenuEditLayer.this.openMenu(rad, c);
                    MenuEditLayer.this.glassLayer.requestFocusInWindow();
                }
                if (c instanceof JMenuItem) {
                    RADComponent metacomp;
                    boolean modifier;
                    item = (JMenuItem)c;
                    boolean bl = modifier = e.isControlDown() || e.isAltDown() || e.isShiftDown();
                    if (this.prevLeftMousePoint != null && this.prevLeftMousePoint.distance(e.getPoint()) <= 3.0 && !modifier && (metacomp = MenuEditLayer.this.formDesigner.getMetaComponent(item)) != null) {
                        this.isEditing = true;
                        MenuEditLayer.this.formDesigner.startInPlaceEditing(metacomp);
                    }
                }
            }
            if (e.isPopupTrigger()) {
                MenuEditLayer.this.showContextMenu(e.getPoint());
                return;
            }
            if (!MenuEditLayer.this.dragop.isStarted() && c instanceof JMenuItem) {
                this.pressPoint = e.getPoint();
                this.pressComp = c;
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.prevLeftMousePoint = e.getPoint();
            }
            if (e.isPopupTrigger()) {
                MenuEditLayer.this.showContextMenu(e.getPoint());
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted() && !e.isShiftDown()) {
                MenuEditLayer.this.dragop.end(e);
            } else {
                JComponent c;
                if (!this.isEditing && (c = MenuEditLayer.this.dragop.getDeepestComponentInPopups(e.getPoint())) != null) {
                    if (c instanceof JMenuItem) {
                        Point localPt = SwingUtilities.convertPoint(MenuEditLayer.this.glassLayer, e.getPoint(), c);
                        MenuEditLayer.this.selectedPortion = DropTargetLayer.calculateSelectedPortion((JMenuItem)c, localPt);
                        MenuEditLayer.this.dropTargetLayer.repaint();
                    } else {
                        MenuEditLayer.this.selectedPortion = SelectedPortion.None;
                    }
                    MenuEditLayer.this.glassLayer.requestFocusInWindow();
                    RADComponent rad = MenuEditLayer.this.formDesigner.getMetaComponent(c);
                    if (DropTargetLayer.isMultiselectPressed(e)) {
                        if (e.isShiftDown()) {
                            MenuEditLayer.this.addSelectedRADComponent(rad);
                        } else if (e.isControlDown()) {
                            MenuEditLayer.this.toggleSelectedRADComponent(rad);
                        }
                    } else {
                        MenuEditLayer.this.setSelectedRADComponent(rad);
                    }
                }
                this.isEditing = false;
            }
        }

        private void showIconEditor(RADComponent comp) {
            try {
                RADProperty prop = comp.getBeanProperty("icon");
                new PropertyAction(prop).actionPerformed(null);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }

        private void showAcceleratorEditor(RADComponent comp) {
            try {
                RADProperty prop = comp.getBeanProperty("accelerator");
                new PropertyAction(prop).actionPerformed(null);
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (MenuEditLayer.this.showMenubarWarning) {
                MenuEditLayer.this.showMenubarWarning = false;
                MenuEditLayer.this.repaint();
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                if (PaletteUtils.getSelectedItem() == null && MenuEditLayer.this.dragop.isPickAndPlop()) {
                    MenuEditLayer.this.dragop.fastEnd();
                } else {
                    MenuEditLayer.this.dragop.setTargetVisible(true);
                }
            }
            if (!MenuEditLayer.this.dragop.isStarted() || PaletteUtils.getSelectedItem() != MenuEditLayer.this.dragop.getCurrentItem()) {
                PaletteItem item = PaletteUtils.getSelectedItem();
                if (item != null && !MenuEditLayer.isMenuRelatedComponentClass(item.getComponentClass())) {
                    MenuEditLayer.this.hideMenuLayer();
                    return;
                }
                if (MenuEditLayer.this.formDesigner.getDesignerMode() == 2 && item != null) {
                    if (JMenuBar.class.isAssignableFrom(item.getComponentClass())) {
                        MenuEditLayer.this.hideMenuLayer();
                        return;
                    }
                    MenuEditLayer.this.dragop.start(item, e.getPoint());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.setTargetVisible(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!MenuEditLayer.this.dragop.isStarted() && this.pressPoint != null && this.pressComp instanceof JMenuItem && e.getPoint().distance(this.pressPoint) > 10.0) {
                MenuEditLayer.this.dragop.start((JMenuItem)this.pressComp, e.getPoint());
                this.pressPoint = null;
                this.pressComp = null;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.move(e.getPoint());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.shouldRedispatchToHandle()) {
                MenuEditLayer.this.formDesigner.getHandleLayer().dispatchEvent(e);
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                if (!MenuEditLayer.this.doesFormContainMenuBar()) {
                    FormEditor.getAssistantModel(MenuEditLayer.this.formDesigner.getFormModel()).setContext("missingMenubar");
                }
                MenuEditLayer.this.dragop.move(e.getPoint());
            }
        }

        private boolean shouldRedispatchToHandle() {
            return MenuEditLayer.this.dragop.isStarted() && MenuEditLayer.this.dragop.isPickAndPlop() && MenuEditLayer.this.dragop.getDragComponent() instanceof JSeparator;
        }
    }

    private class GlassLayerDropTargetListener
    implements DropTargetListener {
        private GlassLayerDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (MenuEditLayer.this.shouldRedispatchDnDToHandle(dtde)) {
                MenuEditLayer.this.dragProxying = true;
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragEnter(dtde);
                return;
            }
            if (!MenuEditLayer.this.dragop.isStarted()) {
                this.start(dtde);
            }
        }

        private void start(DropTargetDragEvent dtde) {
            PaletteItem item = PaletteUtils.getSelectedItem();
            if (item != null && !MenuEditLayer.isMenuRelatedComponentClass(item.getComponentClass())) {
                MenuEditLayer.this.hideMenuLayer();
                return;
            }
            if (MenuEditLayer.this.formDesigner.getDesignerMode() == 2 && item != null) {
                if (JMenuBar.class.isAssignableFrom(item.getComponentClass())) {
                    MenuEditLayer.this.hideMenuLayer();
                    return;
                }
                MenuEditLayer.this.dragop.start(item, dtde.getLocation());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (MenuEditLayer.this.dragProxying && MenuEditLayer.this.shouldRedispatchDnDToHandle(dtde)) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragOver(dtde);
                return;
            }
            MenuEditLayer.this.dragProxying = false;
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.move(dtde.getLocation());
            } else {
                this.start(dtde);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            if (MenuEditLayer.this.dragProxying) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().dragExit(dte);
            }
            MenuEditLayer.this.dragProxying = false;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (MenuEditLayer.this.dragProxying) {
                MenuEditLayer.this.formDesigner.getHandleLayer().getNewComponentDropListener().drop(dtde);
                MenuEditLayer.this.dragProxying = false;
                return;
            }
            if (MenuEditLayer.this.dragop.isStarted()) {
                MenuEditLayer.this.dragop.end(dtde);
                MenuEditLayer.this.dragProxying = false;
                return;
            }
        }
    }

    static class WrapperIcon
    implements Icon {
        private Icon wrapee;

        public WrapperIcon() {
            this(null);
        }

        public WrapperIcon(Icon icon) {
            this.wrapee = icon;
        }

        public void setIcon(Icon icon) {
            this.wrapee = icon;
        }

        @Override
        public void paintIcon(Component arg0, Graphics g, int x, int y) {
            if (this.wrapee != null) {
                this.wrapee.paintIcon(arg0, g, x, y);
            } else {
                Graphics g2 = g.create();
                g2.setColor(Color.WHITE);
                g2.fillRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                g2.setColor(EMPTY_ICON_COLOR);
                g2.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                g2.drawRect(x + 1, y + 1, this.getIconWidth() - 3, this.getIconHeight() - 3);
                g2.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            if (this.wrapee != null) {
                return this.wrapee.getIconWidth();
            }
            return 16;
        }

        @Override
        public int getIconHeight() {
            if (this.wrapee != null) {
                return this.wrapee.getIconHeight();
            }
            return 16;
        }
    }
}

