/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.sources;

import java.util.Map;
import javax.json.stream.JsonCollectors;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.sources.SourceBounds;
import org.openstreetmap.josm.data.sources.SourceInfo;
import org.openstreetmap.josm.tools.Utils;

public class SourcePreferenceEntry<T extends SourceInfo<?, ?, ?, ?>> {
    @StructUtils.StructEntry
    public String name;
    @StructUtils.StructEntry
    public String id;
    @StructUtils.StructEntry
    public String type;
    @StructUtils.StructEntry
    public String url;
    @StructUtils.StructEntry
    public String eula;
    @StructUtils.StructEntry
    public String attribution_text;
    @StructUtils.StructEntry
    public String attribution_url;
    @StructUtils.StructEntry
    public String permission_reference_url;
    @StructUtils.StructEntry
    public String logo_image;
    @StructUtils.StructEntry
    public String logo_url;
    @StructUtils.StructEntry
    public String terms_of_use_text;
    @StructUtils.StructEntry
    public String terms_of_use_url;
    @StructUtils.StructEntry
    public String country_code = "";
    @StructUtils.StructEntry
    public String date;
    @StructUtils.StructEntry
    public String cookies;
    @StructUtils.StructEntry
    public String bounds;
    @StructUtils.StructEntry
    public String shapes;
    @StructUtils.StructEntry
    public String icon;
    @StructUtils.StructEntry
    public String description;
    @StructUtils.StructEntry
    public String default_layers;
    @StructUtils.StructEntry
    public Map<String, String> customHttpHeaders;
    @StructUtils.StructEntry
    public String category;

    public SourcePreferenceEntry() {
    }

    public SourcePreferenceEntry(T i) {
        this.name = ((TileSourceInfo)i).getName();
        this.id = ((TileSourceInfo)i).getId();
        this.type = ((SourceInfo)i).sourceType.getTypeString();
        this.url = ((TileSourceInfo)i).getUrl();
        this.eula = ((SourceInfo)i).eulaAcceptanceRequired;
        this.attribution_text = ((SourceInfo)i).attributionText;
        this.attribution_url = ((SourceInfo)i).attributionLinkURL;
        this.permission_reference_url = ((SourceInfo)i).permissionReferenceURL;
        this.date = ((SourceInfo)i).date;
        this.logo_image = ((SourceInfo)i).attributionImage;
        this.logo_url = ((SourceInfo)i).attributionImageURL;
        this.terms_of_use_text = ((SourceInfo)i).termsOfUseText;
        this.terms_of_use_url = ((SourceInfo)i).termsOfUseURL;
        this.country_code = ((SourceInfo)i).countryCode;
        this.cookies = ((TileSourceInfo)i).getCookies();
        this.icon = Utils.intern(((SourceInfo)i).icon);
        this.description = ((SourceInfo)i).description;
        String string = this.category = ((SourceInfo)i).category != null ? ((SourceInfo)i).category.getCategoryString() : null;
        if (((SourceInfo)i).bounds != null) {
            this.bounds = ((Bounds)((SourceInfo)i).bounds).encodeAsString(",");
            StringBuilder shapesString = new StringBuilder();
            for (Shape s : ((SourceBounds)((SourceInfo)i).bounds).getShapes()) {
                if (shapesString.length() > 0) {
                    shapesString.append(';');
                }
                shapesString.append(s.encodeAsString(","));
            }
            if (shapesString.length() > 0) {
                this.shapes = shapesString.toString();
            }
        }
        if (!((SourceInfo)i).defaultLayers.isEmpty()) {
            this.default_layers = ((SourceInfo)i).defaultLayers.stream().map(DefaultLayer::toJson).collect(JsonCollectors.toJsonArray()).toString();
        }
        this.customHttpHeaders = ((SourceInfo)i).customHttpHeaders;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getSimpleName()).append(" [name=").append(this.name);
        if (this.id != null) {
            s.append(" id=").append(this.id);
        }
        s.append(']');
        return s.toString();
    }
}

