/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.layer.MergeGpxLayerDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Stopwatch;
import org.openstreetmap.josm.tools.Utils;

public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer", new Object[0]), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer", new Object[0]), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge", new Object[0])), 77, 5006), true, "action/mergelayer", true);
        this.setHelpId(HelpUtil.ht("/Action/MergeLayer"));
    }

    protected Future<?> doMerge(List<? extends Layer> targetLayers, Collection<? extends Layer> sourceLayers) {
        boolean onlygpx = targetLayers.stream().allMatch(l -> l instanceof GpxLayer);
        AbstractMergeAction.TargetLayerDialogResult<Layer> res = MergeLayerAction.askTargetLayer(targetLayers, onlygpx, I18n.tr("Cut timewise overlapping parts of tracks", new Object[0]), onlygpx && Config.getPref().getBoolean("mergelayer.gpx.cut", false), I18n.tr("Merge layer", new Object[0]));
        Object targetLayer = res.selectedTargetLayer;
        if (targetLayer == null) {
            return null;
        }
        if (onlygpx) {
            Config.getPref().putBoolean("mergelayer.gpx.cut", res.checkboxTicked);
        }
        Object actionName = this.getValue("Name");
        if (onlygpx && res.checkboxTicked) {
            ArrayList<GpxLayer> layers = new ArrayList<GpxLayer>();
            layers.add((GpxLayer)targetLayer);
            for (Layer layer : sourceLayers) {
                if (layer == null || layer.equals(targetLayer)) continue;
                layers.add((GpxLayer)layer);
            }
            MergeGpxLayerDialog d = new MergeGpxLayerDialog((Component)MainApplication.getMainFrame(), layers);
            if (d.showDialog().getValue() == 1) {
                boolean bl = d.connectCuts();
                List<GpxLayer> sortedLayers = d.getSortedLayers();
                return MainApplication.worker.submit(() -> {
                    Stopwatch stopwatch = Stopwatch.createStarted();
                    for (int i = sortedLayers.size() - 2; i >= 0; --i) {
                        GpxLayer lower = (GpxLayer)sortedLayers.get(i + 1);
                        ((GpxLayer)sortedLayers.get(i)).mergeFrom(lower, true, connect);
                        GuiHelper.runInEDTAndWait(() -> this.getLayerManager().removeLayer(lower));
                    }
                    Logging.info(stopwatch.toString(String.valueOf(actionName)));
                });
            }
        }
        return MainApplication.worker.submit(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            boolean layerMerged = false;
            for (Layer sourceLayer : sourceLayers) {
                if (sourceLayer == null || sourceLayer.equals(targetLayer)) continue;
                if (sourceLayer instanceof OsmDataLayer && targetLayer instanceof OsmDataLayer && ((OsmDataLayer)sourceLayer).isUploadDiscouraged() != ((OsmDataLayer)targetLayer).isUploadDiscouraged() && Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> MergeLayerAction.warnMergingUploadDiscouragedLayers(sourceLayer, targetLayer)))) break;
                targetLayer.mergeFrom(sourceLayer);
                GuiHelper.runInEDTAndWait(() -> this.getLayerManager().removeLayer(sourceLayer));
                layerMerged = true;
            }
            if (layerMerged) {
                this.getLayerManager().setActiveLayer((Layer)targetLayer);
                Logging.info(stopwatch.toString(String.valueOf(actionName)));
            }
        });
    }

    public Future<?> merge(List<? extends Layer> sourceLayers) {
        return this.doMerge(sourceLayers, sourceLayers);
    }

    public Future<?> merge(Layer sourceLayer) {
        if (sourceLayer == null) {
            return null;
        }
        List<Layer> targetLayers = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(sourceLayer);
        if (targetLayers.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(sourceLayer);
            return null;
        }
        return this.doMerge(targetLayers, Collections.singleton(sourceLayer));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.merge(this.getSourceLayer());
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        GuiHelper.runInEDT(() -> {
            Layer sourceLayer = this.getSourceLayer();
            if (sourceLayer == null) {
                this.setEnabled(false);
            } else {
                try {
                    this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(sourceLayer).isEmpty());
                }
                catch (IllegalStateException e) {
                    this.setEnabled(false);
                    Logging.error(e);
                }
            }
        });
    }

    protected Layer getSourceLayer() {
        return this.getLayerManager().getActiveLayer();
    }

    public static final boolean warnMergingUploadDiscouragedLayers(Layer sourceLayer, Layer targetLayer) {
        return GuiHelper.warnUser(I18n.tr("Merging layers with different upload policies", new Object[0]), "<html>" + I18n.tr("You are about to merge data between layers ''{0}'' and ''{1}''.<br /><br />These layers have different upload policies and should not been merged as it.<br />Merging them will result to enforce the stricter policy (upload discouraged) to ''{1}''.<br /><br /><b>This is not the recommended way of merging such data</b>.<br />You should instead check and merge each object, one by one, by using ''<i>Merge selection</i>''.<br /><br />Are you sure you want to continue?", Utils.escapeReservedCharactersHTML(sourceLayer.getName()), Utils.escapeReservedCharactersHTML(targetLayer.getName()), Utils.escapeReservedCharactersHTML(targetLayer.getName())) + "</html>", ImageProvider.get("dialogs", "mergedown"), I18n.tr("Ignore this hint and merge anyway", new Object[0]));
    }
}

