/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.util.Arrays;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public enum ComparePairType {
    MY_WITH_THEIR(I18n.tr("My with Their", new Object[0]), ListRole.MY_ENTRIES, ListRole.THEIR_ENTRIES),
    MY_WITH_MERGED(I18n.tr("My with Merged", new Object[0]), ListRole.MY_ENTRIES, ListRole.MERGED_ENTRIES),
    THEIR_WITH_MERGED(I18n.tr("Their with Merged", new Object[0]), ListRole.THEIR_ENTRIES, ListRole.MERGED_ENTRIES);

    private final String displayName;
    private final ListRole[] participatingRoles;

    private ComparePairType(String displayName, ListRole ... participatingRoles) {
        this.displayName = displayName;
        this.participatingRoles = Utils.copyArray(participatingRoles);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isParticipatingIn(ListRole role) {
        return Arrays.stream(this.participatingRoles).anyMatch(r -> r == role);
    }

    public ListRole[] getParticipatingRoles() {
        return Utils.copyArray(this.participatingRoles);
    }

    public ListRole getOppositeRole(ListRole role) {
        if (!this.isParticipatingIn(role)) {
            throw new IllegalStateException(I18n.tr("Role {0} is not participating in compare pair {1}.", role.toString(), this.toString()));
        }
        if (this.participatingRoles[0] == role) {
            return this.participatingRoles[1];
        }
        return this.participatingRoles[0];
    }
}

