/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.KeyboardUtils;
import org.openstreetmap.josm.tools.Shortcut;

public class ReorderImageryLayersAction
extends JosmAction {
    public ReorderImageryLayersAction() {
        super(I18n.tr("Reorder imagery layers", new Object[0]), "dialogs/reorderlayers", I18n.tr("Reorders non-overlay imagery layers.", new Object[0]), Shortcut.registerMultiShortcuts("imagery:reorder", I18n.tr("Reorder imagery layers", new Object[0]), KeyboardUtils.getCharactersForKey('E', 0), 5003));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List layers = this.getNonOverlayImageryLayers().collect(Collectors.toList());
        int size = layers.size();
        if (size > 1) {
            this.getLayerManager().moveLayer((Layer)layers.get(0), this.getLayerManager().getLayers().indexOf(layers.get(size - 1)));
        }
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getNonOverlayImageryLayers().count() > 1L);
    }

    private Stream<ImageryLayer> getNonOverlayImageryLayers() {
        return this.getLayerManager().getLayersOfType(ImageryLayer.class).stream().filter(l -> !l.getInfo().isOverlay());
    }
}

